/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.gui.customcontrols.wizard;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import net.java.sip.communicator.impl.gui.customcontrols.wizard.WizardPanelNotFoundException;
import net.java.sip.communicator.service.gui.WizardPage;

public class WizardModel {
    public static final String CURRENT_PAGE_PROPERTY = "currentPageProperty";
    public static final String BACK_BUTTON_TEXT_PROPERTY = "backButtonTextProperty";
    public static final String BACK_BUTTON_ICON_PROPERTY = "backButtonIconProperty";
    public static final String BACK_BUTTON_ENABLED_PROPERTY = "backButtonEnabledProperty";
    public static final String NEXT_FINISH_BUTTON_TEXT_PROPERTY = "nextButtonTextProperty";
    public static final String NEXT_FINISH_BUTTON_ICON_PROPERTY = "nextButtonIconProperty";
    public static final String NEXT_FINISH_BUTTON_ENABLED_PROPERTY = "nextButtonEnabledProperty";
    public static final String CANCEL_BUTTON_TEXT_PROPERTY = "cancelButtonTextProperty";
    public static final String CANCEL_BUTTON_ICON_PROPERTY = "cancelButtonIconProperty";
    public static final String CANCEL_BUTTON_ENABLED_PROPERTY = "cancelButtonEnabledProperty";
    private WizardPage currentPanel;
    private final Map<Object, WizardPage> panelHashmap = new HashMap<Object, WizardPage>();
    private final Map<String, Object> buttonTextHashmap = new HashMap<String, Object>();
    private final Map<String, Icon> buttonIconHashmap = new HashMap<String, Icon>();
    private final Map<String, Boolean> buttonEnabledHashmap = new HashMap<String, Boolean>();
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    WizardPage getCurrentWizardPage() {
        return this.currentPanel;
    }

    void registerPage(Object id, WizardPage page) {
        this.panelHashmap.put(id, page);
    }

    void unregisterPage(Object id) {
        this.panelHashmap.remove(id);
    }

    WizardPage getWizardPage(Object id) {
        return this.panelHashmap.get(id);
    }

    Iterator<Map.Entry<Object, WizardPage>> getAllPages() {
        return this.panelHashmap.entrySet().iterator();
    }

    boolean setCurrentPanel(Object id) {
        WizardPage nextPanel = this.panelHashmap.get(id);
        if (nextPanel == null) {
            throw new WizardPanelNotFoundException();
        }
        WizardPage oldPanel = this.currentPanel;
        this.currentPanel = nextPanel;
        if (oldPanel != this.currentPanel) {
            this.firePropertyChange(CURRENT_PAGE_PROPERTY, oldPanel, this.currentPanel);
        }
        return true;
    }

    Object getBackButtonText() {
        return this.buttonTextHashmap.get(BACK_BUTTON_TEXT_PROPERTY);
    }

    void setBackButtonText(Object newText) {
        Object oldText = this.getBackButtonText();
        if (!newText.equals(oldText)) {
            this.buttonTextHashmap.put(BACK_BUTTON_TEXT_PROPERTY, newText);
            this.firePropertyChange(BACK_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Object getNextFinishButtonText() {
        return this.buttonTextHashmap.get(NEXT_FINISH_BUTTON_TEXT_PROPERTY);
    }

    void setNextFinishButtonText(Object newText) {
        Object oldText = this.getNextFinishButtonText();
        if (!newText.equals(oldText)) {
            this.buttonTextHashmap.put(NEXT_FINISH_BUTTON_TEXT_PROPERTY, newText);
            this.firePropertyChange(NEXT_FINISH_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Object getCancelButtonText() {
        return this.buttonTextHashmap.get(CANCEL_BUTTON_TEXT_PROPERTY);
    }

    void setCancelButtonText(Object newText) {
        Object oldText = this.getCancelButtonText();
        if (!newText.equals(oldText)) {
            this.buttonTextHashmap.put(CANCEL_BUTTON_TEXT_PROPERTY, newText);
            this.firePropertyChange(CANCEL_BUTTON_TEXT_PROPERTY, oldText, newText);
        }
    }

    Icon getBackButtonIcon() {
        return this.buttonIconHashmap.get(BACK_BUTTON_ICON_PROPERTY);
    }

    void setBackButtonIcon(Icon newIcon) {
        Icon oldIcon = this.getBackButtonIcon();
        if (!newIcon.equals(oldIcon)) {
            this.buttonIconHashmap.put(BACK_BUTTON_ICON_PROPERTY, newIcon);
            this.firePropertyChange(BACK_BUTTON_ICON_PROPERTY, oldIcon, newIcon);
        }
    }

    Icon getNextFinishButtonIcon() {
        return this.buttonIconHashmap.get(NEXT_FINISH_BUTTON_ICON_PROPERTY);
    }

    public void setNextFinishButtonIcon(Icon newIcon) {
        Icon oldIcon = this.getNextFinishButtonIcon();
        if (!newIcon.equals(oldIcon)) {
            this.buttonIconHashmap.put(NEXT_FINISH_BUTTON_ICON_PROPERTY, newIcon);
            this.firePropertyChange(NEXT_FINISH_BUTTON_ICON_PROPERTY, oldIcon, newIcon);
        }
    }

    Icon getCancelButtonIcon() {
        return this.buttonIconHashmap.get(CANCEL_BUTTON_ICON_PROPERTY);
    }

    void setCancelButtonIcon(Icon newIcon) {
        Icon oldIcon = this.getCancelButtonIcon();
        if (!newIcon.equals(oldIcon)) {
            this.buttonIconHashmap.put(CANCEL_BUTTON_ICON_PROPERTY, newIcon);
            this.firePropertyChange(CANCEL_BUTTON_ICON_PROPERTY, oldIcon, newIcon);
        }
    }

    Boolean getBackButtonEnabled() {
        return this.buttonEnabledHashmap.get(BACK_BUTTON_ENABLED_PROPERTY);
    }

    void setBackButtonEnabled(boolean enabled) {
        Boolean oldValue;
        Boolean newValue = enabled;
        if (!newValue.equals(oldValue = this.getBackButtonEnabled())) {
            this.buttonEnabledHashmap.put(BACK_BUTTON_ENABLED_PROPERTY, newValue);
            this.firePropertyChange(BACK_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    Boolean getNextFinishButtonEnabled() {
        return this.buttonEnabledHashmap.get(NEXT_FINISH_BUTTON_ENABLED_PROPERTY);
    }

    void setNextFinishButtonEnabled(boolean enabled) {
        Boolean oldValue;
        Boolean newValue = enabled;
        if (!newValue.equals(oldValue = this.getNextFinishButtonEnabled())) {
            this.buttonEnabledHashmap.put(NEXT_FINISH_BUTTON_ENABLED_PROPERTY, newValue);
            this.firePropertyChange(NEXT_FINISH_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    Boolean getCancelButtonEnabled() {
        return this.buttonEnabledHashmap.get(CANCEL_BUTTON_ENABLED_PROPERTY);
    }

    void setCancelButtonEnabled(boolean enabled) {
        Boolean oldValue;
        Boolean newValue = enabled;
        if (!newValue.equals(oldValue = this.getCancelButtonEnabled())) {
            this.buttonEnabledHashmap.put(CANCEL_BUTTON_ENABLED_PROPERTY, newValue);
            this.firePropertyChange(CANCEL_BUTTON_ENABLED_PROPERTY, oldValue, newValue);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener p) {
        this.propertyChangeSupport.addPropertyChangeListener(p);
    }

    public void removePropertyChangeListener(PropertyChangeListener p) {
        this.propertyChangeSupport.removePropertyChangeListener(p);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

