/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

class RtfToText {
    private Reader r;
    private StringBuilder sb;
    private StringBuilder controlWord;
    private int blockCount;
    private boolean inControlWord;

    private RtfToText(Reader reader) {
        this.r = reader;
        this.sb = new StringBuilder();
        this.controlWord = new StringBuilder();
        this.blockCount = 0;
        this.inControlWord = false;
    }

    private String convert() throws IOException {
        int n = this.r.read();
        if (n != 123) {
            throw new IOException("Invalid RTF file");
        }
        block7: while ((n = this.r.read()) != -1) {
            char c = (char)n;
            switch (c) {
                case '{': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('{');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        continue block7;
                    }
                    ++this.blockCount;
                    continue block7;
                }
                case '}': {
                    if (this.inControlWord && this.controlWord.length() == 0) {
                        this.sb.append('}');
                        this.controlWord.setLength(0);
                        this.inControlWord = false;
                        continue block7;
                    }
                    --this.blockCount;
                    continue block7;
                }
                case '\\': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        if (this.controlWord.length() == 0) {
                            this.sb.append('\\');
                            this.controlWord.setLength(0);
                            this.inControlWord = false;
                            continue block7;
                        }
                        this.endControlWord();
                        this.inControlWord = true;
                        continue block7;
                    }
                    this.inControlWord = true;
                    continue block7;
                }
                case ' ': {
                    if (this.blockCount != 0) continue block7;
                    if (this.inControlWord) {
                        this.endControlWord();
                        continue block7;
                    }
                    this.sb.append(' ');
                    continue block7;
                }
                case '\n': 
                case '\r': {
                    if (this.blockCount != 0 || !this.inControlWord) continue block7;
                    this.endControlWord();
                    continue block7;
                }
            }
            if (this.blockCount != 0) continue;
            if (this.inControlWord) {
                this.controlWord.append(c);
                continue;
            }
            this.sb.append(c);
        }
        return this.sb.toString();
    }

    private void endControlWord() {
        String string = this.controlWord.toString();
        if ("par".equals(string)) {
            this.sb.append('\n');
        } else if ("tab".equals(string)) {
            this.sb.append('\t');
        }
        this.controlWord.setLength(0);
        this.inControlWord = false;
    }

    public static String getPlainText(byte[] byArray) throws IOException {
        return RtfToText.getPlainText(new ByteArrayInputStream(byArray));
    }

    public static String getPlainText(File file) throws IOException {
        return RtfToText.getPlainText(new BufferedReader(new FileReader(file)));
    }

    public static String getPlainText(InputStream inputStream) throws IOException {
        return RtfToText.getPlainText(new InputStreamReader(inputStream, "US-ASCII"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPlainText(Reader reader) throws IOException {
        try {
            RtfToText rtfToText = new RtfToText(reader);
            String string = rtfToText.convert();
            return string;
        }
        finally {
            reader.close();
        }
    }

    public static String getPlainText(String string) throws IOException {
        return RtfToText.getPlainText(new StringReader(string));
    }
}

