/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model;

import com.thoughtworks.qdox.JavaClassContext;
import com.thoughtworks.qdox.model.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.Annotation;
import com.thoughtworks.qdox.model.JavaClass;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JavaPackage
extends AbstractBaseJavaEntity {
    private JavaClassContext context;
    private String name;
    private Annotation[] annotations = new Annotation[0];
    private int lineNumber = -1;
    private List classes = new ArrayList();

    public JavaPackage() {
    }

    public JavaPackage(String string) {
        this(string, null);
    }

    public JavaPackage(String string, Map map) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotation[] annotationArray) {
        this.annotations = annotationArray;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public void setContext(JavaClassContext javaClassContext) {
        this.context = javaClassContext;
    }

    public void addClass(JavaClass javaClass) {
        javaClass.setJavaPackage(this);
        this.classes.add(javaClass);
    }

    public JavaClass[] getClasses() {
        if (this == this.context.getPackageByName(this.name)) {
            return this.classes.toArray(new JavaClass[this.classes.size()]);
        }
        return this.context.getPackageByName(this.name).getClasses();
    }

    public JavaPackage getParentPackage() {
        String string = this.name.substring(0, this.name.lastIndexOf("."));
        return this.context.getPackageByName(string);
    }

    public JavaPackage[] getSubPackages() {
        String string = this.name + ".";
        JavaPackage[] javaPackageArray = this.context.getPackages();
        ArrayList<JavaPackage> arrayList = new ArrayList<JavaPackage>();
        for (int i = 0; i < javaPackageArray.length; ++i) {
            String string2 = javaPackageArray[i].getName();
            if (!string2.startsWith(string) || string2.substring(string.length()).indexOf(".") > -1) continue;
            arrayList.add(this.context.getPackageByName(string2));
        }
        return arrayList.toArray(new JavaPackage[arrayList.size()]);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        JavaPackage javaPackage = (JavaPackage)object;
        return this.name.equals(javaPackage.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "package " + this.name;
    }
}

