/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.fasterxml.jackson.databind.jsonschema.JsonSerializableSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.impl.PropertyBasedObjectIdGenerator;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.ser.std.EnumSerializer;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.Converter;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;

public abstract class BeanSerializerBase
extends StdSerializer<Object>
implements ContextualSerializer,
ResolvableSerializer,
JsonFormatVisitable,
SchemaAware {
    protected static final PropertyName NAME_FOR_OBJECT_REF = new PropertyName("#object-ref");
    protected static final BeanPropertyWriter[] NO_PROPS = new BeanPropertyWriter[0];
    protected final BeanPropertyWriter[] _props;
    protected final BeanPropertyWriter[] _filteredProps;
    protected final AnyGetterWriter _anyGetterWriter;
    protected final Object _propertyFilterId;
    protected final AnnotatedMember _typeId;
    protected final ObjectIdWriter _objectIdWriter;
    protected final JsonFormat.Shape _serializationShape;

    protected BeanSerializerBase(JavaType javaType, BeanSerializerBuilder beanSerializerBuilder, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super(javaType);
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        if (beanSerializerBuilder == null) {
            this._typeId = null;
            this._anyGetterWriter = null;
            this._propertyFilterId = null;
            this._objectIdWriter = null;
            this._serializationShape = null;
        } else {
            this._typeId = beanSerializerBuilder.getTypeId();
            this._anyGetterWriter = beanSerializerBuilder.getAnyGetter();
            this._propertyFilterId = beanSerializerBuilder.getFilterId();
            this._objectIdWriter = beanSerializerBuilder.getObjectIdWriter();
            JsonFormat.Value value = beanSerializerBuilder.getBeanDescription().findExpectedFormat(null);
            this._serializationShape = value == null ? null : value.getShape();
        }
    }

    public BeanSerializerBase(BeanSerializerBase beanSerializerBase, BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        super(beanSerializerBase._handledType);
        this._props = beanPropertyWriterArray;
        this._filteredProps = beanPropertyWriterArray2;
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter) {
        this(beanSerializerBase, objectIdWriter, beanSerializerBase._propertyFilterId);
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter, Object object) {
        super(beanSerializerBase._handledType);
        this._props = beanSerializerBase._props;
        this._filteredProps = beanSerializerBase._filteredProps;
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = objectIdWriter;
        this._propertyFilterId = object;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    @Deprecated
    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, String[] stringArray) {
        this(beanSerializerBase, ArrayBuilders.arrayToSet(stringArray));
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, Set<String> set) {
        super(beanSerializerBase._handledType);
        BeanPropertyWriter[] beanPropertyWriterArray = beanSerializerBase._props;
        BeanPropertyWriter[] beanPropertyWriterArray2 = beanSerializerBase._filteredProps;
        int n = beanPropertyWriterArray.length;
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(n);
        ArrayList<BeanPropertyWriter> arrayList2 = beanPropertyWriterArray2 == null ? null : new ArrayList<BeanPropertyWriter>(n);
        for (int i = 0; i < n; ++i) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i];
            if (set != null && set.contains(beanPropertyWriter.getName())) continue;
            arrayList.add(beanPropertyWriter);
            if (beanPropertyWriterArray2 == null) continue;
            arrayList2.add(beanPropertyWriterArray2[i]);
        }
        this._props = arrayList.toArray(new BeanPropertyWriter[arrayList.size()]);
        this._filteredProps = arrayList2 == null ? null : arrayList2.toArray(new BeanPropertyWriter[arrayList2.size()]);
        this._typeId = beanSerializerBase._typeId;
        this._anyGetterWriter = beanSerializerBase._anyGetterWriter;
        this._objectIdWriter = beanSerializerBase._objectIdWriter;
        this._propertyFilterId = beanSerializerBase._propertyFilterId;
        this._serializationShape = beanSerializerBase._serializationShape;
    }

    public abstract BeanSerializerBase withObjectIdWriter(ObjectIdWriter var1);

    protected abstract BeanSerializerBase withIgnorals(Set<String> var1);

    @Deprecated
    protected BeanSerializerBase withIgnorals(String[] stringArray) {
        return this.withIgnorals(ArrayBuilders.arrayToSet(stringArray));
    }

    protected abstract BeanSerializerBase asArraySerializer();

    public abstract BeanSerializerBase withFilterId(Object var1);

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase) {
        this(beanSerializerBase, beanSerializerBase._props, beanSerializerBase._filteredProps);
    }

    protected BeanSerializerBase(BeanSerializerBase beanSerializerBase, NameTransformer nameTransformer) {
        this(beanSerializerBase, BeanSerializerBase.rename(beanSerializerBase._props, nameTransformer), BeanSerializerBase.rename(beanSerializerBase._filteredProps, nameTransformer));
    }

    private static final BeanPropertyWriter[] rename(BeanPropertyWriter[] beanPropertyWriterArray, NameTransformer nameTransformer) {
        if (beanPropertyWriterArray == null || beanPropertyWriterArray.length == 0 || nameTransformer == null || nameTransformer == NameTransformer.NOP) {
            return beanPropertyWriterArray;
        }
        int n = beanPropertyWriterArray.length;
        BeanPropertyWriter[] beanPropertyWriterArray2 = new BeanPropertyWriter[n];
        for (int i = 0; i < n; ++i) {
            BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[i];
            if (beanPropertyWriter == null) continue;
            beanPropertyWriterArray2[i] = beanPropertyWriter.rename(nameTransformer);
        }
        return beanPropertyWriterArray2;
    }

    @Override
    public void resolve(SerializerProvider serializerProvider) throws JsonMappingException {
        int n = this._filteredProps == null ? 0 : this._filteredProps.length;
        int n2 = this._props.length;
        for (int i = 0; i < n2; ++i) {
            Serializable serializable;
            JsonSerializer<Object> jsonSerializer;
            BeanPropertyWriter beanPropertyWriter = this._props[i];
            if (!beanPropertyWriter.willSuppressNulls() && !beanPropertyWriter.hasNullSerializer() && (jsonSerializer = serializerProvider.findNullValueSerializer(beanPropertyWriter)) != null) {
                beanPropertyWriter.assignNullSerializer(jsonSerializer);
                if (i < n && (serializable = this._filteredProps[i]) != null) {
                    ((BeanPropertyWriter)serializable).assignNullSerializer(jsonSerializer);
                }
            }
            if (beanPropertyWriter.hasSerializer()) continue;
            jsonSerializer = this.findConvertingSerializer(serializerProvider, beanPropertyWriter);
            if (jsonSerializer == null) {
                TypeSerializer typeSerializer;
                serializable = beanPropertyWriter.getSerializationType();
                if (serializable == null && !((JavaType)(serializable = beanPropertyWriter.getType())).isFinal()) {
                    if (!((JavaType)serializable).isContainerType() && ((JavaType)serializable).containedTypeCount() <= 0) continue;
                    beanPropertyWriter.setNonTrivialBaseType((JavaType)serializable);
                    continue;
                }
                jsonSerializer = serializerProvider.findValueSerializer((JavaType)serializable, (BeanProperty)beanPropertyWriter);
                if (((JavaType)serializable).isContainerType() && (typeSerializer = (TypeSerializer)((JavaType)serializable).getContentType().getTypeHandler()) != null && jsonSerializer instanceof ContainerSerializer) {
                    ContainerSerializer<?> containerSerializer = ((ContainerSerializer)jsonSerializer).withValueTypeSerializer(typeSerializer);
                    jsonSerializer = containerSerializer;
                }
            }
            beanPropertyWriter.assignSerializer(jsonSerializer);
            if (i >= n || (serializable = this._filteredProps[i]) == null) continue;
            ((BeanPropertyWriter)serializable).assignSerializer(jsonSerializer);
        }
        if (this._anyGetterWriter != null) {
            this._anyGetterWriter.resolve(serializerProvider);
        }
    }

    protected JsonSerializer<Object> findConvertingSerializer(SerializerProvider serializerProvider, BeanPropertyWriter beanPropertyWriter) throws JsonMappingException {
        Object object;
        AnnotatedMember annotatedMember;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        if (annotationIntrospector != null && (annotatedMember = beanPropertyWriter.getMember()) != null && (object = annotationIntrospector.findSerializationConverter(annotatedMember)) != null) {
            Converter<Object, Object> converter = serializerProvider.converterInstance(beanPropertyWriter.getMember(), object);
            JavaType javaType = converter.getOutputType(serializerProvider.getTypeFactory());
            JsonSerializer<Object> jsonSerializer = javaType.isJavaLangObject() ? null : serializerProvider.findValueSerializer(javaType, (BeanProperty)beanPropertyWriter);
            return new StdDelegatingSerializer(converter, javaType, jsonSerializer);
        }
        return null;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) throws JsonMappingException {
        Object object;
        BeanSerializerBase beanSerializerBase;
        AnnotationIntrospector annotationIntrospector = serializerProvider.getAnnotationIntrospector();
        AnnotatedMember annotatedMember = beanProperty == null || annotationIntrospector == null ? null : beanProperty.getMember();
        SerializationConfig serializationConfig = serializerProvider.getConfig();
        JsonFormat.Value value = this.findFormatOverrides(serializerProvider, beanProperty, this.handledType());
        JsonFormat.Shape shape = null;
        if (value != null && value.hasShape() && (shape = value.getShape()) != JsonFormat.Shape.ANY && shape != this._serializationShape && this._handledType.isEnum()) {
            switch (shape) {
                case STRING: 
                case NUMBER: 
                case NUMBER_INT: {
                    BeanDescription beanDescription = serializationConfig.introspectClassAnnotations(this._handledType);
                    EnumSerializer enumSerializer = EnumSerializer.construct(this._handledType, serializerProvider.getConfig(), beanDescription, value);
                    return serializerProvider.handlePrimaryContextualization(enumSerializer, beanProperty);
                }
            }
        }
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        Set set = null;
        ObjectIdGenerator<?> objectIdGenerator = null;
        if (annotatedMember != null) {
            Object object2;
            beanSerializerBase = annotationIntrospector.findPropertyIgnorals(annotatedMember);
            if (beanSerializerBase != null) {
                set = beanSerializerBase.findIgnoredForSerialization();
            }
            if ((object = annotationIntrospector.findObjectIdInfo(annotatedMember)) == null) {
                if (objectIdWriter != null) {
                    object = annotationIntrospector.findObjectReferenceInfo(annotatedMember, new ObjectIdInfo(NAME_FOR_OBJECT_REF, null, null, null));
                    objectIdWriter = this._objectIdWriter.withAlwaysAsId(((ObjectIdInfo)object).getAlwaysAsId());
                }
            } else {
                object = annotationIntrospector.findObjectReferenceInfo(annotatedMember, (ObjectIdInfo)object);
                Class<? extends ObjectIdGenerator<?>> clazz = ((ObjectIdInfo)object).getGeneratorType();
                JavaType javaType = serializerProvider.constructType(clazz);
                JavaType javaType2 = serializerProvider.getTypeFactory().findTypeParameters(javaType, ObjectIdGenerator.class)[0];
                if (clazz == ObjectIdGenerators.PropertyGenerator.class) {
                    String string = ((ObjectIdInfo)object).getPropertyName().getSimpleName();
                    BeanPropertyWriter beanPropertyWriter = null;
                    int n = 0;
                    int n2 = this._props.length;
                    while (true) {
                        if (n == n2) {
                            throw new IllegalArgumentException("Invalid Object Id definition for " + this._handledType.getName() + ": can not find property with name '" + string + "'");
                        }
                        BeanPropertyWriter beanPropertyWriter2 = this._props[n];
                        if (string.equals(beanPropertyWriter2.getName())) {
                            beanPropertyWriter = beanPropertyWriter2;
                            if (n <= 0) break;
                            System.arraycopy(this._props, 0, this._props, 1, n);
                            this._props[0] = beanPropertyWriter;
                            if (this._filteredProps == null) break;
                            BeanPropertyWriter beanPropertyWriter3 = this._filteredProps[n];
                            System.arraycopy(this._filteredProps, 0, this._filteredProps, 1, n);
                            this._filteredProps[0] = beanPropertyWriter3;
                            break;
                        }
                        ++n;
                    }
                    javaType2 = beanPropertyWriter.getType();
                    object2 = new PropertyBasedObjectIdGenerator((ObjectIdInfo)object, beanPropertyWriter);
                    objectIdWriter = ObjectIdWriter.construct(javaType2, (PropertyName)null, object2, ((ObjectIdInfo)object).getAlwaysAsId());
                } else {
                    object2 = serializerProvider.objectIdGeneratorInstance(annotatedMember, (ObjectIdInfo)object);
                    objectIdWriter = ObjectIdWriter.construct(javaType2, ((ObjectIdInfo)object).getPropertyName(), object2, ((ObjectIdInfo)object).getAlwaysAsId());
                }
            }
            if (!((object2 = annotationIntrospector.findFilterId(annotatedMember)) == null || this._propertyFilterId != null && object2.equals(this._propertyFilterId))) {
                objectIdGenerator = object2;
            }
        }
        beanSerializerBase = this;
        if (objectIdWriter != null && (objectIdWriter = objectIdWriter.withSerializer((JsonSerializer<?>)(object = serializerProvider.findValueSerializer(objectIdWriter.idType, beanProperty)))) != this._objectIdWriter) {
            beanSerializerBase = beanSerializerBase.withObjectIdWriter(objectIdWriter);
        }
        if (set != null && !set.isEmpty()) {
            beanSerializerBase = beanSerializerBase.withIgnorals(set);
        }
        if (objectIdGenerator != null) {
            beanSerializerBase = beanSerializerBase.withFilterId(objectIdGenerator);
        }
        if (shape == null) {
            shape = this._serializationShape;
        }
        if (shape == JsonFormat.Shape.ARRAY) {
            return beanSerializerBase.asArraySerializer();
        }
        return beanSerializerBase;
    }

    @Override
    public Iterator<PropertyWriter> properties() {
        return Arrays.asList(this._props).iterator();
    }

    @Override
    public boolean usesObjectId() {
        return this._objectIdWriter != null;
    }

    @Override
    public abstract void serialize(Object var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        String string;
        if (this._objectIdWriter != null) {
            jsonGenerator.setCurrentValue(object);
            this._serializeWithObjectId(object, jsonGenerator, serializerProvider, typeSerializer);
            return;
        }
        String string2 = string = this._typeId == null ? null : this._customTypeId(object);
        if (string == null) {
            typeSerializer.writeTypePrefixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypePrefixForObject(object, jsonGenerator, string);
        }
        jsonGenerator.setCurrentValue(object);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (string == null) {
            typeSerializer.writeTypeSuffixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypeSuffixForObject(object, jsonGenerator, string);
        }
    }

    protected final void _serializeWithObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, boolean bl) throws IOException {
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableObjectId writableObjectId = serializerProvider.findObjectId(object, objectIdWriter.generator);
        if (writableObjectId.writeAsId(jsonGenerator, serializerProvider, objectIdWriter)) {
            return;
        }
        Object object2 = writableObjectId.generateId(object);
        if (objectIdWriter.alwaysAsId) {
            objectIdWriter.serializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        if (bl) {
            jsonGenerator.writeStartObject(object);
        }
        writableObjectId.writeAsField(jsonGenerator, serializerProvider, objectIdWriter);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (bl) {
            jsonGenerator.writeEndObject();
        }
    }

    protected final void _serializeWithObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        WritableObjectId writableObjectId = serializerProvider.findObjectId(object, objectIdWriter.generator);
        if (writableObjectId.writeAsId(jsonGenerator, serializerProvider, objectIdWriter)) {
            return;
        }
        Object object2 = writableObjectId.generateId(object);
        if (objectIdWriter.alwaysAsId) {
            objectIdWriter.serializer.serialize(object2, jsonGenerator, serializerProvider);
            return;
        }
        this._serializeObjectId(object, jsonGenerator, serializerProvider, typeSerializer, writableObjectId);
    }

    protected void _serializeObjectId(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer, WritableObjectId writableObjectId) throws IOException {
        String string;
        ObjectIdWriter objectIdWriter = this._objectIdWriter;
        String string2 = string = this._typeId == null ? null : this._customTypeId(object);
        if (string == null) {
            typeSerializer.writeTypePrefixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypePrefixForObject(object, jsonGenerator, string);
        }
        writableObjectId.writeAsField(jsonGenerator, serializerProvider, objectIdWriter);
        if (this._propertyFilterId != null) {
            this.serializeFieldsFiltered(object, jsonGenerator, serializerProvider);
        } else {
            this.serializeFields(object, jsonGenerator, serializerProvider);
        }
        if (string == null) {
            typeSerializer.writeTypeSuffixForObject(object, jsonGenerator);
        } else {
            typeSerializer.writeCustomTypeSuffixForObject(object, jsonGenerator, string);
        }
    }

    protected final String _customTypeId(Object object) {
        Object object2 = this._typeId.getValue(object);
        if (object2 == null) {
            return "";
        }
        return object2 instanceof String ? (String)object2 : object2.toString();
    }

    protected void serializeFields(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        int n;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getActiveView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                beanPropertyWriter.serializeAsField(object, jsonGenerator, serializerProvider);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndSerialize(object, jsonGenerator, serializerProvider);
            }
        }
        catch (Exception exception) {
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException((Closeable)jsonGenerator, "Infinite recursion (StackOverflowError)", (Throwable)stackOverflowError);
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    protected void serializeFieldsFiltered(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonGenerationException {
        int n;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && serializerProvider.getActiveView() != null ? this._filteredProps : this._props;
        PropertyFilter propertyFilter = this.findPropertyFilter(serializerProvider, this._propertyFilterId, object);
        if (propertyFilter == null) {
            this.serializeFields(object, jsonGenerator, serializerProvider);
            return;
        }
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) continue;
                propertyFilter.serializeAsField(object, jsonGenerator, serializerProvider, beanPropertyWriter);
            }
            if (this._anyGetterWriter != null) {
                this._anyGetterWriter.getAndFilter(object, jsonGenerator, serializerProvider, propertyFilter);
            }
        }
        catch (Exception exception) {
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, string);
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = new JsonMappingException((Closeable)jsonGenerator, "Infinite recursion (StackOverflowError)", (Throwable)stackOverflowError);
            String string = n == beanPropertyWriterArray.length ? "[anySetter]" : beanPropertyWriterArray[n].getName();
            jsonMappingException.prependPath(new JsonMappingException.Reference(object, string));
            throw jsonMappingException;
        }
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) throws JsonMappingException {
        Object object;
        ObjectNode objectNode = this.createSchemaNode("object", true);
        JsonSerializableSchema jsonSerializableSchema = this._handledType.getAnnotation(JsonSerializableSchema.class);
        if (jsonSerializableSchema != null && (object = jsonSerializableSchema.id()) != null && ((String)object).length() > 0) {
            objectNode.put("id", (String)object);
        }
        object = objectNode.objectNode();
        PropertyFilter propertyFilter = this._propertyFilterId != null ? this.findPropertyFilter(serializerProvider, this._propertyFilterId, null) : null;
        for (int i = 0; i < this._props.length; ++i) {
            BeanPropertyWriter beanPropertyWriter = this._props[i];
            if (propertyFilter == null) {
                beanPropertyWriter.depositSchemaProperty((ObjectNode)object, serializerProvider);
                continue;
            }
            propertyFilter.depositSchemaProperty((PropertyWriter)beanPropertyWriter, (ObjectNode)object, serializerProvider);
        }
        objectNode.set("properties", (JsonNode)object);
        return objectNode;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        if (jsonFormatVisitorWrapper == null) {
            return;
        }
        JsonObjectFormatVisitor jsonObjectFormatVisitor = jsonFormatVisitorWrapper.expectObjectFormat(javaType);
        if (jsonObjectFormatVisitor == null) {
            return;
        }
        SerializerProvider serializerProvider = jsonFormatVisitorWrapper.getProvider();
        if (this._propertyFilterId != null) {
            PropertyFilter propertyFilter = this.findPropertyFilter(jsonFormatVisitorWrapper.getProvider(), this._propertyFilterId, null);
            int n = this._props.length;
            for (int i = 0; i < n; ++i) {
                propertyFilter.depositSchemaProperty((PropertyWriter)this._props[i], jsonObjectFormatVisitor, serializerProvider);
            }
        } else {
            Class<?> clazz = this._filteredProps == null || serializerProvider == null ? null : serializerProvider.getActiveView();
            for (BeanPropertyWriter beanPropertyWriter : clazz != null ? this._filteredProps : this._props) {
                if (beanPropertyWriter == null) continue;
                beanPropertyWriter.depositSchemaProperty(jsonObjectFormatVisitor, serializerProvider);
            }
        }
    }
}

