/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

@GwtCompatible(emulated=true)
public final class Callables {
    private Callables() {
    }

    public static <T> Callable<T> returning(final @Nullable T t) {
        return new Callable<T>(){

            @Override
            public T call() {
                return t;
            }
        };
    }

    @GwtIncompatible(value="threads")
    static <T> Callable<T> threadRenaming(final Callable<T> callable, final Supplier<String> supplier) {
        Preconditions.checkNotNull(supplier);
        Preconditions.checkNotNull(callable);
        return new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                Thread thread = Thread.currentThread();
                String string = thread.getName();
                boolean bl = Callables.trySetName((String)supplier.get(), thread);
                try {
                    Object v = callable.call();
                    return v;
                }
                finally {
                    if (bl) {
                        Callables.trySetName(string, thread);
                    }
                }
            }
        };
    }

    @GwtIncompatible(value="threads")
    static Runnable threadRenaming(final Runnable runnable, final Supplier<String> supplier) {
        Preconditions.checkNotNull(supplier);
        Preconditions.checkNotNull(runnable);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                String string = thread.getName();
                boolean bl = Callables.trySetName((String)supplier.get(), thread);
                try {
                    runnable.run();
                }
                finally {
                    if (bl) {
                        Callables.trySetName(string, thread);
                    }
                }
            }
        };
    }

    @GwtIncompatible(value="threads")
    private static boolean trySetName(String string, Thread thread) {
        try {
            thread.setName(string);
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }
}

