/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;

public class DefaultSocketFactory
extends SocketFactory {
    private final Proxy connProxy;

    public DefaultSocketFactory() {
        this(null);
    }

    public DefaultSocketFactory(Proxy proxy) {
        this.connProxy = proxy;
    }

    @Override
    public Socket createSocket() throws IOException {
        if (this.connProxy != null) {
            return new Socket(this.connProxy);
        }
        return new Socket();
    }

    @Override
    public Socket createSocket(String string, int n) throws UnknownHostException, IOException {
        if (this.connProxy != null) {
            Socket socket = new Socket(this.connProxy);
            socket.connect(new InetSocketAddress(string, n));
            return socket;
        }
        return new Socket(string, n);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        if (this.connProxy != null) {
            Socket socket = new Socket(this.connProxy);
            socket.connect(new InetSocketAddress(inetAddress, n));
            return socket;
        }
        return new Socket(inetAddress, n);
    }

    @Override
    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws UnknownHostException, IOException {
        if (this.connProxy != null) {
            Socket socket = new Socket(this.connProxy);
            socket.bind(new InetSocketAddress(inetAddress, n2));
            socket.connect(new InetSocketAddress(string, n));
            return socket;
        }
        return new Socket(string, n, inetAddress, n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        if (this.connProxy != null) {
            Socket socket = new Socket(this.connProxy);
            socket.bind(new InetSocketAddress(inetAddress2, n2));
            socket.connect(new InetSocketAddress(inetAddress, n));
            return socket;
        }
        return new Socket(inetAddress, n, inetAddress2, n2);
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        return new ServerSocket(n);
    }

    public ServerSocket createServerSocket(int n, int n2) throws IOException {
        return new ServerSocket(n, n2);
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        return new ServerSocket(n, n2, inetAddress);
    }
}

