/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.exec.environment;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.exec.environment.DefaultProcessingEnvironment;

public class EnvironmentUtils {
    private static final DefaultProcessingEnvironment PROCESSING_ENVIRONMENT_IMPLEMENTATION = new DefaultProcessingEnvironment();

    private EnvironmentUtils() {
    }

    public static String[] toStrings(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        String[] stringArray = new String[map.size()];
        int n = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey() == null ? "" : entry.getKey().toString();
            String string2 = entry.getValue() == null ? "" : entry.getValue().toString();
            stringArray[n] = string + "=" + string2;
            ++n;
        }
        return stringArray;
    }

    public static Map<String, String> getProcEnvironment() throws IOException {
        return PROCESSING_ENVIRONMENT_IMPLEMENTATION.getProcEnvironment();
    }

    public static void addVariableToEnvironment(Map<String, String> map, String string) {
        String[] stringArray = EnvironmentUtils.parseEnvironmentVariable(string);
        map.put(stringArray[0], stringArray[1]);
    }

    private static String[] parseEnvironmentVariable(String string) {
        int n = string.indexOf(61);
        if (n == -1) {
            throw new IllegalArgumentException("Environment variable for this platform must contain an equals sign ('=')");
        }
        String[] stringArray = new String[]{string.substring(0, n), string.substring(n + 1)};
        return stringArray;
    }
}

