/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.gzip;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipParameters;

public class GzipCompressorInputStream
extends CompressorInputStream {
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private static final int FRESERVED = 224;
    private final InputStream in;
    private final boolean decompressConcatenated;
    private final byte[] buf = new byte[8192];
    private int bufUsed = 0;
    private Inflater inf = new Inflater(true);
    private final CRC32 crc = new CRC32();
    private boolean endReached = false;
    private final byte[] oneByte = new byte[1];
    private final GzipParameters parameters = new GzipParameters();

    public GzipCompressorInputStream(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    public GzipCompressorInputStream(InputStream inputStream, boolean bl) throws IOException {
        this.in = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        this.decompressConcatenated = bl;
        this.init(true);
    }

    public GzipParameters getMetaData() {
        return this.parameters;
    }

    private boolean init(boolean bl) throws IOException {
        assert (bl || this.decompressConcatenated);
        int n = this.in.read();
        int n2 = this.in.read();
        if (n == -1 && !bl) {
            return false;
        }
        if (n != 31 || n2 != 139) {
            throw new IOException(bl ? "Input is not in the .gz format" : "Garbage after a valid .gz stream");
        }
        DataInputStream dataInputStream = new DataInputStream(this.in);
        int n3 = dataInputStream.readUnsignedByte();
        if (n3 != 8) {
            throw new IOException("Unsupported compression method " + n3 + " in the .gz header");
        }
        int n4 = dataInputStream.readUnsignedByte();
        if ((n4 & 0xE0) != 0) {
            throw new IOException("Reserved flags are set in the .gz header");
        }
        this.parameters.setModificationTime(this.readLittleEndianInt(dataInputStream) * 1000L);
        switch (dataInputStream.readUnsignedByte()) {
            case 2: {
                this.parameters.setCompressionLevel(9);
                break;
            }
            case 4: {
                this.parameters.setCompressionLevel(1);
                break;
            }
        }
        this.parameters.setOperatingSystem(dataInputStream.readUnsignedByte());
        if ((n4 & 4) != 0) {
            int n5 = dataInputStream.readUnsignedByte();
            n5 |= dataInputStream.readUnsignedByte() << 8;
            while (n5-- > 0) {
                dataInputStream.readUnsignedByte();
            }
        }
        if ((n4 & 8) != 0) {
            this.parameters.setFilename(new String(this.readToNull(dataInputStream), "ISO-8859-1"));
        }
        if ((n4 & 0x10) != 0) {
            this.parameters.setComment(new String(this.readToNull(dataInputStream), "ISO-8859-1"));
        }
        if ((n4 & 2) != 0) {
            dataInputStream.readShort();
        }
        this.inf.reset();
        this.crc.reset();
        return true;
    }

    private byte[] readToNull(DataInputStream dataInputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while ((n = dataInputStream.readUnsignedByte()) != 0) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private long readLittleEndianInt(DataInputStream dataInputStream) throws IOException {
        return (long)(dataInputStream.readUnsignedByte() | dataInputStream.readUnsignedByte() << 8 | dataInputStream.readUnsignedByte() << 16) | (long)dataInputStream.readUnsignedByte() << 24;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.oneByte, 0, 1) == -1 ? -1 : this.oneByte[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.endReached) {
            return -1;
        }
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            if (this.inf.needsInput()) {
                this.in.mark(this.buf.length);
                this.bufUsed = this.in.read(this.buf);
                if (this.bufUsed == -1) {
                    throw new EOFException();
                }
                this.inf.setInput(this.buf, 0, this.bufUsed);
            }
            try {
                n4 = this.inf.inflate(byArray, n, n2);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException("Gzip-compressed data is corrupt");
            }
            this.crc.update(byArray, n, n4);
            n += n4;
            n2 -= n4;
            n3 += n4;
            this.count(n4);
            if (!this.inf.finished()) continue;
            this.in.reset();
            int n5 = this.bufUsed - this.inf.getRemaining();
            if (this.in.skip(n5) != (long)n5) {
                throw new IOException();
            }
            this.bufUsed = 0;
            DataInputStream dataInputStream = new DataInputStream(this.in);
            long l = this.readLittleEndianInt(dataInputStream);
            if (l != this.crc.getValue()) {
                throw new IOException("Gzip-compressed data is corrupt (CRC32 error)");
            }
            long l2 = this.readLittleEndianInt(dataInputStream);
            if (l2 != (this.inf.getBytesWritten() & 0xFFFFFFFFL)) {
                throw new IOException("Gzip-compressed data is corrupt(uncompressed size mismatch)");
            }
            if (this.decompressConcatenated && this.init(false)) continue;
            this.inf.end();
            this.inf = null;
            this.endReached = true;
            return n3 == 0 ? -1 : n3;
        }
        return n3;
    }

    public static boolean matches(byte[] byArray, int n) {
        if (n < 2) {
            return false;
        }
        if (byArray[0] != 31) {
            return false;
        }
        return byArray[1] == -117;
    }

    @Override
    public void close() throws IOException {
        if (this.inf != null) {
            this.inf.end();
            this.inf = null;
        }
        if (this.in != System.in) {
            this.in.close();
        }
    }
}

