/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import java.io.IOException;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.TrueTypeFont;

public class GlyphTable
extends TTFTable {
    public static final String TAG = "glyf";
    private GlyphData[] glyphs;
    private TTFDataStream data;
    private IndexToLocationTable loca;
    private int numGlyphs;
    private int cached = 0;
    private static final int MAX_CACHE_SIZE = 5000;
    private static final int MAX_CACHED_GLYPHS = 100;

    GlyphTable(TrueTypeFont trueTypeFont) {
        super(trueTypeFont);
    }

    @Override
    public void read(TrueTypeFont trueTypeFont, TTFDataStream tTFDataStream) throws IOException {
        this.loca = trueTypeFont.getIndexToLocation();
        this.numGlyphs = trueTypeFont.getNumberOfGlyphs();
        if (this.numGlyphs < 5000) {
            this.glyphs = new GlyphData[this.numGlyphs];
        }
        this.data = tTFDataStream;
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlyphData[] getGlyphs() throws IOException {
        TrueTypeFont trueTypeFont = this.font;
        synchronized (trueTypeFont) {
            long[] lArray = this.loca.getOffsets();
            long l = lArray[this.numGlyphs];
            long l2 = this.getOffset();
            if (this.glyphs == null) {
                this.glyphs = new GlyphData[this.numGlyphs];
            }
            for (int i = 0; i < this.numGlyphs && (l == 0L || l != lArray[i]); ++i) {
                if (lArray[i + 1] <= lArray[i] || this.glyphs[i] != null) continue;
                this.data.seek(l2 + lArray[i]);
                if (this.glyphs[i] == null) {
                    ++this.cached;
                }
                this.glyphs[i] = this.getGlyphData(i);
            }
            this.initialized = true;
            return this.glyphs;
        }
    }

    public void setGlyphs(GlyphData[] glyphDataArray) {
        this.glyphs = glyphDataArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlyphData getGlyph(int n) throws IOException {
        if (n < 0 || n >= this.numGlyphs) {
            return null;
        }
        if (this.glyphs != null && this.glyphs[n] != null) {
            return this.glyphs[n];
        }
        TrueTypeFont trueTypeFont = this.font;
        synchronized (trueTypeFont) {
            long[] lArray = this.loca.getOffsets();
            if (lArray[n] == lArray[n + 1]) {
                return null;
            }
            long l = this.data.getCurrentPosition();
            this.data.seek(this.getOffset() + lArray[n]);
            GlyphData glyphData = this.getGlyphData(n);
            this.data.seek(l);
            if (this.glyphs != null && this.glyphs[n] == null && this.cached < 100) {
                this.glyphs[n] = glyphData;
                ++this.cached;
            }
            return glyphData;
        }
    }

    private GlyphData getGlyphData(int n) throws IOException {
        GlyphData glyphData = new GlyphData();
        HorizontalMetricsTable horizontalMetricsTable = this.font.getHorizontalMetrics();
        int n2 = horizontalMetricsTable == null ? 0 : horizontalMetricsTable.getLeftSideBearing(n);
        glyphData.initData(this, this.data, n2);
        if (glyphData.getDescription().isComposite()) {
            glyphData.getDescription().resolve();
        }
        return glyphData;
    }
}

