/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.EncodedFont;
import org.apache.fontbox.cff.CFFEncoding;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.Type1CharString;
import org.apache.fontbox.cff.Type2CharString;
import org.apache.fontbox.cff.Type2CharStringParser;
import org.apache.fontbox.type1.Type1CharStringReader;

public class CFFType1Font
extends CFFFont
implements EncodedFont {
    private final Map<String, Object> privateDict = new LinkedHashMap<String, Object>();
    private CFFEncoding encoding;
    private final Map<Integer, Type2CharString> charStringCache = new ConcurrentHashMap<Integer, Type2CharString>();
    private final PrivateType1CharStringReader reader = new PrivateType1CharStringReader();

    @Override
    public GeneralPath getPath(String string) throws IOException {
        return this.getType1CharString(string).getPath();
    }

    @Override
    public float getWidth(String string) throws IOException {
        return this.getType1CharString(string).getWidth();
    }

    @Override
    public boolean hasGlyph(String string) {
        int n = this.charset.getSID(string);
        int n2 = this.charset.getGIDForSID(n);
        return n2 != 0;
    }

    @Override
    public List<Number> getFontMatrix() {
        return (List)this.topDict.get("FontMatrix");
    }

    public Type1CharString getType1CharString(String string) throws IOException {
        int n = this.nameToGID(string);
        return this.getType2CharString(n, string);
    }

    public int nameToGID(String string) {
        int n = this.charset.getSID(string);
        return this.charset.getGIDForSID(n);
    }

    @Override
    public Type2CharString getType2CharString(int n) throws IOException {
        String string = "GID+" + n;
        return this.getType2CharString(n, string);
    }

    private Type2CharString getType2CharString(int n, String string) throws IOException {
        Type2CharString type2CharString = this.charStringCache.get(n);
        if (type2CharString == null) {
            byte[] byArray = null;
            if (n < this.charStrings.length) {
                byArray = this.charStrings[n];
            }
            if (byArray == null) {
                byArray = this.charStrings[0];
            }
            Type2CharStringParser type2CharStringParser = new Type2CharStringParser(this.fontName, string);
            List<Object> list = type2CharStringParser.parse(byArray, this.globalSubrIndex, this.getLocalSubrIndex());
            type2CharString = new Type2CharString(this.reader, this.fontName, string, n, list, this.getDefaultWidthX(), this.getNominalWidthX());
            this.charStringCache.put(n, type2CharString);
        }
        return type2CharString;
    }

    public Map<String, Object> getPrivateDict() {
        return this.privateDict;
    }

    void addToPrivateDict(String string, Object object) {
        if (object != null) {
            this.privateDict.put(string, object);
        }
    }

    @Override
    public CFFEncoding getEncoding() {
        return this.encoding;
    }

    void setEncoding(CFFEncoding cFFEncoding) {
        this.encoding = cFFEncoding;
    }

    private byte[][] getLocalSubrIndex() {
        return (byte[][])this.privateDict.get("Subrs");
    }

    private Object getProperty(String string) {
        Object v = this.topDict.get(string);
        if (v != null) {
            return v;
        }
        Object object = this.privateDict.get(string);
        if (object != null) {
            return object;
        }
        return null;
    }

    private int getDefaultWidthX() {
        Number number = (Number)this.getProperty("defaultWidthX");
        if (number == null) {
            return 1000;
        }
        return number.intValue();
    }

    private int getNominalWidthX() {
        Number number = (Number)this.getProperty("nominalWidthX");
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    private class PrivateType1CharStringReader
    implements Type1CharStringReader {
        private PrivateType1CharStringReader() {
        }

        @Override
        public Type1CharString getType1CharString(String string) throws IOException {
            return CFFType1Font.this.getType1CharString(string);
        }
    }
}

