/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.fontbox.cff.CFFFont;
import org.apache.fontbox.cff.CIDKeyedType2CharString;
import org.apache.fontbox.cff.FDSelect;
import org.apache.fontbox.cff.Type1CharString;
import org.apache.fontbox.cff.Type2CharStringParser;
import org.apache.fontbox.type1.Type1CharStringReader;

public class CFFCIDFont
extends CFFFont {
    private String registry;
    private String ordering;
    private int supplement;
    private List<Map<String, Object>> fontDictionaries = new LinkedList<Map<String, Object>>();
    private List<Map<String, Object>> privateDictionaries = new LinkedList<Map<String, Object>>();
    private FDSelect fdSelect;
    private final Map<Integer, CIDKeyedType2CharString> charStringCache = new ConcurrentHashMap<Integer, CIDKeyedType2CharString>();
    private final PrivateType1CharStringReader reader = new PrivateType1CharStringReader();

    public String getRegistry() {
        return this.registry;
    }

    void setRegistry(String string) {
        this.registry = string;
    }

    public String getOrdering() {
        return this.ordering;
    }

    void setOrdering(String string) {
        this.ordering = string;
    }

    public int getSupplement() {
        return this.supplement;
    }

    void setSupplement(int n) {
        this.supplement = n;
    }

    public List<Map<String, Object>> getFontDicts() {
        return this.fontDictionaries;
    }

    void setFontDict(List<Map<String, Object>> list) {
        this.fontDictionaries = list;
    }

    public List<Map<String, Object>> getPrivDicts() {
        return this.privateDictionaries;
    }

    void setPrivDict(List<Map<String, Object>> list) {
        this.privateDictionaries = list;
    }

    public FDSelect getFdSelect() {
        return this.fdSelect;
    }

    void setFdSelect(FDSelect fDSelect) {
        this.fdSelect = fDSelect;
    }

    private int getDefaultWidthX(int n) {
        int n2 = this.fdSelect.getFDIndex(n);
        if (n2 == -1) {
            return 1000;
        }
        Map<String, Object> map = this.privateDictionaries.get(n2);
        return map.containsKey("defaultWidthX") ? ((Number)map.get("defaultWidthX")).intValue() : 1000;
    }

    private int getNominalWidthX(int n) {
        int n2 = this.fdSelect.getFDIndex(n);
        if (n2 == -1) {
            return 0;
        }
        Map<String, Object> map = this.privateDictionaries.get(n2);
        return map.containsKey("nominalWidthX") ? ((Number)map.get("nominalWidthX")).intValue() : 0;
    }

    private byte[][] getLocalSubrIndex(int n) {
        int n2 = this.fdSelect.getFDIndex(n);
        if (n2 == -1) {
            return null;
        }
        Map<String, Object> map = this.privateDictionaries.get(n2);
        return (byte[][])map.get("Subrs");
    }

    @Override
    public CIDKeyedType2CharString getType2CharString(int n) throws IOException {
        CIDKeyedType2CharString cIDKeyedType2CharString = this.charStringCache.get(n);
        if (cIDKeyedType2CharString == null) {
            int n2 = this.charset.getGIDForCID(n);
            byte[] byArray = this.charStrings[n2];
            if (byArray == null) {
                byArray = this.charStrings[0];
            }
            Type2CharStringParser type2CharStringParser = new Type2CharStringParser(this.fontName, n);
            List<Object> list = type2CharStringParser.parse(byArray, this.globalSubrIndex, this.getLocalSubrIndex(n2));
            cIDKeyedType2CharString = new CIDKeyedType2CharString((Type1CharStringReader)this.reader, this.fontName, n, n2, list, this.getDefaultWidthX(n2), this.getNominalWidthX(n2));
            this.charStringCache.put(n, cIDKeyedType2CharString);
        }
        return cIDKeyedType2CharString;
    }

    @Override
    public List<Number> getFontMatrix() {
        return (List)this.topDict.get("FontMatrix");
    }

    @Override
    public GeneralPath getPath(String string) throws IOException {
        int n = this.selectorToCID(string);
        return this.getType2CharString(n).getPath();
    }

    @Override
    public float getWidth(String string) throws IOException {
        int n = this.selectorToCID(string);
        return this.getType2CharString(n).getWidth();
    }

    @Override
    public boolean hasGlyph(String string) throws IOException {
        int n = this.selectorToCID(string);
        return n != 0;
    }

    private int selectorToCID(String string) {
        if (!string.startsWith("\\")) {
            throw new IllegalArgumentException("Invalid selector");
        }
        return Integer.parseInt(string.substring(1));
    }

    private class PrivateType1CharStringReader
    implements Type1CharStringReader {
        private PrivateType1CharStringReader() {
        }

        @Override
        public Type1CharString getType1CharString(String string) throws IOException {
            return CFFCIDFont.this.getType2CharString(0);
        }
    }
}

