/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal.matchers;

import java.io.Serializable;
import java.util.Comparator;
import org.easymock.IArgumentMatcher;
import org.easymock.LogicalOperator;

public class Compare<T>
implements IArgumentMatcher,
Serializable {
    private static final long serialVersionUID = -4859402739599754147L;
    private final T expected;
    private final Comparator<? super T> comparator;
    private final LogicalOperator operator;

    public Compare(T t, Comparator<? super T> comparator, LogicalOperator logicalOperator) {
        this.expected = t;
        this.comparator = comparator;
        this.operator = logicalOperator;
    }

    @Override
    public void appendTo(StringBuffer stringBuffer) {
        stringBuffer.append(this.comparator + "(" + this.expected + ") " + this.operator.getSymbol() + " 0");
    }

    @Override
    public boolean matches(Object object) {
        if (object == null) {
            return false;
        }
        return this.operator.matchResult(this.comparator.compare(object, this.expected));
    }
}

