/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "move_options.h"

MoveOptions::MoveOptions (bool init /* = true */) :
    mOptions (MoveOptions::OptionNum),
    mNotify (MoveOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
MoveOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // initiate_button
    mOptions[MoveOptions::InitiateButton].setName ("initiate_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Alt>Button1");
    mOptions[MoveOptions::InitiateButton].value().set (action);
    if (screen) screen->addAction (&mOptions[MoveOptions::InitiateButton].value ().action ());

    // initiate_key
    mOptions[MoveOptions::InitiateKey].setName ("initiate_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>F7");
    mOptions[MoveOptions::InitiateKey].value().set (action);
    if (screen) screen->addAction (&mOptions[MoveOptions::InitiateKey].value ().action ());

    // opacity
    mOptions[MoveOptions::Opacity].setName ("opacity", CompOption::TypeInt);
    mOptions[MoveOptions::Opacity].rest ().set (1, 100);
    mOptions[MoveOptions::Opacity].value().set((int) 100);

    // key_move_inc
    mOptions[MoveOptions::KeyMoveInc].setName ("key_move_inc", CompOption::TypeInt);
    mOptions[MoveOptions::KeyMoveInc].rest ().set (1, 250);
    mOptions[MoveOptions::KeyMoveInc].value().set((int) 24);

    // constrain_y
    mOptions[MoveOptions::ConstrainY].setName ("constrain_y", CompOption::TypeBool);
    mOptions[MoveOptions::ConstrainY].value().set(true);

    // snapoff_semimaximized
    mOptions[MoveOptions::SnapoffSemimaximized].setName ("snapoff_semimaximized", CompOption::TypeBool);
    mOptions[MoveOptions::SnapoffSemimaximized].value().set(true);

    // snapoff_distance
    mOptions[MoveOptions::SnapoffDistance].setName ("snapoff_distance", CompOption::TypeInt);
    mOptions[MoveOptions::SnapoffDistance].rest ().set (0, 500);
    mOptions[MoveOptions::SnapoffDistance].value().set((int) 100);

    // snapback_semimaximized
    mOptions[MoveOptions::SnapbackSemimaximized].setName ("snapback_semimaximized", CompOption::TypeBool);
    mOptions[MoveOptions::SnapbackSemimaximized].value().set(true);

    // snapback_distance
    mOptions[MoveOptions::SnapbackDistance].setName ("snapback_distance", CompOption::TypeInt);
    mOptions[MoveOptions::SnapbackDistance].rest ().set (0, 250);
    mOptions[MoveOptions::SnapbackDistance].value().set((int) 20);

    // lazy_positioning
    mOptions[MoveOptions::LazyPositioning].setName ("lazy_positioning", CompOption::TypeBool);
    mOptions[MoveOptions::LazyPositioning].value().set(false);

    // mode
    mOptions[MoveOptions::Mode].setName ("mode", CompOption::TypeInt);
    mOptions[MoveOptions::Mode].rest ().set (0, 2);
    mOptions[MoveOptions::Mode].value().set((int) 0);

    // increase_border_contrast
    mOptions[MoveOptions::IncreaseBorderContrast].setName ("increase_border_contrast", CompOption::TypeBool);
    mOptions[MoveOptions::IncreaseBorderContrast].value().set(true);

    // use_desktop_average_color
    mOptions[MoveOptions::UseDesktopAverageColor].setName ("use_desktop_average_color", CompOption::TypeBool);
    mOptions[MoveOptions::UseDesktopAverageColor].value().set(true);

    // border_color
    mOptions[MoveOptions::BorderColor].setName ("border_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xfbfb));
    color[1] = MAX (0, MIN (0xffff, 0x8b8b));
    color[2] = MAX (0, MIN (0xffff, 0x0));
    color[3] = MAX (0, MIN (0xffff, 0x9f9f));
    mOptions[MoveOptions::BorderColor].value().set(color);

    // fill_color
    mOptions[MoveOptions::FillColor].setName ("fill_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xfbfb));
    color[1] = MAX (0, MIN (0xffff, 0x8b8b));
    color[2] = MAX (0, MIN (0xffff, 0x0));
    color[3] = MAX (0, MIN (0xffff, 0x1919));
    mOptions[MoveOptions::FillColor].value().set(color);

    // blend
    mOptions[MoveOptions::Blend].setName ("blend", CompOption::TypeBool);
    mOptions[MoveOptions::Blend].value().set(true);

}

MoveOptions::~MoveOptions ()
{
}


CompOption::Vector &
MoveOptions::getOptions ()
{
    return mOptions;
}

bool
MoveOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case MoveOptions::InitiateButton:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::InitiateButton].empty ())
                    mNotify[MoveOptions::InitiateButton] (o, MoveOptions::InitiateButton);
                return true;
            }
            break;
        case MoveOptions::InitiateKey:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::InitiateKey].empty ())
                    mNotify[MoveOptions::InitiateKey] (o, MoveOptions::InitiateKey);
                return true;
            }
            break;
        case MoveOptions::Opacity:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::Opacity].empty ())
                    mNotify[MoveOptions::Opacity] (o, MoveOptions::Opacity);
                return true;
            }
            break;
        case MoveOptions::KeyMoveInc:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::KeyMoveInc].empty ())
                    mNotify[MoveOptions::KeyMoveInc] (o, MoveOptions::KeyMoveInc);
                return true;
            }
            break;
        case MoveOptions::ConstrainY:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::ConstrainY].empty ())
                    mNotify[MoveOptions::ConstrainY] (o, MoveOptions::ConstrainY);
                return true;
            }
            break;
        case MoveOptions::SnapoffSemimaximized:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::SnapoffSemimaximized].empty ())
                    mNotify[MoveOptions::SnapoffSemimaximized] (o, MoveOptions::SnapoffSemimaximized);
                return true;
            }
            break;
        case MoveOptions::SnapoffDistance:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::SnapoffDistance].empty ())
                    mNotify[MoveOptions::SnapoffDistance] (o, MoveOptions::SnapoffDistance);
                return true;
            }
            break;
        case MoveOptions::SnapbackSemimaximized:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::SnapbackSemimaximized].empty ())
                    mNotify[MoveOptions::SnapbackSemimaximized] (o, MoveOptions::SnapbackSemimaximized);
                return true;
            }
            break;
        case MoveOptions::SnapbackDistance:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::SnapbackDistance].empty ())
                    mNotify[MoveOptions::SnapbackDistance] (o, MoveOptions::SnapbackDistance);
                return true;
            }
            break;
        case MoveOptions::LazyPositioning:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::LazyPositioning].empty ())
                    mNotify[MoveOptions::LazyPositioning] (o, MoveOptions::LazyPositioning);
                return true;
            }
            break;
        case MoveOptions::Mode:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::Mode].empty ())
                    mNotify[MoveOptions::Mode] (o, MoveOptions::Mode);
                return true;
            }
            break;
        case MoveOptions::IncreaseBorderContrast:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::IncreaseBorderContrast].empty ())
                    mNotify[MoveOptions::IncreaseBorderContrast] (o, MoveOptions::IncreaseBorderContrast);
                return true;
            }
            break;
        case MoveOptions::UseDesktopAverageColor:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::UseDesktopAverageColor].empty ())
                    mNotify[MoveOptions::UseDesktopAverageColor] (o, MoveOptions::UseDesktopAverageColor);
                return true;
            }
            break;
        case MoveOptions::BorderColor:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::BorderColor].empty ())
                    mNotify[MoveOptions::BorderColor] (o, MoveOptions::BorderColor);
                return true;
            }
            break;
        case MoveOptions::FillColor:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::FillColor].empty ())
                    mNotify[MoveOptions::FillColor] (o, MoveOptions::FillColor);
                return true;
            }
            break;
        case MoveOptions::Blend:
            if (o->set (value))
            {
                if (!mNotify[MoveOptions::Blend].empty ())
                    mNotify[MoveOptions::Blend] (o, MoveOptions::Blend);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

