/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "matecompat_options.h"

MatecompatOptions::MatecompatOptions (bool init /* = true */) :
    mOptions (MatecompatOptions::OptionNum),
    mNotify (MatecompatOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
MatecompatOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // main_menu_key
    mOptions[MatecompatOptions::MainMenuKey].setName ("main_menu_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>F1");
    mOptions[MatecompatOptions::MainMenuKey].value().set (action);
    if (screen) screen->addAction (&mOptions[MatecompatOptions::MainMenuKey].value ().action ());

    // run_key
    mOptions[MatecompatOptions::RunKey].setName ("run_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>F2");
    mOptions[MatecompatOptions::RunKey].value().set (action);
    if (screen) screen->addAction (&mOptions[MatecompatOptions::RunKey].value ().action ());

    // command_screenshot
    mOptions[MatecompatOptions::CommandScreenshot].setName ("command_screenshot", CompOption::TypeString);
    mOptions[MatecompatOptions::CommandScreenshot].value().set(CompString ("mate-screenshot"));

    // run_command_screenshot_key
    mOptions[MatecompatOptions::RunCommandScreenshotKey].setName ("run_command_screenshot_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("Print");
    mOptions[MatecompatOptions::RunCommandScreenshotKey].value().set (action);
    if (screen) screen->addAction (&mOptions[MatecompatOptions::RunCommandScreenshotKey].value ().action ());

    // command_window_screenshot
    mOptions[MatecompatOptions::CommandWindowScreenshot].setName ("command_window_screenshot", CompOption::TypeString);
    mOptions[MatecompatOptions::CommandWindowScreenshot].value().set(CompString ("mate-screenshot --window"));

    // run_command_window_screenshot_key
    mOptions[MatecompatOptions::RunCommandWindowScreenshotKey].setName ("run_command_window_screenshot_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>Print");
    mOptions[MatecompatOptions::RunCommandWindowScreenshotKey].value().set (action);
    if (screen) screen->addAction (&mOptions[MatecompatOptions::RunCommandWindowScreenshotKey].value ().action ());

    // command_terminal
    mOptions[MatecompatOptions::CommandTerminal].setName ("command_terminal", CompOption::TypeString);
    mOptions[MatecompatOptions::CommandTerminal].value().set(CompString ("mate-terminal"));

    // run_command_terminal_key
    mOptions[MatecompatOptions::RunCommandTerminalKey].setName ("run_command_terminal_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[MatecompatOptions::RunCommandTerminalKey].value().set (action);
    if (screen) screen->addAction (&mOptions[MatecompatOptions::RunCommandTerminalKey].value ().action ());

}

MatecompatOptions::~MatecompatOptions ()
{
}


CompOption::Vector &
MatecompatOptions::getOptions ()
{
    return mOptions;
}

bool
MatecompatOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case MatecompatOptions::MainMenuKey:
            if (o->set (value))
            {
                if (!mNotify[MatecompatOptions::MainMenuKey].empty ())
                    mNotify[MatecompatOptions::MainMenuKey] (o, MatecompatOptions::MainMenuKey);
                return true;
            }
            break;
        case MatecompatOptions::RunKey:
            if (o->set (value))
            {
                if (!mNotify[MatecompatOptions::RunKey].empty ())
                    mNotify[MatecompatOptions::RunKey] (o, MatecompatOptions::RunKey);
                return true;
            }
            break;
        case MatecompatOptions::CommandScreenshot:
            if (o->set (value))
            {
                if (!mNotify[MatecompatOptions::CommandScreenshot].empty ())
                    mNotify[MatecompatOptions::CommandScreenshot] (o, MatecompatOptions::CommandScreenshot);
                return true;
            }
            break;
        case MatecompatOptions::RunCommandScreenshotKey:
            if (o->set (value))
            {
                if (!mNotify[MatecompatOptions::RunCommandScreenshotKey].empty ())
                    mNotify[MatecompatOptions::RunCommandScreenshotKey] (o, MatecompatOptions::RunCommandScreenshotKey);
                return true;
            }
            break;
        case MatecompatOptions::CommandWindowScreenshot:
            if (o->set (value))
            {
                if (!mNotify[MatecompatOptions::CommandWindowScreenshot].empty ())
                    mNotify[MatecompatOptions::CommandWindowScreenshot] (o, MatecompatOptions::CommandWindowScreenshot);
                return true;
            }
            break;
        case MatecompatOptions::RunCommandWindowScreenshotKey:
            if (o->set (value))
            {
                if (!mNotify[MatecompatOptions::RunCommandWindowScreenshotKey].empty ())
                    mNotify[MatecompatOptions::RunCommandWindowScreenshotKey] (o, MatecompatOptions::RunCommandWindowScreenshotKey);
                return true;
            }
            break;
        case MatecompatOptions::CommandTerminal:
            if (o->set (value))
            {
                if (!mNotify[MatecompatOptions::CommandTerminal].empty ())
                    mNotify[MatecompatOptions::CommandTerminal] (o, MatecompatOptions::CommandTerminal);
                return true;
            }
            break;
        case MatecompatOptions::RunCommandTerminalKey:
            if (o->set (value))
            {
                if (!mNotify[MatecompatOptions::RunCommandTerminalKey].empty ())
                    mNotify[MatecompatOptions::RunCommandTerminalKey] (o, MatecompatOptions::RunCommandTerminalKey);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

