/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "firepaint_options.h"

FirepaintOptions::FirepaintOptions (bool init /* = true */) :
    mOptions (FirepaintOptions::OptionNum),
    mNotify (FirepaintOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
FirepaintOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // initiate_key
    mOptions[FirepaintOptions::InitiateKey].setName ("initiate_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[FirepaintOptions::InitiateKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FirepaintOptions::InitiateKey].value ().action ());

    // initiate_button
    mOptions[FirepaintOptions::InitiateButton].setName ("initiate_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    action.buttonFromString ("<Super><Shift>Button1");
    mOptions[FirepaintOptions::InitiateButton].value().set (action);
    if (screen) screen->addAction (&mOptions[FirepaintOptions::InitiateButton].value ().action ());

    // clear_key
    mOptions[FirepaintOptions::ClearKey].setName ("clear_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super><Shift>c");
    mOptions[FirepaintOptions::ClearKey].value().set (action);
    if (screen) screen->addAction (&mOptions[FirepaintOptions::ClearKey].value ().action ());

    // clear_button
    mOptions[FirepaintOptions::ClearButton].setName ("clear_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[FirepaintOptions::ClearButton].value().set (action);
    if (screen) screen->addAction (&mOptions[FirepaintOptions::ClearButton].value ().action ());

    // bg_brightness
    mOptions[FirepaintOptions::BgBrightness].setName ("bg_brightness", CompOption::TypeFloat);
    mOptions[FirepaintOptions::BgBrightness].rest ().set (0.0, 100.0, 5.0);
    mOptions[FirepaintOptions::BgBrightness].value().set((float) 50.0);

    // add_particle
    mOptions[FirepaintOptions::AddParticle].setName ("add_particle", CompOption::TypeAction);
    state = CompAction::StateAutoGrab;
    mOptions[FirepaintOptions::AddParticle].value().set(CompAction ());
    mOptions[FirepaintOptions::AddParticle].value().action ().setState (state);

    // num_Particles
    mOptions[FirepaintOptions::NumParticles].setName ("num_Particles", CompOption::TypeInt);
    mOptions[FirepaintOptions::NumParticles].rest ().set (100, 20000);
    mOptions[FirepaintOptions::NumParticles].value().set((int) 3000);

    // fire_size
    mOptions[FirepaintOptions::FireSize].setName ("fire_size", CompOption::TypeFloat);
    mOptions[FirepaintOptions::FireSize].rest ().set (0.1, 40, 0.1);
    mOptions[FirepaintOptions::FireSize].value().set((float) 15.0);

    // fire_slowdown
    mOptions[FirepaintOptions::FireSlowdown].setName ("fire_slowdown", CompOption::TypeFloat);
    mOptions[FirepaintOptions::FireSlowdown].rest ().set (0.1, 10, 0.1);
    mOptions[FirepaintOptions::FireSlowdown].value().set((float) 0.5);

    // fire_life
    mOptions[FirepaintOptions::FireLife].setName ("fire_life", CompOption::TypeFloat);
    mOptions[FirepaintOptions::FireLife].rest ().set (0.1, 0.95, 0.05);
    mOptions[FirepaintOptions::FireLife].value().set((float) 0.7);

    // fire_color
    mOptions[FirepaintOptions::FireColor].setName ("fire_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0x3333));
    color[2] = MAX (0, MIN (0xffff, 0x0555));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[FirepaintOptions::FireColor].value().set(color);

    // fire_mystical
    mOptions[FirepaintOptions::FireMystical].setName ("fire_mystical", CompOption::TypeBool);
    mOptions[FirepaintOptions::FireMystical].value().set(false);

}

FirepaintOptions::~FirepaintOptions ()
{
}


CompOption::Vector &
FirepaintOptions::getOptions ()
{
    return mOptions;
}

bool
FirepaintOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case FirepaintOptions::InitiateKey:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::InitiateKey].empty ())
                    mNotify[FirepaintOptions::InitiateKey] (o, FirepaintOptions::InitiateKey);
                return true;
            }
            break;
        case FirepaintOptions::InitiateButton:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::InitiateButton].empty ())
                    mNotify[FirepaintOptions::InitiateButton] (o, FirepaintOptions::InitiateButton);
                return true;
            }
            break;
        case FirepaintOptions::ClearKey:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::ClearKey].empty ())
                    mNotify[FirepaintOptions::ClearKey] (o, FirepaintOptions::ClearKey);
                return true;
            }
            break;
        case FirepaintOptions::ClearButton:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::ClearButton].empty ())
                    mNotify[FirepaintOptions::ClearButton] (o, FirepaintOptions::ClearButton);
                return true;
            }
            break;
        case FirepaintOptions::BgBrightness:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::BgBrightness].empty ())
                    mNotify[FirepaintOptions::BgBrightness] (o, FirepaintOptions::BgBrightness);
                return true;
            }
            break;
        case FirepaintOptions::AddParticle:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::AddParticle].empty ())
                    mNotify[FirepaintOptions::AddParticle] (o, FirepaintOptions::AddParticle);
                return true;
            }
            break;
        case FirepaintOptions::NumParticles:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::NumParticles].empty ())
                    mNotify[FirepaintOptions::NumParticles] (o, FirepaintOptions::NumParticles);
                return true;
            }
            break;
        case FirepaintOptions::FireSize:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::FireSize].empty ())
                    mNotify[FirepaintOptions::FireSize] (o, FirepaintOptions::FireSize);
                return true;
            }
            break;
        case FirepaintOptions::FireSlowdown:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::FireSlowdown].empty ())
                    mNotify[FirepaintOptions::FireSlowdown] (o, FirepaintOptions::FireSlowdown);
                return true;
            }
            break;
        case FirepaintOptions::FireLife:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::FireLife].empty ())
                    mNotify[FirepaintOptions::FireLife] (o, FirepaintOptions::FireLife);
                return true;
            }
            break;
        case FirepaintOptions::FireColor:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::FireColor].empty ())
                    mNotify[FirepaintOptions::FireColor] (o, FirepaintOptions::FireColor);
                return true;
            }
            break;
        case FirepaintOptions::FireMystical:
            if (o->set (value))
            {
                if (!mNotify[FirepaintOptions::FireMystical].empty ())
                    mNotify[FirepaintOptions::FireMystical] (o, FirepaintOptions::FireMystical);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

