/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "crashhandler_options.h"

CrashhandlerOptions::CrashhandlerOptions (bool init /* = true */) :
    mOptions (CrashhandlerOptions::OptionNum),
    mNotify (CrashhandlerOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
CrashhandlerOptions::initOptions ()
{

    // enabled
    mOptions[CrashhandlerOptions::Enabled].setName ("enabled", CompOption::TypeBool);
    mOptions[CrashhandlerOptions::Enabled].value().set(true);

    // directory
    mOptions[CrashhandlerOptions::Directory].setName ("directory", CompOption::TypeString);
    mOptions[CrashhandlerOptions::Directory].value().set(CompString ("/tmp"));

    // start_wm
    mOptions[CrashhandlerOptions::StartWm].setName ("start_wm", CompOption::TypeBool);
    mOptions[CrashhandlerOptions::StartWm].value().set(false);

    // wm_cmd
    mOptions[CrashhandlerOptions::WmCmd].setName ("wm_cmd", CompOption::TypeString);
    mOptions[CrashhandlerOptions::WmCmd].value().set(CompString (""));

}

CrashhandlerOptions::~CrashhandlerOptions ()
{
}


CompOption::Vector &
CrashhandlerOptions::getOptions ()
{
    return mOptions;
}

bool
CrashhandlerOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case CrashhandlerOptions::Enabled:
            if (o->set (value))
            {
                if (!mNotify[CrashhandlerOptions::Enabled].empty ())
                    mNotify[CrashhandlerOptions::Enabled] (o, CrashhandlerOptions::Enabled);
                return true;
            }
            break;
        case CrashhandlerOptions::Directory:
            if (o->set (value))
            {
                if (!mNotify[CrashhandlerOptions::Directory].empty ())
                    mNotify[CrashhandlerOptions::Directory] (o, CrashhandlerOptions::Directory);
                return true;
            }
            break;
        case CrashhandlerOptions::StartWm:
            if (o->set (value))
            {
                if (!mNotify[CrashhandlerOptions::StartWm].empty ())
                    mNotify[CrashhandlerOptions::StartWm] (o, CrashhandlerOptions::StartWm);
                return true;
            }
            break;
        case CrashhandlerOptions::WmCmd:
            if (o->set (value))
            {
                if (!mNotify[CrashhandlerOptions::WmCmd].empty ())
                    mNotify[CrashhandlerOptions::WmCmd] (o, CrashhandlerOptions::WmCmd);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

