/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;

public class BrentSolver
extends UnivariateRealSolverImpl {
    public static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;
    public static final int DEFAULT_MAXIMUM_ITERATIONS = 5000;
    private static final String NON_BRACKETING_MESSAGE = "function values at endpoints do not have different signs.  Endpoints: [{0}, {1}], Values: [{2}, {3}]";

    @Deprecated
    public BrentSolver(UnivariateRealFunction univariateRealFunction) {
        super(univariateRealFunction, 5000, 1.0E-6);
    }

    public BrentSolver() {
        super(5000, 1.0E-6);
    }

    public BrentSolver(double d) {
        super(5000, d);
    }

    public BrentSolver(int n, double d) {
        super(n, d);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, d, d2);
    }

    @Override
    @Deprecated
    public double solve(double d, double d2, double d3) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, d, d2, d3);
    }

    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2, double d3) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.clearResult();
        if (d3 < d || d3 > d2) {
            throw MathRuntimeException.createIllegalArgumentException("invalid interval, initial value parameters:  lower={0}, initial={1}, upper={2}", d, d3, d2);
        }
        double d4 = univariateRealFunction.value(d3);
        if (Math.abs(d4) <= this.functionValueAccuracy) {
            this.setResult(d3, 0);
            return this.result;
        }
        double d5 = univariateRealFunction.value(d);
        if (Math.abs(d5) <= this.functionValueAccuracy) {
            this.setResult(d, 0);
            return this.result;
        }
        if (d4 * d5 < 0.0) {
            return this.solve(univariateRealFunction, d, d5, d3, d4, d, d5);
        }
        double d6 = univariateRealFunction.value(d2);
        if (Math.abs(d6) <= this.functionValueAccuracy) {
            this.setResult(d2, 0);
            return this.result;
        }
        if (d4 * d6 < 0.0) {
            return this.solve(univariateRealFunction, d3, d4, d2, d6, d3, d4);
        }
        throw MathRuntimeException.createIllegalArgumentException(NON_BRACKETING_MESSAGE, d, d2, d5, d6);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public double solve(UnivariateRealFunction univariateRealFunction, double d, double d2) throws MaxIterationsExceededException, FunctionEvaluationException {
        this.clearResult();
        this.verifyInterval(d, d2);
        double d3 = Double.NaN;
        double d4 = univariateRealFunction.value(d);
        double d5 = univariateRealFunction.value(d2);
        double d6 = d4 * d5;
        if (d6 > 0.0) {
            if (Math.abs(d4) <= this.functionValueAccuracy) {
                this.setResult(d, 0);
                return d;
            }
            if (!(Math.abs(d5) <= this.functionValueAccuracy)) throw MathRuntimeException.createIllegalArgumentException(NON_BRACKETING_MESSAGE, d, d2, d4, d5);
            this.setResult(d2, 0);
            return d2;
        }
        if (d6 < 0.0) {
            return this.solve(univariateRealFunction, d, d4, d2, d5, d, d4);
        }
        if (d4 != 0.0) return d2;
        return d;
    }

    private double solve(UnivariateRealFunction univariateRealFunction, double d, double d2, double d3, double d4, double d5, double d6) throws MaxIterationsExceededException, FunctionEvaluationException {
        double d7;
        double d8 = d7 = d3 - d;
        for (int i = 0; i < this.maximalIterationCount; ++i) {
            if (Math.abs(d6) < Math.abs(d4)) {
                d = d3;
                d3 = d5;
                d5 = d;
                d2 = d4;
                d4 = d6;
                d6 = d2;
            }
            if (Math.abs(d4) <= this.functionValueAccuracy) {
                this.setResult(d3, i);
                return this.result;
            }
            double d9 = d5 - d3;
            double d10 = Math.max(this.relativeAccuracy * Math.abs(d3), this.absoluteAccuracy);
            if (Math.abs(d9) <= d10) {
                this.setResult(d3, i);
                return this.result;
            }
            if (Math.abs(d8) < d10 || Math.abs(d2) <= Math.abs(d4)) {
                d8 = d7 = 0.5 * d9;
            } else {
                double d11;
                double d12;
                double d13 = d4 / d2;
                if (d == d5) {
                    d12 = d9 * d13;
                    d11 = 1.0 - d13;
                } else {
                    double d14 = d2 / d6;
                    double d15 = d4 / d6;
                    d12 = d13 * (d9 * d14 * (d14 - d15) - (d3 - d) * (d15 - 1.0));
                    d11 = (d14 - 1.0) * (d15 - 1.0) * (d13 - 1.0);
                }
                if (d12 > 0.0) {
                    d11 = -d11;
                } else {
                    d12 = -d12;
                }
                if (2.0 * d12 >= 1.5 * d9 * d11 - Math.abs(d10 * d11) || d12 >= Math.abs(0.5 * d8 * d11)) {
                    d8 = d7 = 0.5 * d9;
                } else {
                    d8 = d7;
                    d7 = d12 / d11;
                }
            }
            d = d3;
            d2 = d4;
            if (Math.abs(d7) > d10) {
                d3 += d7;
            } else if (d9 > 0.0) {
                d3 += 0.5 * d10;
            } else if (d9 <= 0.0) {
                d3 -= 0.5 * d10;
            }
            d4 = univariateRealFunction.value(d3);
            if (d4 > 0.0 != d6 > 0.0) continue;
            d5 = d;
            d6 = d2;
            d8 = d7 = d3 - d;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }
}

