/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.core.Description;
import beast.util.PackageDependency;
import beast.util.PackageVersion;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

@Description(value="BEAUti package managed by package manager, also named as add-on previously")
public class Package {
    protected String packageName;
    protected String description;
    protected PackageVersion installedVersion;
    protected Set<PackageDependency> installedVersionDeps;
    protected TreeMap<PackageVersion, URL> availableVersionURLs;
    protected TreeMap<PackageVersion, Set<PackageDependency>> availableVersionDeps;
    protected URL projectURL;

    public Package(String string) {
        this.packageName = string;
        this.description = "";
        this.availableVersionURLs = new TreeMap();
        this.availableVersionDeps = new TreeMap();
    }

    public String getName() {
        return this.packageName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public URL getProjectURL() {
        return this.projectURL;
    }

    public void setProjectURL(URL uRL) {
        this.projectURL = uRL;
    }

    public boolean isAvailable() {
        return !this.availableVersionURLs.isEmpty();
    }

    public boolean isAvailable(PackageVersion packageVersion) {
        return this.availableVersionURLs.containsKey(packageVersion);
    }

    public void addAvailableVersion(PackageVersion packageVersion, URL uRL, Set<PackageDependency> set) {
        this.availableVersionURLs.put(packageVersion, uRL);
        this.availableVersionDeps.put(packageVersion, set);
    }

    public void setInstalled(PackageVersion packageVersion, Set<PackageDependency> set) {
        this.installedVersion = packageVersion;
        this.installedVersionDeps = set;
    }

    public PackageVersion getInstalledVersion() {
        return this.installedVersion;
    }

    public boolean isInstalled() {
        return this.installedVersion != null;
    }

    public boolean newVersionAvailable() {
        return this.isAvailable() && (!this.isInstalled() || this.getLatestVersion().compareTo(this.getInstalledVersion()) > 0);
    }

    public Set<PackageDependency> getInstalledVersionDependencies() {
        return this.installedVersionDeps;
    }

    public PackageVersion getLatestVersion() {
        return this.availableVersionURLs.isEmpty() ? null : this.availableVersionURLs.lastKey();
    }

    public URL getLatestVersionURL() {
        return this.isAvailable() ? this.availableVersionURLs.lastEntry().getValue() : null;
    }

    public URL getVersionURL(PackageVersion packageVersion) {
        return this.isAvailable(packageVersion) ? this.availableVersionURLs.get(packageVersion) : null;
    }

    public Set<PackageDependency> getLatestVersionDependencies() {
        return this.isAvailable() ? this.availableVersionDeps.lastEntry().getValue() : null;
    }

    public Set<PackageDependency> getDependencies(PackageVersion packageVersion) {
        return this.availableVersionDeps.get(packageVersion);
    }

    public List<PackageVersion> getAvailableVersions() {
        ArrayList<PackageVersion> arrayList = new ArrayList<PackageVersion>(this.availableVersionURLs.keySet());
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        return arrayList;
    }

    public boolean latestVersionDependsOn(Package package_) {
        if (!this.isAvailable()) {
            throw new IllegalStateException("Requested latest available version dependencies when there is no available version.");
        }
        for (PackageDependency packageDependency : this.availableVersionDeps.lastEntry().getValue()) {
            if (!packageDependency.dependencyName.equals(package_.packageName)) continue;
            return true;
        }
        return false;
    }

    public boolean installedVersionDependsOn(Package package_) {
        if (!this.isInstalled()) {
            throw new IllegalStateException("Requested installed version dependencies when there is no installed version.");
        }
        for (PackageDependency packageDependency : this.installedVersionDeps) {
            if (!packageDependency.dependencyName.equals(package_.packageName)) continue;
            return true;
        }
        return false;
    }

    public String getDependenciesString() {
        if (this.availableVersionDeps.isEmpty()) {
            return "";
        }
        String string = "";
        for (PackageDependency packageDependency : this.availableVersionDeps.lastEntry().getValue()) {
            String string2 = packageDependency.dependencyName;
            if (string2.equalsIgnoreCase("BEAST")) continue;
            string = string + string2 + ", ";
        }
        if (string.length() > 2) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    public String toString() {
        return this.packageName;
    }

    public String toHTML() {
        String string = "<html>";
        string = string + "<h1>" + this.packageName + "</h1>";
        string = string + "<p>Installed version: " + (this.isInstalled() ? this.getInstalledVersion() : "NA") + "</p>";
        string = string + "<p>Latest version: " + (this.isAvailable() ? this.getLatestVersion() : "NA") + "</p>";
        string = string + "<p>" + this.description + "</p>";
        string = string + "</html>";
        return string;
    }
}

