/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.ContinuousDistribution;
import org.apache.commons.math.distribution.Distribution;

@Description(value="Uniform distribution over a given interval (including lower and upper values)")
public class Uniform
extends ParametricDistribution {
    public final Input<Double> lowerInput = new Input<Double>("lower", "lower bound on the interval, default 0", 0.0);
    public final Input<Double> upperInput = new Input<Double>("upper", "lower bound on the interval, default 1", 1.0);
    UniformImpl distr = new UniformImpl();
    double _lower;
    double _upper;
    double density;
    private boolean infiniteSupport;

    @Override
    public void initAndValidate() {
        this._lower = this.lowerInput.get();
        this._upper = this.upperInput.get();
        if (this._lower >= this._upper) {
            throw new IllegalArgumentException("Upper value should be higher than lower value");
        }
        this.distr.setBounds(this._lower, this._upper);
        this.infiniteSupport = Double.isInfinite(this._lower) || Double.isInfinite(this._upper);
        this.density = this.infiniteSupport ? 1.0 : 1.0 / (this._upper - this._lower);
    }

    @Override
    public Distribution getDistribution() {
        return this.distr;
    }

    @Override
    public double density(double d) {
        if (d >= this._lower && d <= this._upper) {
            return 1.0;
        }
        return 0.0;
    }

    @Override
    public double getMean() {
        if (Double.isInfinite(this._lower) || Double.isInfinite(this._upper)) {
            return Double.NaN;
        }
        return (Double)this.offsetInput.get() + (this._upper + this._lower) / 2.0;
    }

    class UniformImpl
    implements ContinuousDistribution {
        private double lower;
        private double upper;

        UniformImpl() {
        }

        public void setBounds(double d, double d2) {
            this.lower = d;
            this.upper = d2;
        }

        @Override
        public double cumulativeProbability(double d) throws MathException {
            d = Math.max(d, this.lower);
            return (d - this.lower) / (this.upper - this.lower);
        }

        @Override
        public double cumulativeProbability(double d, double d2) throws MathException {
            d = Math.max(d, this.lower);
            if ((d2 = Math.min(d2, this.upper)) < this.lower || d2 > this.upper) {
                throw new RuntimeException("Value x (" + d2 + ") out of bounds (" + this.lower + "," + this.upper + ").");
            }
            return (d2 - d) / (this.upper - this.lower);
        }

        @Override
        public double inverseCumulativeProbability(double d) throws MathException {
            if (d < 0.0 || d > 1.0) {
                throw new RuntimeException("inverseCumulativeProbability::argument out of range [0...1]");
            }
            if (d == 0.0) {
                return Uniform.this._lower;
            }
            if (d == 1.0) {
                return Uniform.this._upper;
            }
            if (Uniform.this.infiniteSupport) {
                throw new RuntimeException("Inverse Cumulative Probability for 0 < p < 1 and infinite support");
            }
            return (this.upper - this.lower) * d + this.lower;
        }

        @Override
        public double density(double d) {
            if (d >= this.lower && d <= this.upper) {
                return Uniform.this.density;
            }
            return 0.0;
        }

        @Override
        public double logDensity(double d) {
            return Math.log(this.density(d));
        }
    }
}

