/*
 * Decompiled with CFR 0.152.
 */
package beast.math.distributions;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.IntegerParameter;
import beast.math.distributions.ParametricDistribution;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;
import org.apache.commons.math.distribution.ContinuousDistribution;

@Description(value="Chi square distribution, f(x; k) = \\frac{1}{2^{k/2}Gamma(k/2)} x^{k/2-1} e^{-x/2} If the input x is a multidimensional parameter, each of the dimensions is considered as a separate independent component.")
public class ChiSquare
extends ParametricDistribution {
    public final Input<IntegerParameter> dfInput = new Input("df", "degrees if freedin, defaults to 1");
    static ChiSquaredDistribution m_dist = new ChiSquaredDistributionImpl(1.0);

    @Override
    public void initAndValidate() {
        this.refresh();
    }

    void refresh() {
        int n;
        if (this.dfInput.get() == null) {
            n = 1;
        } else {
            n = this.dfInput.get().getValue();
            if (n <= 0) {
                n = 1;
            }
        }
        m_dist.setDegreesOfFreedom(n);
    }

    @Override
    public ContinuousDistribution getDistribution() {
        this.refresh();
        return m_dist;
    }
}

