/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree.coalescent;

import beast.evolution.tree.coalescent.IntervalType;
import beast.math.Binomial;

public interface IntervalList {
    public int getIntervalCount();

    public int getSampleCount();

    public double getInterval(int var1);

    public int getLineageCount(int var1);

    public int getCoalescentEvents(int var1);

    public IntervalType getIntervalType(int var1);

    public double getTotalDuration();

    public boolean isBinaryCoalescent();

    public boolean isCoalescentOnly();

    public static class Utils {
        public static int getLineageCount(IntervalList intervalList, double d) {
            int n;
            for (n = 0; n < intervalList.getIntervalCount() && d > intervalList.getInterval(n); d -= intervalList.getInterval(n), ++n) {
            }
            if (n == intervalList.getIntervalCount()) {
                return 1;
            }
            return intervalList.getLineageCount(n);
        }

        public static double getDelta(IntervalList intervalList) {
            if (!intervalList.isCoalescentOnly()) {
                throw new IllegalArgumentException("Assumes ultrametric beast.tree!");
            }
            int n = intervalList.getIntervalCount();
            int n2 = n + 1;
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            for (int i = 0; i < n; ++i) {
                double d4 = intervalList.getInterval(i) * Binomial.choose2(intervalList.getLineageCount(i));
                d3 += d2;
                d2 += d4;
                d += d4;
            }
            double d5 = d / 2.0;
            double d6 = d5 - (d3 *= 1.0 / ((double)n2 - 2.0));
            double d7 = d * Math.sqrt(1.0 / (12.0 * ((double)n2 - 2.0)));
            return d6 / d7;
        }
    }
}

