/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.tree.coalescent;

import beast.core.BEASTObject;
import beast.core.Description;
import beast.core.Function;
import beast.core.Input;
import beast.core.State;
import beast.core.parameter.IntegerParameter;
import beast.evolution.tree.Tree;
import beast.evolution.tree.TreeDistribution;
import beast.evolution.tree.coalescent.IntervalType;
import beast.evolution.tree.coalescent.TreeIntervals;
import beast.math.Binomial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

@Description(value="A likelihood function for the generalized skyline plot coalescent.")
public class BayesianSkyline
extends TreeDistribution {
    public final Input<Function> popSizeParamInput = new Input("popSizes", "present-day population size. If time units are set to Units.EXPECTED_SUBSTITUTIONS thenthe N0 parameter will be interpreted as N0 * mu. Also note that if you are dealing with a diploid population N0 will be out by a factor of 2.", Input.Validate.REQUIRED);
    public final Input<IntegerParameter> groupSizeParamInput = new Input("groupSizes", "the group sizes parameter", Input.Validate.REQUIRED);
    Function popSizes;
    IntegerParameter groupSizes;
    Tree tree;
    TreeIntervals intervals;
    double[] coalescentTimes;
    int[] cumulativeGroupSizes;
    boolean m_bIsPrepared = false;

    @Override
    public void initAndValidate() {
        int n;
        if (this.treeInput.get() != null) {
            throw new IllegalArgumentException("only tree intervals (not tree) should not be specified");
        }
        this.intervals = (TreeIntervals)this.treeIntervalsInput.get();
        this.groupSizes = this.groupSizeParamInput.get();
        this.popSizes = this.popSizeParamInput.get();
        int n2 = this.intervals.treeInput.get().getInternalNodeCount();
        if (this.groupSizes.getDimension() > n2) {
            throw new IllegalArgumentException("There are more groups than coalescent nodes in the tree.");
        }
        int n3 = this.groupSizes.getDimension();
        int n4 = 0;
        for (n = 0; n < this.groupSizes.getDimension(); ++n) {
            n4 += ((Integer)this.groupSizes.getValue(n)).intValue();
        }
        if (n4 != n2) {
            if (n4 == 0 || n4 == n3) {
                n = n2 / n3;
                int n5 = n2 % n3;
                Integer[] integerArray = new Integer[n3];
                for (int i = 0; i < n3; ++i) {
                    integerArray[i] = i < n5 ? Integer.valueOf(n + 1) : Integer.valueOf(n);
                }
                IntegerParameter integerParameter = new IntegerParameter(integerArray);
                integerParameter.setBounds(1, Integer.MAX_VALUE);
                this.groupSizes.assignFromWithoutID(integerParameter);
            } else {
                throw new IllegalArgumentException("The sum of the initial group sizes does not match the number of coalescent events in the tree.");
            }
        }
        this.prepare();
    }

    public void prepare() {
        this.cumulativeGroupSizes = new int[this.groupSizes.getDimension()];
        int n = 0;
        for (int i = 0; i < this.cumulativeGroupSizes.length; ++i) {
            this.cumulativeGroupSizes[i] = n += ((Integer)this.groupSizes.getValue(i)).intValue();
        }
        this.coalescentTimes = this.intervals.getCoalescentTimes(this.coalescentTimes);
        assert (this.intervals.getSampleCount() == n);
        this.m_bIsPrepared = true;
    }

    @Override
    protected boolean requiresRecalculation() {
        this.m_bIsPrepared = false;
        return true;
    }

    @Override
    public void store() {
        this.m_bIsPrepared = false;
        super.store();
    }

    @Override
    public void restore() {
        this.m_bIsPrepared = false;
        super.restore();
    }

    public List<String> getParameterIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(((BEASTObject)((Object)this.popSizes)).getID());
        arrayList.add(this.groupSizes.getID());
        return arrayList;
    }

    @Override
    public double calculateLogP() {
        if (!this.m_bIsPrepared) {
            this.prepare();
        }
        this.logP = 0.0;
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.intervals.getIntervalCount(); ++i) {
            double d2 = this.getPopSize(d + this.intervals.getInterval(i) / 2.0);
            if (this.intervals.getIntervalType(i) == IntervalType.COALESCENT && ++n2 >= (Integer)this.groupSizes.getValue(n)) {
                ++n;
                n2 = 0;
            }
            this.logP += BayesianSkyline.calculateIntervalLikelihood(d2, this.intervals.getInterval(i), d, this.intervals.getLineageCount(i), this.intervals.getIntervalType(i));
            int n3 = this.intervals.getCoalescentEvents(i) - 1;
            for (int j = 0; j < n3; ++j) {
                double d3 = this.getPopSize(d);
                this.logP += BayesianSkyline.calculateIntervalLikelihood(d3, 0.0, d, this.intervals.getLineageCount(i) - j - 1, IntervalType.COALESCENT);
                if (++n2 < (Integer)this.groupSizes.getValue(n)) continue;
                ++n;
                n2 = 0;
            }
            d += this.intervals.getInterval(i);
        }
        return this.logP;
    }

    public static double calculateIntervalLikelihood(double d, double d2, double d3, int n, IntervalType intervalType) {
        double d4 = d2 + d3;
        double d5 = (d4 - d3) / d;
        double d6 = Binomial.choose2(n);
        double d7 = -d6 * d5;
        switch (intervalType) {
            case COALESCENT: {
                double d8 = Math.log(d);
                d7 += -d8;
                break;
            }
        }
        return d7;
    }

    public double getPopSize(double d) {
        int n;
        if (!this.m_bIsPrepared) {
            this.prepare();
        }
        if (d > this.coalescentTimes[this.coalescentTimes.length - 1]) {
            return this.popSizes.getArrayValue(this.popSizes.getDimension() - 1);
        }
        int n2 = Arrays.binarySearch(this.coalescentTimes, d);
        if (n2 < 0) {
            n2 = -n2 - 1;
        }
        n = (n = Arrays.binarySearch(this.cumulativeGroupSizes, n2)) < 0 ? -n - 1 : ++n;
        if (n >= this.popSizes.getDimension()) {
            n = this.popSizes.getDimension() - 1;
        }
        return this.popSizes.getArrayValue(n);
    }

    @Override
    public List<String> getArguments() {
        return null;
    }

    @Override
    public List<String> getConditions() {
        return null;
    }

    @Override
    public void sample(State state, Random random) {
    }
}

