/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.evolution.datatype.Aminoacid;
import beast.evolution.datatype.DataType;
import beast.evolution.substitutionmodel.EmpiricalSubstitutionModel;
import beast.math.statistic.DiscreteStatistics;

@Description(value="WAG model of amino acid evolution by S. Whelan and N. Goldman. 2000. Bioinformatics ?.")
public class WAG
extends EmpiricalSubstitutionModel {
    @Override
    double[][] getEmpiricalRates() {
        double[][] dArray = new double[20][20];
        dArray[0][1] = 0.61081;
        dArray[0][2] = 0.569079;
        dArray[0][3] = 0.8215;
        dArray[0][4] = 1.14105;
        dArray[0][5] = 1.01198;
        dArray[0][6] = 1.75641;
        dArray[0][7] = 1.57216;
        dArray[0][8] = 0.354813;
        dArray[0][9] = 0.219023;
        dArray[0][10] = 0.443935;
        dArray[0][11] = 1.00544;
        dArray[0][12] = 0.989475;
        dArray[0][13] = 0.233492;
        dArray[0][14] = 1.59489;
        dArray[0][15] = 3.73338;
        dArray[0][16] = 2.34922;
        dArray[0][17] = 0.125227;
        dArray[0][18] = 0.268987;
        dArray[0][19] = 2.22187;
        dArray[1][2] = 0.71169;
        dArray[1][3] = 0.165074;
        dArray[1][4] = 0.585809;
        dArray[1][5] = 3.36033;
        dArray[1][6] = 0.488649;
        dArray[1][7] = 0.650469;
        dArray[1][8] = 2.36204;
        dArray[1][9] = 0.206722;
        dArray[1][10] = 0.55145;
        dArray[1][11] = 5.92517;
        dArray[1][12] = 0.758446;
        dArray[1][13] = 0.116821;
        dArray[1][14] = 0.753467;
        dArray[1][15] = 1.35764;
        dArray[1][16] = 0.613776;
        dArray[1][17] = 1.29461;
        dArray[1][18] = 0.423612;
        dArray[1][19] = 0.280336;
        dArray[2][3] = 6.01366;
        dArray[2][4] = 0.296524;
        dArray[2][5] = 1.71674;
        dArray[2][6] = 1.05679;
        dArray[2][7] = 1.25391;
        dArray[2][8] = 4.37893;
        dArray[2][9] = 0.615636;
        dArray[2][10] = 0.147156;
        dArray[2][11] = 3.33439;
        dArray[2][12] = 0.224747;
        dArray[2][13] = 0.110793;
        dArray[2][14] = 0.217538;
        dArray[2][15] = 4.39445;
        dArray[2][16] = 2.25793;
        dArray[2][17] = 0.078463;
        dArray[2][18] = 1.20856;
        dArray[2][19] = 0.221176;
        dArray[3][4] = 0.033379;
        dArray[3][5] = 0.691268;
        dArray[3][6] = 6.8334;
        dArray[3][7] = 0.961142;
        dArray[3][8] = 1.03291;
        dArray[3][9] = 0.043523;
        dArray[3][10] = 0.09393;
        dArray[3][11] = 0.533362;
        dArray[3][12] = 0.116813;
        dArray[3][13] = 0.052004;
        dArray[3][14] = 0.472601;
        dArray[3][15] = 1.19281;
        dArray[3][16] = 0.417372;
        dArray[3][17] = 0.146348;
        dArray[3][18] = 0.363243;
        dArray[3][19] = 0.169417;
        dArray[4][5] = 0.109261;
        dArray[4][6] = 0.02392;
        dArray[4][7] = 0.341086;
        dArray[4][8] = 0.275403;
        dArray[4][9] = 0.18989;
        dArray[4][10] = 0.428414;
        dArray[4][11] = 0.083649;
        dArray[4][12] = 0.437393;
        dArray[4][13] = 0.4413;
        dArray[4][14] = 0.122303;
        dArray[4][15] = 1.56059;
        dArray[4][16] = 0.570186;
        dArray[4][17] = 0.795736;
        dArray[4][18] = 0.604634;
        dArray[4][19] = 1.11457;
        dArray[5][6] = 6.04879;
        dArray[5][7] = 0.36651;
        dArray[5][8] = 4.74946;
        dArray[5][9] = 0.131046;
        dArray[5][10] = 0.964886;
        dArray[5][11] = 4.30831;
        dArray[5][12] = 1.70507;
        dArray[5][13] = 0.110744;
        dArray[5][14] = 1.03637;
        dArray[5][15] = 1.14121;
        dArray[5][16] = 0.954144;
        dArray[5][17] = 0.243615;
        dArray[5][18] = 0.252457;
        dArray[5][19] = 0.33389;
        dArray[6][7] = 0.630832;
        dArray[6][8] = 0.635025;
        dArray[6][9] = 0.14132;
        dArray[6][10] = 0.172579;
        dArray[6][11] = 2.86758;
        dArray[6][12] = 0.353912;
        dArray[6][13] = 0.09231;
        dArray[6][14] = 0.755791;
        dArray[6][15] = 0.782467;
        dArray[6][16] = 0.914814;
        dArray[6][17] = 0.172682;
        dArray[6][18] = 0.217549;
        dArray[6][19] = 0.655045;
        dArray[7][8] = 0.276379;
        dArray[7][9] = 0.034151;
        dArray[7][10] = 0.068651;
        dArray[7][11] = 0.415992;
        dArray[7][12] = 0.19422;
        dArray[7][13] = 0.055288;
        dArray[7][14] = 0.273149;
        dArray[7][15] = 1.4867;
        dArray[7][16] = 0.251477;
        dArray[7][17] = 0.374321;
        dArray[7][18] = 0.114187;
        dArray[7][19] = 0.209108;
        dArray[8][9] = 0.152215;
        dArray[8][10] = 0.555096;
        dArray[8][11] = 0.992083;
        dArray[8][12] = 0.450867;
        dArray[8][13] = 0.75608;
        dArray[8][14] = 0.771387;
        dArray[8][15] = 0.822459;
        dArray[8][16] = 0.525511;
        dArray[8][17] = 0.289998;
        dArray[8][18] = 4.29035;
        dArray[8][19] = 0.131869;
        dArray[9][10] = 3.51782;
        dArray[9][11] = 0.360574;
        dArray[9][12] = 4.71422;
        dArray[9][13] = 1.17764;
        dArray[9][14] = 0.111502;
        dArray[9][15] = 0.353443;
        dArray[9][16] = 1.61505;
        dArray[9][17] = 0.234326;
        dArray[9][18] = 0.468951;
        dArray[9][19] = 8.65974;
        dArray[10][11] = 0.287583;
        dArray[10][12] = 5.37525;
        dArray[10][13] = 2.3482;
        dArray[10][14] = 0.462018;
        dArray[10][15] = 0.382421;
        dArray[10][16] = 0.364222;
        dArray[10][17] = 0.740259;
        dArray[10][18] = 0.443205;
        dArray[10][19] = 1.99737;
        dArray[11][12] = 1.03222;
        dArray[11][13] = 0.098843;
        dArray[11][14] = 0.619503;
        dArray[11][15] = 1.07378;
        dArray[11][16] = 1.53792;
        dArray[11][17] = 0.152232;
        dArray[11][18] = 0.147411;
        dArray[11][19] = 0.342012;
        dArray[12][13] = 1.32087;
        dArray[12][14] = 0.194864;
        dArray[12][15] = 0.556353;
        dArray[12][16] = 1.68197;
        dArray[12][17] = 0.570369;
        dArray[12][18] = 0.47381;
        dArray[12][19] = 2.28202;
        dArray[13][14] = 0.179896;
        dArray[13][15] = 0.606814;
        dArray[13][16] = 0.191467;
        dArray[13][17] = 1.69978;
        dArray[13][18] = 7.15448;
        dArray[13][19] = 0.725096;
        dArray[14][15] = 1.78649;
        dArray[14][16] = 0.885349;
        dArray[14][17] = 0.156619;
        dArray[14][18] = 0.239607;
        dArray[14][19] = 0.35125;
        dArray[15][16] = 4.84713;
        dArray[15][17] = 0.578784;
        dArray[15][18] = 0.872519;
        dArray[15][19] = 0.258861;
        dArray[16][17] = 0.126678;
        dArray[16][18] = 0.32549;
        dArray[16][19] = 1.54767;
        dArray[17][18] = 2.76354;
        dArray[17][19] = 0.409817;
        dArray[18][19] = 0.347826;
        return dArray;
    }

    @Override
    public double[] getEmpiricalFrequencies() {
        double[] dArray = new double[]{0.0866279, 0.043972, 0.0390894, 0.0570451, 0.0193078, 0.0367281, 0.0580589, 0.0832518, 0.0244313, 0.048466, 0.086209, 0.0620286, 0.0195027, 0.0384319, 0.0457631, 0.0695179, 0.0610127, 0.0143859, 0.0352742, 0.0708956};
        dArray[0] = 0.0866;
        dArray[1] = 0.044;
        dArray[2] = 0.0391;
        dArray[3] = 0.057;
        dArray[4] = 0.0193;
        dArray[5] = 0.0367;
        dArray[6] = 0.0581;
        dArray[7] = 0.0833;
        dArray[8] = 0.0244;
        dArray[9] = 0.0485;
        dArray[10] = 0.0862;
        dArray[11] = 0.062;
        dArray[12] = 0.0195;
        dArray[13] = 0.0384;
        dArray[14] = 0.0458;
        dArray[15] = 0.0695;
        dArray[16] = 0.061;
        dArray[17] = 0.0144;
        dArray[18] = 0.0353;
        dArray[19] = 0.0709;
        return dArray;
    }

    @Override
    public int[] getEncodingOrder() {
        Aminoacid aminoacid = new Aminoacid();
        String string = aminoacid.getCodeMap();
        int[] nArray = new int[aminoacid.getStateCount()];
        String string2 = "ARNDCQEGHILKMFPSTWYV";
        for (int i = 0; i < aminoacid.getStateCount(); ++i) {
            nArray[i] = string2.indexOf(string.charAt(i));
        }
        return nArray;
    }

    @Override
    public boolean canHandleDataType(DataType dataType) {
        return dataType instanceof Aminoacid;
    }

    public static void main(String[] stringArray) {
        WAG wAG = new WAG();
        boolean[] blArray = new boolean[]{false, true, false, false, true, true, true, false, false, true, true, false, true, false, false, false, false, true, true, true};
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        double[] dArray = new double[45];
        double[] dArray2 = new double[45];
        double[] dArray3 = new double[100];
        double[][] dArray4 = wAG.getEmpiricalRates();
        for (int i = 0; i < 20; ++i) {
            for (int j = i + 1; j < 20; ++j) {
                if (blArray[i]) {
                    if (blArray[j]) {
                        dArray[n] = dArray4[i][j];
                        ++n;
                        continue;
                    }
                    dArray3[n3] = dArray4[i][j];
                    ++n3;
                    continue;
                }
                if (!blArray[j]) {
                    dArray2[n2] = dArray4[i][j];
                    ++n2;
                    continue;
                }
                dArray3[n3] = dArray4[i][j];
                ++n3;
            }
        }
        System.out.println("Within 1 mean rate = " + DiscreteStatistics.mean(dArray));
        System.out.println("Within 2 mean rate = " + DiscreteStatistics.mean(dArray2));
        System.out.println("Between mean rate = " + DiscreteStatistics.mean(dArray3));
        System.out.println("Within 1 rate stdev = " + DiscreteStatistics.stdev(dArray));
        System.out.println("Within 2 rate stdev = " + DiscreteStatistics.stdev(dArray2));
        System.out.println("Between rate stdev = " + DiscreteStatistics.stdev(dArray3));
        System.out.println("Within 1 rate stderr = " + DiscreteStatistics.stdev(dArray) / Math.sqrt(n));
        System.out.println("Within 2 rate stderr = " + DiscreteStatistics.stdev(dArray2) / Math.sqrt(n2));
        System.out.println("Between rate stderr = " + DiscreteStatistics.stdev(dArray3) / Math.sqrt(n3));
        double d = 0.0;
        double d2 = DiscreteStatistics.mean(dArray3);
        for (int i = 0; i < dArray3.length; ++i) {
            d += (d2 - dArray3[i]) * (d2 - dArray3[i]);
        }
        d /= (double)dArray3.length;
        d = Math.sqrt(d);
        System.out.println("Between rate sse = " + d);
        System.out.println("Within 1 count = " + n);
        System.out.println("Within 2 count = " + n2);
        System.out.println("Between count = " + n3);
    }
}

