/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.substitutionmodel;

import beast.core.Description;
import beast.core.Input;
import beast.core.parameter.RealParameter;
import beast.evolution.substitutionmodel.Frequencies;
import beast.evolution.substitutionmodel.GeneralSubstitutionModel;
import beast.evolution.tree.Node;
import java.lang.reflect.InvocationTargetException;

@Description(value="A substitution model where the rates and frequencies are obtained from empirical evidence. Especially, amino acid models like WAG.")
public abstract class EmpiricalSubstitutionModel
extends GeneralSubstitutionModel {
    double[] m_empiricalRates;

    public EmpiricalSubstitutionModel() {
        this.frequenciesInput.setRule(Input.Validate.OPTIONAL);
        this.ratesInput.setRule(Input.Validate.OPTIONAL);
    }

    @Override
    public void initAndValidate() {
        this.frequencies = this.getEmpericalFrequencieValues();
        this.m_empiricalRates = this.getEmpericalRateValues();
        int n = this.frequencies.getFreqs().length;
        if (this.m_empiricalRates.length != n * (n - 1)) {
            throw new IllegalArgumentException("The number of empirical rates (" + this.m_empiricalRates.length + ") should be " + "equal to #frequencies * (#frequencies-1) = (" + n + "*" + (n - 1) + ").");
        }
        this.updateMatrix = true;
        this.nrOfStates = this.frequencies.getFreqs().length;
        try {
            this.eigenSystem = this.createEigenSystem();
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException exception) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        this.rateMatrix = new double[this.nrOfStates][this.nrOfStates];
        this.relativeRates = new double[this.m_empiricalRates.length];
        this.storedRelativeRates = new double[this.m_empiricalRates.length];
    }

    @Override
    protected void setupRelativeRates() {
        System.arraycopy(this.m_empiricalRates, 0, this.relativeRates, 0, this.m_empiricalRates.length);
    }

    double[] getEmpericalRateValues() {
        double[][] dArray = this.getEmpiricalRates();
        int[] nArray = this.getEncodingOrder();
        int n = dArray.length;
        double[] dArray2 = new double[n * (n - 1)];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            for (int j = 0; j < n; ++j) {
                int n4 = nArray[j];
                if (i == j) continue;
                dArray2[n2++] = dArray[Math.min(n3, n4)][Math.max(n3, n4)];
            }
        }
        return dArray2;
    }

    Frequencies getEmpericalFrequencieValues() {
        double[] dArray = this.getEmpiricalFrequencies();
        int[] nArray = this.getEncodingOrder();
        int n = dArray.length;
        Frequencies frequencies = new Frequencies();
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + dArray[nArray[i]] + " ";
        }
        RealParameter realParameter = new RealParameter();
        realParameter.initByName("value", string, "lower", 0.0, "upper", 1.0, "dimension", n);
        frequencies.frequenciesInput.setValue(realParameter, frequencies);
        frequencies.initAndValidate();
        return frequencies;
    }

    abstract double[][] getEmpiricalRates();

    abstract double[] getEmpiricalFrequencies();

    abstract int[] getEncodingOrder();

    @Override
    public double[] getRateMatrix(Node node) {
        int n;
        double[][] dArray = this.getEmpiricalRates();
        int n2 = dArray.length;
        double[] dArray2 = new double[n2 * n2];
        for (n = 0; n < n2; ++n) {
            for (int i = n + 1; i < n2; ++i) {
                dArray2[n * n2 + i] = dArray[n][i];
                dArray2[i * n2 + n] = dArray[n][i];
            }
        }
        for (n = 0; n < n2; ++n) {
            double d = 0.0;
            for (int i = n + 1; i < n2; ++i) {
                d += dArray2[n * n2 + i];
            }
            dArray2[n * n2 + n] = -d;
        }
        return dArray2;
    }
}

