/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.speciation;

import beast.core.CalculationNode;
import beast.core.Description;
import beast.core.Input;
import beast.evolution.tree.Tree;
import java.util.ArrayList;
import java.util.List;

@Description(value="Finds height of highest tree among a set of trees")
public class TreeTopFinder
extends CalculationNode {
    public final Input<List<Tree>> treeInputs = new Input("tree", "set of trees to search among", new ArrayList());
    List<Tree> trees;
    double oldHeight;
    double height;

    @Override
    public void initAndValidate() {
        this.oldHeight = Double.NaN;
        this.trees = this.treeInputs.get();
        this.height = this.calcHighestTreeHeight();
    }

    public double getHighestTreeHeight() {
        return this.calcHighestTreeHeight();
    }

    private double calcHighestTreeHeight() {
        double d = 0.0;
        for (Tree tree : this.trees) {
            d = Math.max(tree.getRoot().getHeight(), d);
        }
        return d;
    }

    @Override
    protected boolean requiresRecalculation() {
        double d = this.calcHighestTreeHeight();
        if (d != this.height) {
            this.height = d;
            return true;
        }
        return false;
    }

    @Override
    protected void store() {
        this.oldHeight = this.height;
        super.store();
    }

    @Override
    protected void restore() {
        this.height = this.oldHeight;
        super.restore();
    }
}

