/*
 * Decompiled with CFR 0.152.
 */
package beast.app.tools;

import beast.app.BEASTVersion2;
import beast.app.tools.LogCombinerDialog;
import beast.app.util.Utils;
import beast.core.util.Log;
import beast.util.LogAnalyser;
import jam.console.ConsoleApplication;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.table.TableCellEditor;

public class LogCombiner
extends LogAnalyser {
    List<String> m_sLogFileName = new ArrayList<String>();
    String m_sParticleDir;
    int m_nParticles = -1;
    String m_sFileOut;
    PrintStream m_out = System.out;
    int m_nBurninPercentage = 10;
    private boolean preAmpleIsPrinted = false;
    private int columnCount = -1;
    boolean m_bIsTreeLog = false;
    List<String> m_sTrees;
    int m_nSampleInterval = -1;
    boolean m_bUseDecimalFormat = false;
    DecimalFormat format = new DecimalFormat("#.############E0", new DecimalFormatSymbols(Locale.US));
    int m_nResample = -1;
    Double[][] m_fCombinedTraces;

    private void parseArgs(String[] stringArray) {
        int n = 0;
        this.format = new DecimalFormat("#.############E0", new DecimalFormatSymbols(Locale.US));
        this.m_sLogFileName = new ArrayList<String>();
        try {
            while (n < stringArray.length) {
                int n2 = n;
                if (n >= stringArray.length) continue;
                if (stringArray[n].equals("")) {
                    ++n;
                } else if (stringArray[n].equals("-help") || stringArray[n].equals("-h") || stringArray[n].equals("--help")) {
                    Log.info.println(LogCombiner.getUsage());
                    System.exit(0);
                } else if (stringArray[n].equals("-o")) {
                    this.m_sFileOut = stringArray[n + 1];
                    this.m_out = new PrintStream(this.m_sFileOut);
                    n += 2;
                } else if (stringArray[n].equals("-b") || stringArray[n].equals("-burnin") || stringArray[n].equals("--burnin")) {
                    this.m_nBurninPercentage = Integer.parseInt(stringArray[n + 1]);
                    if (this.m_nBurninPercentage < 0 || this.m_nBurninPercentage > 100) {
                        Log.err.println("Error: Burn-in percentage must be between 0 and 100.");
                        System.exit(1);
                    }
                    n += 2;
                } else if (stringArray[n].equals("-n")) {
                    this.m_nParticles = Integer.parseInt(stringArray[n + 1]);
                    n += 2;
                } else if (stringArray[n].equals("-log")) {
                    this.m_sLogFileName.add(stringArray[n + 1]);
                    n += 2;
                    while (n < stringArray.length && !stringArray[n].startsWith("-")) {
                        this.m_sLogFileName.add(stringArray[n++]);
                    }
                } else if (stringArray[n].equals("-dir")) {
                    this.m_sParticleDir = stringArray[n + 1];
                    n += 2;
                } else if (stringArray[n].equals("-decimal")) {
                    this.m_bUseDecimalFormat = true;
                    this.format = new DecimalFormat("#.############", new DecimalFormatSymbols(Locale.US));
                    ++n;
                } else if (stringArray[n].equals("-resample")) {
                    this.m_nResample = Integer.parseInt(stringArray[n + 1]);
                    n += 2;
                } else if (stringArray[n].equals("-renumber")) {
                    this.m_nSampleInterval = 1;
                    ++n;
                }
                if (n != n2) continue;
                throw new IllegalArgumentException("Unrecognised argument");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalArgumentException("Error parsing command line arguments: " + Arrays.toString(stringArray) + "\nArguments ignored\n\n" + LogCombiner.getUsage());
        }
    }

    private void combineParticleLogs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.m_nParticles; ++i) {
            String string = this.m_sParticleDir + "/particle" + i;
            File file = new File(string);
            if (!file.exists() || !file.isDirectory()) {
                throw new IllegalArgumentException("Could not process particle " + i + ". Expected " + string + " to be a directory, but it is not.");
            }
            arrayList.add(string + "/" + this.m_sLogFileName.get(0));
        }
        int[] nArray = new int[arrayList.size()];
        Arrays.fill(nArray, this.m_nBurninPercentage);
        try {
            this.combineLogs(arrayList.toArray(new String[0]), nArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new IllegalArgumentException(iOException.getMessage());
        }
    }

    protected long readLogFile(String string, int n, long l) throws IOException {
        int n2;
        String string2;
        this.log("\nLoading " + string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        this.m_sPreAmble = "";
        this.m_sLabels = null;
        int n3 = 0;
        while (bufferedReader.ready()) {
            string2 = bufferedReader.readLine();
            if (string2.indexOf(35) < 0 && string2.matches(".*[0-9a-zA-Z].*")) {
                if (this.m_sLabels == null) {
                    this.m_sLabels = string2.split("\\s");
                    continue;
                }
                ++n3;
                continue;
            }
            this.m_sPreAmble = this.m_sPreAmble + string2 + "\n";
        }
        if (!this.preAmpleIsPrinted) {
            this.m_out.print(this.m_sPreAmble);
            for (n2 = 0; n2 < this.m_sLabels.length; ++n2) {
                this.m_out.print(this.m_sLabels[n2] + "\t");
            }
            this.m_out.println();
            this.preAmpleIsPrinted = true;
        }
        n2 = Math.max(1, n3 / 80);
        int n4 = this.m_sLabels.length;
        this.m_ranges = new List[n4];
        int n5 = n3 * n / 100;
        this.m_fTraces = new Double[n4][n3 - n5];
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(string));
        n3 = -n5 - 1;
        this.logln(", burnin " + n + "%, skipping " + n5 + " log lines\n\n" + "|---------|---------|---------|---------|---------|---------|---------|---------|");
        long l2 = -1L;
        while (bufferedReader.ready()) {
            string2 = bufferedReader.readLine();
            if (string2.indexOf(35) < 0 && string2.matches("[0-9].*") && ++n3 >= 0) {
                String[] stringArray = string2.split("\\s");
                long l3 = Long.parseLong(stringArray[0]);
                if (this.m_nSampleInterval < 0 && l2 >= 0L) {
                    this.m_nSampleInterval = this.m_nResample < 0 ? (int)(l3 - l2) : this.m_nResample;
                }
                l2 = l3;
                if (this.columnCount != stringArray.length) {
                    if (this.columnCount < 0) {
                        this.columnCount = stringArray.length;
                    } else {
                        bufferedReader.close();
                        throw new IllegalArgumentException("ERROR: The number of columns in file " + string + " does not match that of the first file");
                    }
                }
                if (l3 % (long)this.m_nResample == 0L || this.m_nResample < 0) {
                    l = l < 0L ? 0L : (l += (long)this.m_nSampleInterval);
                    this.m_out.print(l + "\t");
                    for (int i = 1; i < stringArray.length; ++i) {
                        if (this.m_bUseDecimalFormat && stringArray[i].indexOf(46) > 0) {
                            double d = Double.parseDouble(stringArray[i]);
                            this.m_out.print(this.format.format(d));
                        } else {
                            this.m_out.print(stringArray[i]);
                        }
                        this.m_out.print('\t');
                    }
                    this.m_out.println();
                }
            }
            if (n3 % n2 != 0) continue;
            this.log("*");
        }
        this.logln("");
        bufferedReader.close();
        return l;
    }

    private void combineLogs(String[] stringArray, int[] nArray) throws IOException {
        this.preAmpleIsPrinted = false;
        this.log("Writing to file " + this.m_sFileOut);
        try {
            this.m_out = new PrintStream(new File(this.m_sFileOut));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.log("Could not open file " + this.m_sFileOut + " for writing: " + fileNotFoundException.getMessage());
            return;
        }
        this.m_fCombinedTraces = null;
        int n = 0;
        long l = -1L;
        for (String string : stringArray) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            String string2 = bufferedReader.readLine();
            if (string2.toUpperCase().startsWith("#NEXUS")) {
                this.m_bIsTreeLog = true;
                l = this.readTreeLogFile(string, nArray[n], l);
            } else {
                l = this.readLogFile(string, nArray[n], l);
            }
            ++n;
            bufferedReader.close();
        }
        if (this.m_bIsTreeLog) {
            this.m_out.println("End;");
        }
        this.m_out.close();
        this.log("Wrote " + (l / (long)this.m_nSampleInterval + 1L) + " lines to " + this.m_sFileOut);
    }

    protected long readTreeLogFile(String string, int n, long l) throws IOException {
        this.log("\nLoading " + string);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = null;
        this.m_sPreAmble = "";
        int n2 = 0;
        while (bufferedReader.ready()) {
            string2 = bufferedReader.readLine();
            if (string2.matches("^tree STATE.*")) {
                ++n2;
                continue;
            }
            if (n2 != 0) continue;
            this.m_sPreAmble = this.m_sPreAmble + string2 + "\n";
        }
        if (!this.preAmpleIsPrinted) {
            this.m_out.println(this.m_sPreAmble);
            this.preAmpleIsPrinted = true;
        }
        int n3 = n2 / 80;
        int n4 = n2 * n / 100;
        this.logln(" skipping " + n4 + " trees\n\n" + "|---------|---------|---------|---------|---------|---------|---------|---------|");
        if (this.m_sTrees == null) {
            this.m_sTrees = new ArrayList<String>();
        }
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(string));
        n2 = -n4 - 1;
        long l2 = -1L;
        while (bufferedReader.ready()) {
            string2 = bufferedReader.readLine();
            if (string2.matches("^tree STATE_.*") && ++n2 >= 0) {
                String string3 = string2.substring(11, string2.indexOf("=")).trim();
                string3 = string3.split("\\s")[0];
                long l3 = Long.parseLong(string3);
                if (this.m_nSampleInterval < 0 && l2 >= 0L) {
                    this.m_nSampleInterval = this.m_nResample < 0 ? (int)(l3 - l2) : this.m_nResample;
                }
                l2 = l3;
                if (l3 % (long)this.m_nResample == 0L || this.m_nResample < 0) {
                    l = l < 0L ? 0L : (l += (long)this.m_nSampleInterval);
                    string2 = string2.replaceAll("^tree STATE_[^\\s]*", "");
                    this.m_out.print("tree STATE_" + l + string2);
                    this.m_out.println();
                }
            }
            if (n2 % n3 != 0) continue;
            this.log("*");
        }
        this.logln("");
        return l;
    }

    private void printCombinedLogs() {
        int n = this.m_bIsTreeLog ? this.m_sTrees.size() : this.m_fCombinedTraces[0].length;
        this.logln("Collected " + n + " lines in combined log");
        if (this.m_sFileOut != null) {
            this.log("Writing to file " + this.m_sFileOut);
            try {
                this.m_out = new PrintStream(new File(this.m_sFileOut));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.log("Could not open file " + this.m_sFileOut + " for writing: " + fileNotFoundException.getMessage());
                return;
            }
        }
        this.logln("\n\n|---------|---------|---------|---------|---------|---------|---------|---------|");
        this.m_out.println(this.m_sPreAmble);
        int n2 = 0;
        if (this.m_bIsTreeLog) {
            for (int i = 0; i < this.m_sTrees.size(); ++i) {
                if (this.m_nSampleInterval * i % this.m_nResample == 0) {
                    String string = this.m_sTrees.get(i);
                    string = this.format(string);
                    this.m_out.println("tree STATE_" + this.m_nSampleInterval * i + (Character.isSpaceChar(string.charAt(0)) ? "" : " ") + string);
                    ++n2;
                }
                if (i % (n / 80) != 0) continue;
                this.log("*");
            }
            this.m_out.println("End;");
        } else {
            int n3;
            for (n3 = 0; n3 < this.m_sLabels.length; ++n3) {
                this.m_out.print(this.m_sLabels[n3] + "\t");
            }
            this.m_out.println();
            for (n3 = 0; n3 < this.m_fCombinedTraces[0].length; ++n3) {
                if ((int)this.m_fCombinedTraces[0][n3].doubleValue() % this.m_nResample == 0) {
                    block10: for (int i = 0; i < this.m_types.length; ++i) {
                        switch (this.m_types[i]) {
                            case INTEGER: {
                                this.m_out.print((int)this.m_fCombinedTraces[i][n3].doubleValue() + "\t");
                                continue block10;
                            }
                            case REAL: {
                                this.m_out.print(this.format.format(this.m_fCombinedTraces[i][n3]) + "\t");
                                continue block10;
                            }
                            case NOMINAL: 
                            case BOOL: {
                                this.m_out.print(this.m_ranges[(int)this.m_fCombinedTraces[i][n3].doubleValue()] + "\t");
                            }
                        }
                    }
                    this.m_out.print("\n");
                    ++n2;
                }
                if (n / 80 <= 0 || n3 % (n / 80) != 0) continue;
                this.log("*");
            }
        }
        this.logln("\n" + n2 + " lines in combined log");
    }

    protected String format(String string) {
        block12: {
            block11: {
                if (!this.m_bUseDecimalFormat) break block11;
                if (!string.matches(".*[0-9]+\\.[0-9]+[0-9-]+E[0-9-]+.*")) break block12;
                int n = 0;
                while (n < string.length()) {
                    char c = string.charAt(n);
                    if (Character.isDigit(c)) {
                        int n2 = n;
                        while (++n < string.length() && Character.isDigit(string.charAt(n))) {
                        }
                        if (n >= string.length() || string.charAt(n) != '.') continue;
                        while (++n < string.length() && Character.isDigit(string.charAt(n))) {
                        }
                        if (n >= string.length() || string.charAt(n) != 'E' && string.charAt(n) != 'e') continue;
                        if (++n < string.length() && string.charAt(n) == '-') {
                            ++n;
                        }
                        if (n >= string.length() || !Character.isDigit(string.charAt(n))) continue;
                        while (++n < string.length() && Character.isDigit(string.charAt(n))) {
                        }
                        int n3 = n;
                        String string2 = string.substring(n2, n3);
                        double d = Double.parseDouble(string2);
                        string2 = this.format.format(d);
                        string = string.substring(0, n2) + string2 + string.substring(n3);
                        n = n2 + string2.length();
                        continue;
                    }
                    ++n;
                }
                break block12;
            }
            if (string.matches(".*[0-9]+\\.[0-9]+[^E-].*")) {
                int n = 0;
                while (n < string.length()) {
                    char c = string.charAt(n);
                    if (Character.isDigit(c)) {
                        int n4 = n;
                        while (++n < string.length() && Character.isDigit(string.charAt(n))) {
                        }
                        if (n >= string.length() || string.charAt(n) != '.') continue;
                        while (++n < string.length() && Character.isDigit(string.charAt(n))) {
                        }
                        if (n >= string.length() || string.charAt(n) == '-' || string.charAt(n) == 'E' || string.charAt(n) == 'e') continue;
                        int n5 = n;
                        String string3 = string.substring(n4, n5);
                        double d = Double.parseDouble(string3);
                        string3 = this.format.format(d);
                        string = string.substring(0, n4) + string3 + string.substring(n5);
                        n = n4 + string3.length();
                        continue;
                    }
                    ++n;
                }
            }
        }
        return string;
    }

    private static String getUsage() {
        return "Usage: LogCombiner -log <file> -n <int> [<options>]\ncombines multiple (trace or tree) log files into a single log file.\noptions:\n-log <file>      specify the name of the log file, each log file must be specified with separate -log option\n-o <output.log>  specify log file to write into (default output is stdout)\n-b <burnin>      specify the number PERCENTAGE of lines in the log file considered to be burnin (default 10)\n-dir <directory> specify particle directory -- used for particle filtering in BEASTLabs only -- if defined only one log must be specified and the -n option specified\n-n <int>         specify the number of particles, ignored if -dir is not defined\n-resample <int>  specify number of states to resample\n-decimal         flag to indicate numbers should converted from scientific into decimal format\n-renumber        flag to indicate output states should be renumbered\n-help            print this message\n";
    }

    private void printTitle(String string) {
        String[] stringArray;
        string = "LogCombiner" + string.replaceAll("</p>", "\n\n");
        string = string.replaceAll("<br>", "\n");
        string = string.replaceAll("<[^>]*>", " ");
        for (String string2 : stringArray = string.split("\n")) {
            int n = 80 - string2.length();
            int n2 = n / 2;
            for (int i = 0; i < n2; ++i) {
                this.log(" ");
            }
            this.logln(string2);
        }
    }

    public static void main(String[] stringArray) {
        BEASTVersion2 bEASTVersion2 = new BEASTVersion2();
        String string = bEASTVersion2.getVersionString();
        String string2 = "LogCombiner " + string;
        String string3 = "<html><center><p>" + string + ", " + bEASTVersion2.getDateString() + "</p>" + "<p>by<br>" + "<p>Andrew Rambaut and Alexei J. Drummond</p>" + "<p>Institute of Evolutionary Biology, University of Edinburgh<br>" + "<a href=\"mailto:a.rambaut@ed.ac.uk\">a.rambaut@ed.ac.uk</a></p>" + "<p>Department of Computer Science, University of Auckland<br>" + "<a href=\"mailto:alexei@cs.auckland.ac.nz\">alexei@cs.auckland.ac.nz</a></p>" + "<p>Part of the BEAST 2 package:<br>" + "<a href=\"http://beast2.cs.auckland.ac.nz/\">http://beast2.cs.auckland.ac.nz/</a></p>" + "</center></html>";
        LogCombiner logCombiner = new LogCombiner();
        try {
            if (stringArray.length == 0) {
                Utils.loadUIManager();
                System.setProperty("com.apple.macos.useScreenMenuBar", "true");
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                System.setProperty("apple.awt.showGrowBox", "true");
                URL uRL = LogCombiner.class.getResource("images/logcombiner.png");
                ImageIcon imageIcon = null;
                if (uRL != null) {
                    imageIcon = new ImageIcon(uRL);
                }
                String string4 = "<html><center><p>LogCombiner<br>Version " + bEASTVersion2.getVersionString() + ", " + bEASTVersion2.getDateString() + "</p></center></html>";
                new ConsoleApplication(string2, string3, imageIcon, true);
                Log.info = System.out;
                Log.warning = System.out;
                Log.err = System.err;
                logCombiner.printTitle(string3);
                LogCombinerDialog logCombinerDialog = new LogCombinerDialog(new JFrame(), string4, imageIcon);
                if (!logCombinerDialog.showDialog(string2)) {
                    return;
                }
                TableCellEditor tableCellEditor = logCombinerDialog.filesTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                logCombiner.m_bIsTreeLog = logCombinerDialog.isTreeFiles();
                logCombiner.m_bUseDecimalFormat = logCombinerDialog.convertToDecimal();
                if (logCombiner.m_bUseDecimalFormat) {
                    logCombiner.format = new DecimalFormat("#.############", new DecimalFormatSymbols(Locale.US));
                }
                if (!logCombinerDialog.renumberOutputStates()) {
                    logCombiner.m_nSampleInterval = -1;
                }
                if (logCombinerDialog.isResampling()) {
                    logCombiner.m_nResample = logCombinerDialog.getResampleFrequency();
                }
                String[] stringArray2 = logCombinerDialog.getFileNames();
                int[] nArray = logCombinerDialog.getBurnins();
                logCombiner.m_sFileOut = logCombinerDialog.getOutputFileName();
                if (logCombiner.m_sFileOut == null) {
                    Log.warning.println("No output file specified");
                }
                try {
                    logCombiner.combineLogs(stringArray2, nArray);
                }
                catch (Exception exception) {
                    Log.warning.println("Exception: " + exception.getMessage());
                    exception.printStackTrace();
                }
                System.out.println("Finished - Quit program to exit.");
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
            logCombiner.printTitle(string3);
            logCombiner.parseArgs(stringArray);
            if (logCombiner.m_sParticleDir == null) {
                String[] stringArray3 = logCombiner.m_sLogFileName.toArray(new String[0]);
                int[] nArray = new int[stringArray3.length];
                Arrays.fill(nArray, logCombiner.m_nBurninPercentage);
                logCombiner.combineLogs(stringArray3, nArray);
            } else {
                logCombiner.combineParticleLogs();
                logCombiner.printCombinedLogs();
            }
        }
        catch (Exception exception) {
            System.out.println(LogCombiner.getUsage());
            exception.printStackTrace();
        }
    }
}

