/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.draw.BEASTObjectShape;
import beast.app.draw.Document;
import beast.app.draw.InputShape;
import beast.app.draw.Shape;
import beast.core.util.Log;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.io.PrintStream;
import java.util.List;
import javax.swing.JPanel;
import org.w3c.dom.Node;

public class Arrow
extends Shape {
    String m_sHeadID;
    String m_sTailID;
    public BEASTObjectShape m_tailShape;
    public InputShape m_headShape;
    String m_sID = null;

    public Arrow(Node node, Document document, boolean bl) {
        this.parse(node, document, bl);
    }

    public Arrow(BEASTObjectShape bEASTObjectShape, int n, int n2) {
        this.m_sTailID = bEASTObjectShape.getID();
        this.m_x = n;
        this.m_y = n2;
        this.m_w = 1;
        this.m_h = 1;
        this.m_tailShape = bEASTObjectShape;
    }

    public Arrow(BEASTObjectShape bEASTObjectShape, BEASTObjectShape bEASTObjectShape2, String string) {
        this.m_sTailID = bEASTObjectShape.getID();
        this.m_tailShape = bEASTObjectShape;
        InputShape inputShape = bEASTObjectShape2.getInputShape(string);
        if (inputShape == null) {
            Log.warning.println("Arrow from " + bEASTObjectShape.m_beastObject.getID() + " to " + bEASTObjectShape2.m_beastObject.getID() + "." + string + " skipped");
        }
        this.m_sHeadID = inputShape.getID();
        this.m_headShape = inputShape;
        this.m_x = 0;
        this.m_y = 0;
        this.m_w = 1;
        this.m_h = 1;
        this.m_pencolor = Color.gray;
    }

    @Override
    public void draw(Graphics2D graphics2D, JPanel jPanel) {
        graphics2D.setStroke(new BasicStroke(this.m_nPenWidth));
        graphics2D.setColor(this.m_pencolor);
        graphics2D.setColor(Color.gray);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(this.m_x, this.m_y);
        generalPath.curveTo(this.m_x + 20, this.m_y, this.m_x + this.m_w - 40, this.m_y + this.m_h, this.m_x + this.m_w, this.m_y + this.m_h);
        graphics2D.draw(generalPath);
        this.drawLabel(graphics2D);
    }

    public void setHead(int n, int n2) {
        this.m_w = n;
        this.m_h = n2;
    }

    public boolean setHead(InputShape inputShape, List<Shape> list, Document document) {
        this.m_sHeadID = inputShape.getID();
        this.m_headShape = inputShape;
        this.adjustCoordinates();
        String string = this.m_headShape.getInputName();
        this.m_headShape.getBEASTObject().setInputValue(string, this.m_tailShape.m_beastObject);
        return true;
    }

    @Override
    void parse(Node node, Document document, boolean bl) {
        super.parse(node, document, bl);
        if (node.getAttributes().getNamedItem("headid") != null) {
            this.m_sHeadID = node.getAttributes().getNamedItem("headid").getNodeValue();
        }
        if (node.getAttributes().getNamedItem("tailid") != null) {
            this.m_sTailID = node.getAttributes().getNamedItem("tailid").getNodeValue();
        }
    }

    @Override
    String getAtts() {
        return " headid='" + this.m_sHeadID + "'" + " tailid='" + this.m_sTailID + "'" + super.getAtts();
    }

    @Override
    public String getXML() {
        return "<arrow" + this.getAtts() + "/>";
    }

    void adjustCoordinates() {
        Point point = new Point((this.m_tailShape.getX() + this.m_tailShape.getX2()) / 2, (this.m_tailShape.getY() + this.m_tailShape.getY2()) / 2);
        Point point2 = new Point((this.m_headShape.getX() + this.m_headShape.getX2()) / 2, (this.m_headShape.getY() + this.m_headShape.getY2()) / 2);
        Shape shape = this.m_tailShape;
        Point point3 = new Point(0, 0);
        if (shape instanceof InputShape) {
            point3.x = shape.m_w;
            point3.y = shape.m_h;
        }
        Point point4 = this.CalcIntersectionLineAndNode(point, point2, shape, point3);
        shape = this.m_headShape;
        point3 = new Point(0, 0);
        if (shape instanceof InputShape) {
            point3.x = shape.m_w;
            point3.y = shape.m_h;
        }
        Point point5 = this.CalcIntersectionLineAndNode(point2, point, shape, point3);
        this.m_x = point4.x;
        this.m_y = point4.y;
        this.m_w = point5.x - this.m_x;
        this.m_h = point5.y - this.m_y;
    }

    Point CalcIntersectionLineAndNode(Point point, Point point2, Shape shape, Point point3) {
        int n;
        Point point4 = new Point();
        int n2 = Math.abs((shape.getX() - shape.getX2()) / 2);
        int n3 = Math.abs((shape.getY() - shape.getY2()) / 2);
        int n4 = Math.abs(point3.x / 2);
        int n5 = Math.abs(point3.y / 2);
        if (point2.y != point.y) {
            n = point2.y > point.y ? point.y + n3 : point.y - n3;
            point4.y = n;
            point4.x = point.x + (point2.x - point.x) * (n - point.y) / (point2.y - point.y);
            if (point4.x >= point.x - n2 + n4 && point4.x <= point.x + n2 - n4) {
                return point4;
            }
        }
        if (point2.x != point.x) {
            n = point2.x > point.x ? point.x + n2 : point.x - n2;
            point4.x = n;
            point4.y = point.y + (point2.y - point.y) * (n - point.x) / (point2.x - point.x);
            if (point4.y >= point.y - n3 + n5 && point4.y <= point.y + n3 - n5) {
                return point4;
            }
        }
        double d = point2.x > point.x ? (double)(point.x + n2 - n4) : (double)(point.x - n2 + n4);
        double d2 = point2.y > point.y ? (double)(point.y + n3 - n5) : (double)(point.y - n3 + n5);
        double d3 = n4;
        double d4 = n5;
        double d5 = point2.x == point.x ? (double)(point2.y - point.y) / 1.0 : (double)(point2.y - point.y) / (double)(point2.x - point.x);
        double d6 = (double)point.y - d5 * (double)point.x;
        double d7 = 1.0 / (d3 * d3) + d5 * d5 / (d4 * d4);
        double d8 = -2.0 * d / (d3 * d3) + 2.0 * d5 * d6 / (d4 * d4) - 2.0 * d5 * d2 / (d4 * d4);
        double d9 = d * d / (d3 * d3) + d6 * d6 / (d4 * d4) - 2.0 * d6 * d2 / (d4 * d4) + d2 * d2 / (d4 * d4) - 1.0;
        point4.x = point2.x > point.x ? (int)((-d8 + Math.sqrt(d8 * d8 - 4.0 * d7 * d9)) / (2.0 * d7)) : (int)((-d8 - Math.sqrt(d8 * d8 - 4.0 * d7 * d9)) / (2.0 * d7));
        point4.y = (int)(d5 * (double)point4.x + d6);
        return point4;
    }

    @Override
    public String getID() {
        return this.m_sID;
    }

    public void setID(String string) {
        this.m_sID = string;
    }

    public String toString() {
        return this.m_sTailID + "-->" + this.m_sHeadID;
    }

    @Override
    void toSVG(PrintStream printStream) {
        printStream.println("<path d='M " + this.m_x + " " + this.m_y + " C " + (this.m_x + 20) + " " + this.m_y + " " + (this.m_x + this.m_w - 40) + " " + (this.m_y + this.m_h) + " " + (this.m_x + this.m_w) + " " + (this.m_y + this.m_h) + "'" + " stroke='rgb(" + this.m_pencolor.getRed() + "," + this.m_pencolor.getGreen() + "," + this.m_pencolor.getBlue() + ")'" + " stroke-width='" + this.m_nPenWidth + "' fill='none'/>");
    }
}

