/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.GuessPatternDialog;
import beast.app.draw.BEASTObjectInputEditor;
import beast.app.draw.InputEditor;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.util.Log;
import beast.evolution.alignment.Taxon;
import beast.evolution.tree.TraitSet;
import beast.evolution.tree.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TipDatesInputEditor
extends BEASTObjectInputEditor {
    private static final long serialVersionUID = 1L;
    DateFormat dateFormat = DateFormat.getDateInstance();
    Tree tree;
    TraitSet traitSet;
    JComboBox<TraitSet.Units> unitsComboBox;
    JComboBox<String> relativeToComboBox;
    List<String> taxa;
    Object[][] tableData;
    JTable table;
    String m_sPattern = ".*(\\d\\d\\d\\d).*";
    JScrollPane scrollPane;
    List<Taxon> taxonsets;

    public TipDatesInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return Tree.class;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.m_bAddButtons = bl;
        this.itemNr = n;
        this.tree = n >= 0 ? (Tree)((List)input.get()).get(n) : (Tree)input.get();
        if (this.tree != null) {
            try {
                this.m_input = this.tree.getInput("trait");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.m_beastObject = this.tree;
            this.traitSet = this.tree.getDateTrait();
            Box box = Box.createVerticalBox();
            JCheckBox jCheckBox = new JCheckBox("Use tip dates", this.traitSet != null);
            jCheckBox.addActionListener(actionEvent -> {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                try {
                    if (jCheckBox.isSelected()) {
                        if (this.traitSet == null) {
                            this.traitSet = new TraitSet();
                            this.traitSet.initByName("traitname", "date", "taxa", this.tree.getTaxonset(), "value", "");
                            this.traitSet.setID("dateTrait.t:" + BeautiDoc.parsePartition(this.tree.getID()));
                        }
                        this.tree.setDateTrait(this.traitSet);
                    } else {
                        this.tree.setDateTrait(null);
                    }
                    this.refreshPanel();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            });
            Box box2 = Box.createHorizontalBox();
            box2.add(jCheckBox);
            box2.add(Box.createHorizontalGlue());
            box.add(box2);
            if (this.traitSet != null) {
                box.add(this.createButtonBox());
                box.add(this.createListBox());
            }
            this.add(box);
        }
    }

    private Component createListBox() {
        this.taxa = this.traitSet.taxaInput.get().asStringList();
        Object[] objectArray = new String[]{"Name", "Date", "Height"};
        this.tableData = new Object[this.taxa.size()][3];
        this.convertTraitToTableData();
        this.table = new JTable(this.tableData, objectArray){
            private static final long serialVersionUID = 1L;

            @Override
            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (this.isCellSelected(n, n2)) {
                    component.setBackground(Color.lightGray);
                } else if (n % 2 == 0 && !this.isCellSelected(n, n2)) {
                    component.setBackground(new Color(237, 243, 255));
                } else {
                    component.setBackground(Color.white);
                }
                return component;
            }
        };
        this.table.setDefaultEditor(Object.class, new TableCellEditor(){
            JTextField m_textField = new JTextField();
            int m_iRow;
            int m_iCol;

            @Override
            public boolean stopCellEditing() {
                TipDatesInputEditor.this.table.removeEditor();
                String string = this.m_textField.getText();
                TipDatesInputEditor.this.tableData[this.m_iRow][this.m_iCol] = string;
                TipDatesInputEditor.this.convertTableDataToTrait();
                TipDatesInputEditor.this.convertTraitToTableData();
                return true;
            }

            @Override
            public boolean isCellEditable(EventObject eventObject) {
                return TipDatesInputEditor.this.table.getSelectedColumn() == 1;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                if (!bl) {
                    return null;
                }
                this.m_iRow = n;
                this.m_iCol = n2;
                this.m_textField.setText((String)object);
                return this.m_textField;
            }

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                return false;
            }

            @Override
            public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            }

            @Override
            public Object getCellEditorValue() {
                return null;
            }

            @Override
            public void cancelCellEditing() {
            }

            @Override
            public void addCellEditorListener(CellEditorListener cellEditorListener) {
            }
        });
        int n = this.table.getFont().getSize();
        this.table.setRowHeight(24 * n / 13);
        this.scrollPane = new JScrollPane(this.table);
        return this.scrollPane;
    }

    private void convertTraitToTableData() {
        int n;
        Object object;
        for (int i = 0; i < this.tableData.length; ++i) {
            this.tableData[i][0] = this.taxa.get(i);
            this.tableData[i][1] = "0";
            this.tableData[i][2] = "0";
        }
        String[] stringArray = this.traitSet.traitsInput.get().split(",");
        for (String string : stringArray) {
            String[] stringArray2 = (string = string.replaceAll("\\s+", " ")).split("=");
            if (stringArray2.length != 2) break;
            String string2 = this.normalize(stringArray2[0]);
            int n2 = this.taxa.indexOf(string2);
            if (n2 >= 0) {
                this.tableData[n2][1] = this.normalize(stringArray2[1]);
                this.tableData[n2][0] = string2;
                continue;
            }
            Log.warning.println("WARNING: File contains taxon " + string2 + " that cannot be found in alignment");
        }
        if (this.traitSet.traitNameInput.get().equals("date-backward")) {
            object = Double.MAX_VALUE;
            for (n = 0; n < this.tableData.length; ++n) {
                object = Math.min((Double)object, this.parseDate((String)this.tableData[n][1]));
            }
            for (n = 0; n < this.tableData.length; ++n) {
                this.tableData[n][2] = this.parseDate((String)this.tableData[n][1]) - (Double)object;
            }
        } else {
            object = 0.0;
            for (n = 0; n < this.tableData.length; ++n) {
                object = Math.max((Double)object, this.parseDate((String)this.tableData[n][1]));
            }
            for (n = 0; n < this.tableData.length; ++n) {
                this.tableData[n][2] = (Double)object - this.parseDate((String)this.tableData[n][1]);
            }
        }
        if (this.table != null) {
            for (int i = 0; i < this.tableData.length; ++i) {
                this.table.setValueAt(this.tableData[i][1], i, 1);
                this.table.setValueAt(this.tableData[i][2], i, 2);
            }
        }
    }

    private double parseDate(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.matches(".*[a-zA-Z].*")) {
                string = string.replace('/', '-');
            }
            long l = Date.parse(string);
            Date date = new Date(l);
            Calendar calendar = this.dateFormat.getCalendar();
            calendar.setTime(date);
            int n = calendar.get(1);
            double d = calendar.get(6);
            double d2 = 365.0;
            if (calendar instanceof GregorianCalendar && ((GregorianCalendar)calendar).isLeapYear(n)) {
                d2 = 366.0;
            }
            double d3 = (double)n + d / d2;
            return d3;
        }
    }

    private String normalize(String string) {
        if (string.charAt(0) == ' ') {
            string = string.substring(1);
        }
        if (string.endsWith(" ")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private void convertTableDataToTrait() {
        String string = "";
        for (int i = 0; i < this.tableData.length; ++i) {
            string = string + this.taxa.get(i) + "=" + this.tableData[i][1];
            if (i >= this.tableData.length - 1) continue;
            string = string + ",\n";
        }
        try {
            this.traitSet.traitsInput.setValue(string, this.traitSet);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Box createButtonBox() {
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel("Dates specified as: ");
        jLabel.setMaximumSize(jLabel.getPreferredSize());
        box.add(jLabel);
        this.unitsComboBox = new JComboBox<TraitSet.Units>(TraitSet.Units.values());
        this.unitsComboBox.setSelectedItem((Object)this.traitSet.unitsInput.get());
        this.unitsComboBox.addActionListener(actionEvent -> {
            String string = this.unitsComboBox.getSelectedItem().toString();
            try {
                this.traitSet.unitsInput.setValue(string, this.traitSet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        });
        Dimension dimension = this.unitsComboBox.getPreferredSize();
        this.unitsComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.unitsComboBox.getPreferredSize().height));
        this.unitsComboBox.setSize(dimension);
        box.add(this.unitsComboBox);
        this.relativeToComboBox = new JComboBox<String>(new String[]{"Since some time in the past", "Before the present"});
        this.relativeToComboBox.setToolTipText("Whether dates go forward or backward");
        if (this.traitSet.traitNameInput.get().equals("date-backward")) {
            this.relativeToComboBox.setSelectedIndex(1);
        } else {
            this.relativeToComboBox.setSelectedIndex(0);
        }
        this.relativeToComboBox.addActionListener(actionEvent -> {
            String string = "date-backward";
            if (this.relativeToComboBox.getSelectedIndex() == 0) {
                string = "date-forward";
            }
            try {
                this.traitSet.traitNameInput.setValue(string, this.traitSet);
                Log.warning.println("Relative position is now: " + this.traitSet.traitNameInput.get());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.convertTraitToTableData();
        });
        this.relativeToComboBox.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.relativeToComboBox.getPreferredSize().height));
        box.add(this.relativeToComboBox);
        box.add(Box.createHorizontalGlue());
        JButton jButton = new JButton("Auto-configure");
        jButton.setToolTipText("Automatically configure dates based on taxon names");
        jButton.setName("Guess");
        jButton.addActionListener(actionEvent -> {
            GuessPatternDialog guessPatternDialog = new GuessPatternDialog(null, this.m_sPattern);
            guessPatternDialog.allowAddingValues();
            String string = "";
            switch (guessPatternDialog.showDialog("Guess dates")) {
                case canceled: {
                    return;
                }
                case trait: {
                    string = guessPatternDialog.getTrait();
                    break;
                }
                case pattern: {
                    for (String string2 : this.taxa) {
                        String string3 = guessPatternDialog.match(string2);
                        if (string3 == null) {
                            return;
                        }
                        double d = this.parseDate(string3);
                        if (string.length() > 0) {
                            string = string + ",";
                        }
                        string = string + string2 + "=" + d;
                    }
                    break;
                }
            }
            try {
                this.traitSet.traitsInput.setValue(string, this.traitSet);
                this.convertTraitToTableData();
                this.convertTableDataToTrait();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refreshPanel();
        });
        box.add(jButton);
        JButton jButton2 = new JButton("Clear");
        jButton2.setToolTipText("Set all dates to zero");
        jButton2.addActionListener(actionEvent -> {
            try {
                this.traitSet.traitsInput.setValue("", this.traitSet);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.refreshPanel();
        });
        box.add(jButton2);
        return box;
    }
}

