/*
 * Decompiled with CFR 0.152.
 */
package beast.app.beauti;

import beast.app.beauti.BeautiDoc;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TaxonSetDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    public boolean isOK = false;
    TaxonSet taxonSet;
    String id;
    List<Taxon> _candidates;
    JTextField idEntry;
    JTextField filterEntry;
    JList<Taxon> listOfTaxonCandidates;
    DefaultListModel<Taxon> listModel1;
    JList<Taxon> listOfTaxonSet;
    DefaultListModel<Taxon> listModel2;
    Box box;
    BeautiDoc doc;

    public TaxonSetDialog(TaxonSet taxonSet, Set<Taxon> set, BeautiDoc beautiDoc) {
        int n;
        this.taxonSet = taxonSet;
        this.doc = beautiDoc;
        this.id = taxonSet.getID();
        this.box = Box.createVerticalBox();
        this.box.add(this.createIDBox());
        this.box.add(this.createFilterBox());
        this.box.add(this.createTaxonSelector());
        this.box.add(Box.createVerticalGlue());
        List<Taxon> list = taxonSet.taxonsetInput.get();
        Comparator comparator = (taxon, taxon2) -> taxon.getID().compareTo(taxon2.getID());
        Collections.sort(list, comparator);
        this._candidates = new ArrayList<Taxon>();
        this._candidates.addAll(set);
        Collections.sort(this._candidates, comparator);
        for (Taxon taxon3 : list) {
            this.listModel2.addElement(taxon3);
        }
        for (Taxon taxon3 : this._candidates) {
            this.listModel1.addElement(taxon3);
        }
        for (n = 0; n < this.listModel2.size(); ++n) {
            this.listModel1.removeElement(this.listModel2.get(n));
        }
        this.add(this.box);
        n = UIManager.getFont("Label.font").getSize();
        this.setSize(400 * n / 13, 600 * n / 13);
        this.setModal(true);
    }

    public boolean showDialog() {
        JOptionPane jOptionPane = new JOptionPane(this.box, 3, 2, null, null, null);
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        Frame frame = this.doc != null ? this.doc.getFrame() : Frame.getFrames()[0];
        JDialog jDialog = jOptionPane.createDialog(frame, "Taxon set editor");
        jDialog.pack();
        jDialog.setVisible(true);
        int n = 2;
        Integer n2 = (Integer)jOptionPane.getValue();
        if (n2 != null && n2 != -1) {
            n = n2;
        }
        boolean bl = this.isOK = n != 2;
        if (this.isOK) {
            this.taxonSet.setID(this.id);
            List<Taxon> list = this.taxonSet.taxonsetInput.get();
            while (list.size() > 0) {
                list.remove(0);
            }
            for (int i = 0; i < this.listModel2.size(); ++i) {
                list.add(this.listModel2.get(i));
            }
            this.isOK = true;
            this.dispose();
        }
        return this.isOK;
    }

    private Component createFilterBox() {
        Box box = Box.createHorizontalBox();
        JLabel jLabel = new JLabel("Filter:");
        box.add(jLabel);
        this.filterEntry = new JTextField();
        this.filterEntry.setColumns(17);
        this.filterEntry.setToolTipText("Enter regular expression to match taxa");
        int n = this.filterEntry.getFont().getSize();
        this.filterEntry.setMaximumSize(new Dimension(1024 * n / 13, 50 * n / 13));
        box.add(this.filterEntry);
        box.add(Box.createHorizontalGlue());
        this.filterEntry.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TaxonSetDialog.this.processEntry();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TaxonSetDialog.this.processEntry();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TaxonSetDialog.this.processEntry();
            }
        });
        return box;
    }

    private void processEntry() {
        String string = ".*" + this.filterEntry.getText() + ".*";
        this.listModel1.clear();
        for (Taxon taxon : this._candidates) {
            if (!taxon.getID().matches(string)) continue;
            this.listModel1.addElement(taxon);
        }
        for (int i = 0; i < this.listModel2.size(); ++i) {
            this.listModel1.removeElement(this.listModel2.get(i));
        }
    }

    Component createIDBox() {
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Taxon set label:"));
        this.idEntry = new JTextField();
        this.idEntry.setName("idEntry");
        this.idEntry.setText(this.id);
        box.add(this.idEntry);
        this.idEntry.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TaxonSetDialog.this.id = TaxonSetDialog.this.idEntry.getText();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                TaxonSetDialog.this.id = TaxonSetDialog.this.idEntry.getText();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                TaxonSetDialog.this.id = TaxonSetDialog.this.idEntry.getText();
            }
        });
        int n = this.idEntry.getFont().getSize();
        box.setMaximumSize(new Dimension(400 * n / 13, 100 * n / 13));
        return box;
    }

    Component createTaxonSelector() {
        Box box = Box.createHorizontalBox();
        this.listModel1 = new DefaultListModel();
        this.listOfTaxonCandidates = new JList<Taxon>(this.listModel1);
        this.listOfTaxonCandidates.setName("listOfTaxonCandidates");
        this.listOfTaxonCandidates.setBorder(BorderFactory.createEtchedBorder());
        this.listOfTaxonCandidates.setCellRenderer(new TaxonCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.listOfTaxonCandidates);
        box.add(jScrollPane);
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createGlue());
        JButton jButton = new JButton(">>");
        jButton.setName(">>");
        jButton.addActionListener(actionEvent -> {
            int[] nArray;
            for (int n : nArray = this.listOfTaxonCandidates.getSelectedIndices()) {
                this.listModel2.addElement(this.listModel1.get(n));
            }
            for (int i = 0; i < this.listModel2.size(); ++i) {
                this.listModel1.removeElement(this.listModel2.get(i));
            }
        });
        box2.add(jButton);
        JButton jButton2 = new JButton("<<");
        jButton2.setName("<<");
        jButton2.addActionListener(actionEvent -> {
            int[] nArray;
            for (int n : nArray = this.listOfTaxonSet.getSelectedIndices()) {
                this.listModel1.addElement(this.listModel2.get(n));
            }
            for (int i = 0; i < this.listModel1.size(); ++i) {
                this.listModel2.removeElement(this.listModel1.get(i));
            }
        });
        box2.add(jButton2);
        box2.add(Box.createGlue());
        box.add(box2);
        this.listModel2 = new DefaultListModel();
        this.listOfTaxonSet = new JList<Taxon>(this.listModel2);
        this.listOfTaxonSet.setBorder(BorderFactory.createEtchedBorder());
        this.listOfTaxonSet.setCellRenderer(new TaxonCellRenderer());
        JScrollPane jScrollPane2 = new JScrollPane(this.listOfTaxonSet);
        box.add(jScrollPane2);
        return box;
    }

    Component createCancelOKButtons() {
        Box box = Box.createHorizontalBox();
        box.setBorder(new EtchedBorder());
        JButton jButton = new JButton("Ok");
        jButton.setName("OK");
        jButton.addActionListener(actionEvent -> {
            this.taxonSet.setID(this.id);
            List<Taxon> list = this.taxonSet.taxonsetInput.get();
            while (list.size() > 0) {
                list.remove(0);
            }
            for (int i = 0; i < this.listModel2.size(); ++i) {
                list.add(this.listModel2.get(i));
            }
            this.isOK = true;
            this.dispose();
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.setName("Cancel");
        jButton2.addActionListener(actionEvent -> this.dispose());
        box.add(Box.createHorizontalGlue());
        box.add(jButton);
        box.add(Box.createHorizontalGlue());
        box.add(jButton2);
        box.add(Box.createHorizontalGlue());
        return box;
    }

    class TaxonCellRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        TaxonCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
            jLabel.setText(((Taxon)object).getID());
            return jLabel;
        }
    }
}

