/*
 * Decompiled with CFR 0.152.
 */
package viz.process;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import viz.DensiTree;
import viz.Node;
import viz.process.CladeBranchInfo;

public class BranchScorer {
    Map<Integer, CladeBranchInfo> m_cladeBranchInfo;
    DensiTree m_dt;
    double nonCladeScore = -1.0;
    Node[] nodes;
    float[] heights;

    public BranchScorer(DensiTree dt, Node[] nodes) {
        this.nodes = nodes;
        this.m_cladeBranchInfo = new HashMap<Integer, CladeBranchInfo>();
        this.m_dt = dt;
    }

    double score(float[] heights) {
        double cladeScore = 0.0;
        HashSet<Integer> clades = new HashSet<Integer>();
        Node[] nodeArray = this.nodes;
        int n = this.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            int iClade = node.m_iClade;
            clades.add(iClade);
            if (!node.isRoot()) {
                int iNode = node.getNr();
                CladeBranchInfo info = null;
                if (!this.m_cladeBranchInfo.containsKey(node.m_iClade)) {
                    info = new CladeBranchInfo();
                    info.initialise(this.m_dt.m_cladeHeightSetBottom.get(iClade), this.m_dt.m_cladeHeightSetTop.get(iClade), this.m_dt.m_trees.length);
                    this.m_cladeBranchInfo.put(iClade, info);
                } else {
                    info = this.m_cladeBranchInfo.get(iClade);
                }
                cladeScore += (double)info.score(heights[node.getParent().getNr()], heights[iNode]);
            } else if (!this.m_cladeBranchInfo.containsKey(iClade)) {
                this.m_cladeBranchInfo.put(iClade, new CladeBranchInfo());
            }
            ++n2;
        }
        if (this.nonCladeScore < 0.0) {
            this.nonCladeScore = 0.0;
            int i = 0;
            while (i < this.m_dt.m_cladeHeightSetBottom.size()) {
                if (!clades.contains(i)) {
                    List<Double> bottom = this.m_dt.m_cladeHeightSetBottom.get(i);
                    List<Double> top = this.m_dt.m_cladeHeightSetTop.get(i);
                    double sum = 0.0;
                    int j = 0;
                    while (j < bottom.size()) {
                        sum += bottom.get(j) - top.get(j);
                        ++j;
                    }
                    this.nonCladeScore += sum;
                }
                ++i;
            }
        }
        return cladeScore + this.nonCladeScore;
    }
}

