/*
 * Decompiled with CFR 0.152.
 */
package viz.graphics;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Random;
import java.util.Vector;
import viz.Node;

public class PovRayExporter {
    static Random m_random = new Random();

    public static void export(Node tree, String sFile, double fScaleX, double fScaleY, Vector<String> sLabels) {
        try {
            FileWriter outFile = new FileWriter(sFile);
            PrintWriter out = new PrintWriter(outFile);
            out.println("#version 3.1;");
            out.println("global_settings { assumed_gamma 2.2 }");
            out.println("#include \"densitree.inc\"");
            float fTotalHeight = PovRayExporter.height(tree);
            out.println("box{<-1255.7326263189316, " + (double)(-fTotalHeight) * fScaleX + ", -300>,<1255.7326263189316, " + ((double)(-fTotalHeight) * fScaleX - 1000.0) + ", 300>");
            out.println("texture{T_Grass}}");
            out.println("merge {");
            PovRayExporter.exportNode(tree, out, fScaleY, fScaleX, sLabels, fTotalHeight);
            out.println("}");
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static float height(Node node) {
        if (node.isLeaf()) {
            return node.m_fLength;
        }
        return node.m_fLength + Math.max(PovRayExporter.height(node.m_left), PovRayExporter.height(node.m_right));
    }

    static float exportNode(Node node, PrintWriter out, double fScaleX, double fScaleY, Vector<String> sLabels, float fTotalHeight) {
        if (node.isLeaf()) {
            out.println("text");
            out.println("{  ttf \"timrom.ttf\" \"" + sLabels.elementAt(node.getNr()) + "\" 0.001, 0");
            out.println("   pigment { rgb 1 }");
            out.println("   finish { ambient 1 }");
            out.println("   rotate <0,0,45>");
            out.println("   scale <50,50,50>");
            out.println("   translate <" + (double)(-node.m_fPosX) * fScaleX + ", " + 0 + ", -3>");
            out.println("}");
            return node.m_fLength;
        }
        float fHeightL = PovRayExporter.exportNode(node.m_left, out, fScaleX, fScaleY, sLabels, fTotalHeight);
        float fHeightR = PovRayExporter.exportNode(node.m_right, out, fScaleX, fScaleY, sLabels, fTotalHeight);
        float fHeight = node.m_fLength + Math.max(fHeightL, fHeightR);
        float fEndThickness = (float)(fScaleX / 2.0 * (double)fHeightL / (double)fTotalHeight);
        if (node.m_left.isLeaf()) {
            fEndThickness = (float)(fScaleX / 2.0 * 0.1);
        }
        PovRayExporter.exportBranche(out, (double)(-node.m_fPosX) * fScaleX, (double)(-fHeightL) * fScaleY, fScaleX / 2.0 * (double)fHeight / (double)fTotalHeight, (double)(-node.m_left.m_fPosX) * fScaleX, (double)(-(fHeightL + node.m_left.m_fLength)) * fScaleY, fEndThickness, 2);
        fEndThickness = (float)(fScaleX / 2.0 * (double)fHeightR / (double)fTotalHeight);
        if (node.m_right.isLeaf()) {
            fEndThickness = (float)(fScaleX / 2.0 * 0.1);
        }
        PovRayExporter.exportBranche(out, (double)(-node.m_fPosX) * fScaleX, (double)(-fHeightR) * fScaleY, fScaleX / 2.0 * (double)fHeight / (double)fTotalHeight, (double)(-node.m_right.m_fPosX) * fScaleX, (double)(-(fHeightL + node.m_right.m_fLength)) * fScaleY, fEndThickness, 2);
        return fHeight;
    }

    static void exportBranche(PrintWriter out, double fX0, double fY0, double fWidth0, double fX1, double fY1, double fWidth1, int nDepth) {
        if (nDepth == 0) {
            PovRayExporter.exportBranche(out, fX0, fY0, fWidth0, fX1, fY1, fWidth1);
        } else {
            double fX2 = (fX0 + fX1) / 2.0 + (0.5 - m_random.nextDouble()) * (fX0 - fX1) / 2.0;
            double fY2 = (fY0 + fY1) / 2.0;
            double fYDelta = 0.0 * (0.5 - m_random.nextDouble()) * (fY0 - fY1) / 10.0;
            double fWidth2 = (fWidth0 + fWidth1) / 2.0;
            PovRayExporter.exportBranche(out, fX2, fY0 + (fY0 - fY1) / 2.0, fWidth2, fX1, fY0, fWidth1 - fYDelta, nDepth - 1);
            PovRayExporter.exportBranche(out, fX0, fY0, fWidth0, fX2, fY2 + fYDelta, fWidth2, nDepth - 1);
        }
    }

    static void exportBranche(PrintWriter out, double fX0, double fY0, double fWidth0, double fX1, double fY1, double fWidth1) {
        double fSkew = (fX1 - fX0) / (fY0 - fY1);
        out.println("cone {");
        out.println("   <0,0,0>," + fWidth0 + ",");
        out.println("   <-1,0,0>," + fWidth1);
        out.println("   rotate  -z*90");
        out.println("   scale  <1," + (fY0 - fY1) + ",1>");
        out.println("     matrix < 1.0, 0.0, 0.0,");
        out.println("           " + fSkew + ", 1.0, 0.0,");
        out.println("           0.0, 0.0, 1.0,");
        out.println("           0.0, 0.0, 0.0 >");
        out.println("\ttexture {Bark}");
        out.println("   translate <" + fX0 + ", " + fY0 + ", -3>");
        out.println("}");
    }
}

