/*
 * Decompiled with CFR 0.152.
 */
package jam.console;

import jam.console.ConsoleFrame;
import jam.console.ConsoleMenuBarFactory;
import jam.framework.Application;
import jam.framework.DocumentFrame;
import jam.framework.MenuBarFactory;
import jam.mac.Utils;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Icon;
import javax.swing.JFrame;

public class ConsoleApplication
extends Application {
    private ConsoleFrame consoleFrame = null;
    private boolean dontAskSave;

    public ConsoleApplication(String string, String string2, Icon icon, boolean bl) throws IOException {
        this(new ConsoleMenuBarFactory(), string, string2, icon, bl);
    }

    public ConsoleApplication(MenuBarFactory menuBarFactory, String string, String string2, Icon icon, boolean bl) throws IOException {
        super(menuBarFactory, string, string2, icon);
        this.dontAskSave = bl;
        this.consoleFrame = new ConsoleFrame();
        this.consoleFrame.initialize();
        this.consoleFrame.setVisible(true);
        this.consoleFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConsoleApplication.this.thisWindowClosing(windowEvent);
            }
        });
    }

    public void initialize() {
        if (Utils.isMacOSX()) {
            Utils.macOSXRegistration(this);
        }
    }

    protected JFrame getDefaultFrame() {
        return this.consoleFrame;
    }

    public DocumentFrame doNew() {
        throw new RuntimeException("A ConsoleApplication cannot do a New command");
    }

    public DocumentFrame doOpenFile(File file) {
        throw new RuntimeException("A ConsoleApplication cannot do an Open command");
    }

    public void doCloseWindow() {
        this.doQuit();
    }

    public void doQuit() {
        if (this.dontAskSave || this.consoleFrame.requestClose()) {
            this.consoleFrame.setVisible(false);
            this.consoleFrame.dispose();
            System.exit(0);
        }
    }

    public void doPreferences() {
    }

    public void doStop() {
        this.doQuit();
    }

    private void thisWindowClosing(WindowEvent windowEvent) {
        this.doQuit();
    }
}

