/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "scalefilter_options.h"

ScalefilterOptions::ScalefilterOptions (bool init /* = true */) :
    mOptions (ScalefilterOptions::OptionNum),
    mNotify (ScalefilterOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
ScalefilterOptions::initOptions ()
{
    unsigned short color[4];

    // timeout
    mOptions[ScalefilterOptions::Timeout].setName ("timeout", CompOption::TypeInt);
    mOptions[ScalefilterOptions::Timeout].rest ().set (0, 10000);
    mOptions[ScalefilterOptions::Timeout].value().set((int) 0);

    // filter_case_insensitive
    mOptions[ScalefilterOptions::FilterCaseInsensitive].setName ("filter_case_insensitive", CompOption::TypeBool);
    mOptions[ScalefilterOptions::FilterCaseInsensitive].value().set(true);

    // filter_display
    mOptions[ScalefilterOptions::FilterDisplay].setName ("filter_display", CompOption::TypeBool);
    mOptions[ScalefilterOptions::FilterDisplay].value().set(true);

    // font_bold
    mOptions[ScalefilterOptions::FontBold].setName ("font_bold", CompOption::TypeBool);
    mOptions[ScalefilterOptions::FontBold].value().set(true);

    // font_size
    mOptions[ScalefilterOptions::FontSize].setName ("font_size", CompOption::TypeInt);
    mOptions[ScalefilterOptions::FontSize].rest ().set (6, 48);
    mOptions[ScalefilterOptions::FontSize].value().set((int) 24);

    // border_size
    mOptions[ScalefilterOptions::BorderSize].setName ("border_size", CompOption::TypeInt);
    mOptions[ScalefilterOptions::BorderSize].rest ().set (1, 20);
    mOptions[ScalefilterOptions::BorderSize].value().set((int) 5);

    // font_color
    mOptions[ScalefilterOptions::FontColor].setName ("font_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[ScalefilterOptions::FontColor].value().set(color);

    // back_color
    mOptions[ScalefilterOptions::BackColor].setName ("back_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0000));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0x0000));
    color[3] = MAX (0, MIN (0xffff, 0x9999));
    mOptions[ScalefilterOptions::BackColor].value().set(color);

}

ScalefilterOptions::~ScalefilterOptions ()
{
}


CompOption::Vector &
ScalefilterOptions::getOptions ()
{
    return mOptions;
}

bool
ScalefilterOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case ScalefilterOptions::Timeout:
            if (o->set (value))
            {
                if (!mNotify[ScalefilterOptions::Timeout].empty ())
                    mNotify[ScalefilterOptions::Timeout] (o, ScalefilterOptions::Timeout);
                return true;
            }
            break;
        case ScalefilterOptions::FilterCaseInsensitive:
            if (o->set (value))
            {
                if (!mNotify[ScalefilterOptions::FilterCaseInsensitive].empty ())
                    mNotify[ScalefilterOptions::FilterCaseInsensitive] (o, ScalefilterOptions::FilterCaseInsensitive);
                return true;
            }
            break;
        case ScalefilterOptions::FilterDisplay:
            if (o->set (value))
            {
                if (!mNotify[ScalefilterOptions::FilterDisplay].empty ())
                    mNotify[ScalefilterOptions::FilterDisplay] (o, ScalefilterOptions::FilterDisplay);
                return true;
            }
            break;
        case ScalefilterOptions::FontBold:
            if (o->set (value))
            {
                if (!mNotify[ScalefilterOptions::FontBold].empty ())
                    mNotify[ScalefilterOptions::FontBold] (o, ScalefilterOptions::FontBold);
                return true;
            }
            break;
        case ScalefilterOptions::FontSize:
            if (o->set (value))
            {
                if (!mNotify[ScalefilterOptions::FontSize].empty ())
                    mNotify[ScalefilterOptions::FontSize] (o, ScalefilterOptions::FontSize);
                return true;
            }
            break;
        case ScalefilterOptions::BorderSize:
            if (o->set (value))
            {
                if (!mNotify[ScalefilterOptions::BorderSize].empty ())
                    mNotify[ScalefilterOptions::BorderSize] (o, ScalefilterOptions::BorderSize);
                return true;
            }
            break;
        case ScalefilterOptions::FontColor:
            if (o->set (value))
            {
                if (!mNotify[ScalefilterOptions::FontColor].empty ())
                    mNotify[ScalefilterOptions::FontColor] (o, ScalefilterOptions::FontColor);
                return true;
            }
            break;
        case ScalefilterOptions::BackColor:
            if (o->set (value))
            {
                if (!mNotify[ScalefilterOptions::BackColor].empty ())
                    mNotify[ScalefilterOptions::BackColor] (o, ScalefilterOptions::BackColor);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

