/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "opacify_options.h"

OpacifyOptions::OpacifyOptions (bool init /* = true */) :
    mOptions (OpacifyOptions::OptionNum),
    mNotify (OpacifyOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
OpacifyOptions::initOptions ()
{
    unsigned int state;
    CompAction action;

    // toggle_key
    mOptions[OpacifyOptions::ToggleKey].setName ("toggle_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>o");
    mOptions[OpacifyOptions::ToggleKey].value().set (action);
    if (screen) screen->addAction (&mOptions[OpacifyOptions::ToggleKey].value ().action ());

    // toggle_reset
    mOptions[OpacifyOptions::ToggleReset].setName ("toggle_reset", CompOption::TypeBool);
    mOptions[OpacifyOptions::ToggleReset].value().set(true);

    // timeout
    mOptions[OpacifyOptions::Timeout].setName ("timeout", CompOption::TypeInt);
    mOptions[OpacifyOptions::Timeout].rest ().set (0, 10000);
    mOptions[OpacifyOptions::Timeout].value().set((int) 700);

    // init_toggle
    mOptions[OpacifyOptions::InitToggle].setName ("init_toggle", CompOption::TypeBool);
    mOptions[OpacifyOptions::InitToggle].value().set(true);

    // only_if_block
    mOptions[OpacifyOptions::OnlyIfBlock].setName ("only_if_block", CompOption::TypeBool);
    mOptions[OpacifyOptions::OnlyIfBlock].value().set(false);

    // focus_instant
    mOptions[OpacifyOptions::FocusInstant].setName ("focus_instant", CompOption::TypeBool);
    mOptions[OpacifyOptions::FocusInstant].value().set(false);

    // no_delay_change
    mOptions[OpacifyOptions::NoDelayChange].setName ("no_delay_change", CompOption::TypeBool);
    mOptions[OpacifyOptions::NoDelayChange].value().set(false);

    // window_match
    mOptions[OpacifyOptions::WindowMatch].setName ("window_match", CompOption::TypeMatch);
    mOptions[OpacifyOptions::WindowMatch].value().set(CompMatch ("Normal | Dialog | ModalDialog | Utility | Toolbar | Fullscreen"));
    mOptions[OpacifyOptions::WindowMatch].value().match ().update ();

    // active_opacity
    mOptions[OpacifyOptions::ActiveOpacity].setName ("active_opacity", CompOption::TypeInt);
    mOptions[OpacifyOptions::ActiveOpacity].rest ().set (1, 100);
    mOptions[OpacifyOptions::ActiveOpacity].value().set((int) 100);

    // passive_opacity
    mOptions[OpacifyOptions::PassiveOpacity].setName ("passive_opacity", CompOption::TypeInt);
    mOptions[OpacifyOptions::PassiveOpacity].rest ().set (1, 100);
    mOptions[OpacifyOptions::PassiveOpacity].value().set((int) 10);

}

OpacifyOptions::~OpacifyOptions ()
{
}


CompOption::Vector &
OpacifyOptions::getOptions ()
{
    return mOptions;
}

bool
OpacifyOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case OpacifyOptions::ToggleKey:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::ToggleKey].empty ())
                    mNotify[OpacifyOptions::ToggleKey] (o, OpacifyOptions::ToggleKey);
                return true;
            }
            break;
        case OpacifyOptions::ToggleReset:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::ToggleReset].empty ())
                    mNotify[OpacifyOptions::ToggleReset] (o, OpacifyOptions::ToggleReset);
                return true;
            }
            break;
        case OpacifyOptions::Timeout:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::Timeout].empty ())
                    mNotify[OpacifyOptions::Timeout] (o, OpacifyOptions::Timeout);
                return true;
            }
            break;
        case OpacifyOptions::InitToggle:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::InitToggle].empty ())
                    mNotify[OpacifyOptions::InitToggle] (o, OpacifyOptions::InitToggle);
                return true;
            }
            break;
        case OpacifyOptions::OnlyIfBlock:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::OnlyIfBlock].empty ())
                    mNotify[OpacifyOptions::OnlyIfBlock] (o, OpacifyOptions::OnlyIfBlock);
                return true;
            }
            break;
        case OpacifyOptions::FocusInstant:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::FocusInstant].empty ())
                    mNotify[OpacifyOptions::FocusInstant] (o, OpacifyOptions::FocusInstant);
                return true;
            }
            break;
        case OpacifyOptions::NoDelayChange:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::NoDelayChange].empty ())
                    mNotify[OpacifyOptions::NoDelayChange] (o, OpacifyOptions::NoDelayChange);
                return true;
            }
            break;
        case OpacifyOptions::WindowMatch:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::WindowMatch].empty ())
                    mNotify[OpacifyOptions::WindowMatch] (o, OpacifyOptions::WindowMatch);
                return true;
            }
            break;
        case OpacifyOptions::ActiveOpacity:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::ActiveOpacity].empty ())
                    mNotify[OpacifyOptions::ActiveOpacity] (o, OpacifyOptions::ActiveOpacity);
                return true;
            }
            break;
        case OpacifyOptions::PassiveOpacity:
            if (o->set (value))
            {
                if (!mNotify[OpacifyOptions::PassiveOpacity].empty ())
                    mNotify[OpacifyOptions::PassiveOpacity] (o, OpacifyOptions::PassiveOpacity);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

