/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "cubeaddon_options.h"

CubeaddonOptions::CubeaddonOptions (bool init /* = true */) :
    mOptions (CubeaddonOptions::OptionNum),
    mNotify (CubeaddonOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
CubeaddonOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];
    CompOption::Value::Vector list;
    CompOption::Value value;

    // top_next_key
    mOptions[CubeaddonOptions::TopNextKey].setName ("top_next_key", CompOption::TypeKey);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("space");
    mOptions[CubeaddonOptions::TopNextKey].value().set (action);

    // top_next_button
    mOptions[CubeaddonOptions::TopNextButton].setName ("top_next_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[CubeaddonOptions::TopNextButton].value().set (action);

    // top_prev_key
    mOptions[CubeaddonOptions::TopPrevKey].setName ("top_prev_key", CompOption::TypeKey);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("Backspace");
    mOptions[CubeaddonOptions::TopPrevKey].value().set (action);

    // top_prev_button
    mOptions[CubeaddonOptions::TopPrevButton].setName ("top_prev_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[CubeaddonOptions::TopPrevButton].value().set (action);

    // bottom_next_key
    mOptions[CubeaddonOptions::BottomNextKey].setName ("bottom_next_key", CompOption::TypeKey);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CubeaddonOptions::BottomNextKey].value().set (action);

    // bottom_next_button
    mOptions[CubeaddonOptions::BottomNextButton].setName ("bottom_next_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[CubeaddonOptions::BottomNextButton].value().set (action);

    // bottom_prev_key
    mOptions[CubeaddonOptions::BottomPrevKey].setName ("bottom_prev_key", CompOption::TypeKey);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[CubeaddonOptions::BottomPrevKey].value().set (action);

    // bottom_prev_button
    mOptions[CubeaddonOptions::BottomPrevButton].setName ("bottom_prev_button", CompOption::TypeButton);
    state = 0;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[CubeaddonOptions::BottomPrevButton].value().set (action);

    // reflection
    mOptions[CubeaddonOptions::Reflection].setName ("reflection", CompOption::TypeBool);
    mOptions[CubeaddonOptions::Reflection].value().set(true);

    // ground_color1
    mOptions[CubeaddonOptions::GroundColor1].setName ("ground_color1", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xb333));
    color[1] = MAX (0, MIN (0xffff, 0xb333));
    color[2] = MAX (0, MIN (0xffff, 0xb333));
    color[3] = MAX (0, MIN (0xffff, 0xcccc));
    mOptions[CubeaddonOptions::GroundColor1].value().set(color);

    // ground_color2
    mOptions[CubeaddonOptions::GroundColor2].setName ("ground_color2", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xb333));
    color[1] = MAX (0, MIN (0xffff, 0xb333));
    color[2] = MAX (0, MIN (0xffff, 0xb333));
    color[3] = MAX (0, MIN (0xffff, 0x0000));
    mOptions[CubeaddonOptions::GroundColor2].value().set(color);

    // ground_size
    mOptions[CubeaddonOptions::GroundSize].setName ("ground_size", CompOption::TypeFloat);
    mOptions[CubeaddonOptions::GroundSize].rest ().set (0.0, 1.0, 0.01);
    mOptions[CubeaddonOptions::GroundSize].value().set((float) 0.5);

    // intensity
    mOptions[CubeaddonOptions::Intensity].setName ("intensity", CompOption::TypeFloat);
    mOptions[CubeaddonOptions::Intensity].rest ().set (0.0, 1.0, 0.01);
    mOptions[CubeaddonOptions::Intensity].value().set((float) 0.4);

    // auto_zoom
    mOptions[CubeaddonOptions::AutoZoom].setName ("auto_zoom", CompOption::TypeBool);
    mOptions[CubeaddonOptions::AutoZoom].value().set(true);

    // zoom_manual_only
    mOptions[CubeaddonOptions::ZoomManualOnly].setName ("zoom_manual_only", CompOption::TypeBool);
    mOptions[CubeaddonOptions::ZoomManualOnly].value().set(true);

    // mode
    mOptions[CubeaddonOptions::Mode].setName ("mode", CompOption::TypeInt);
    mOptions[CubeaddonOptions::Mode].rest ().set (0, 3);
    mOptions[CubeaddonOptions::Mode].value().set((int) 0);

    // deformation
    mOptions[CubeaddonOptions::Deformation].setName ("deformation", CompOption::TypeInt);
    mOptions[CubeaddonOptions::Deformation].rest ().set (0, 2);
    mOptions[CubeaddonOptions::Deformation].value().set((int) 1);

    // unfold_deformation
    mOptions[CubeaddonOptions::UnfoldDeformation].setName ("unfold_deformation", CompOption::TypeBool);
    mOptions[CubeaddonOptions::UnfoldDeformation].value().set(true);

    // cylinder_manual_only
    mOptions[CubeaddonOptions::CylinderManualOnly].setName ("cylinder_manual_only", CompOption::TypeBool);
    mOptions[CubeaddonOptions::CylinderManualOnly].value().set(false);

    // deform_caps
    mOptions[CubeaddonOptions::DeformCaps].setName ("deform_caps", CompOption::TypeBool);
    mOptions[CubeaddonOptions::DeformCaps].value().set(true);

    // sphere_aspect
    mOptions[CubeaddonOptions::SphereAspect].setName ("sphere_aspect", CompOption::TypeFloat);
    mOptions[CubeaddonOptions::SphereAspect].rest ().set (0.0, 1.0, 0.1);
    mOptions[CubeaddonOptions::SphereAspect].value().set((float) 0.0);

    // draw_top
    mOptions[CubeaddonOptions::DrawTop].setName ("draw_top", CompOption::TypeBool);
    mOptions[CubeaddonOptions::DrawTop].value().set(true);

    // draw_bottom
    mOptions[CubeaddonOptions::DrawBottom].setName ("draw_bottom", CompOption::TypeBool);
    mOptions[CubeaddonOptions::DrawBottom].value().set(true);

    // adjust_top
    mOptions[CubeaddonOptions::AdjustTop].setName ("adjust_top", CompOption::TypeBool);
    mOptions[CubeaddonOptions::AdjustTop].value().set(false);

    // adjust_bottom
    mOptions[CubeaddonOptions::AdjustBottom].setName ("adjust_bottom", CompOption::TypeBool);
    mOptions[CubeaddonOptions::AdjustBottom].value().set(false);

    // top_scale
    mOptions[CubeaddonOptions::TopScale].setName ("top_scale", CompOption::TypeBool);
    mOptions[CubeaddonOptions::TopScale].value().set(true);

    // bottom_scale
    mOptions[CubeaddonOptions::BottomScale].setName ("bottom_scale", CompOption::TypeBool);
    mOptions[CubeaddonOptions::BottomScale].value().set(true);

    // top_aspect
    mOptions[CubeaddonOptions::TopAspect].setName ("top_aspect", CompOption::TypeBool);
    mOptions[CubeaddonOptions::TopAspect].value().set(true);

    // bottom_aspect
    mOptions[CubeaddonOptions::BottomAspect].setName ("bottom_aspect", CompOption::TypeBool);
    mOptions[CubeaddonOptions::BottomAspect].value().set(true);

    // top_clamp
    mOptions[CubeaddonOptions::TopClamp].setName ("top_clamp", CompOption::TypeBool);
    mOptions[CubeaddonOptions::TopClamp].value().set(true);

    // bottom_clamp
    mOptions[CubeaddonOptions::BottomClamp].setName ("bottom_clamp", CompOption::TypeBool);
    mOptions[CubeaddonOptions::BottomClamp].value().set(true);

    // top_images
    mOptions[CubeaddonOptions::TopImages].setName ("top_images", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("fusioncap.png"));
    list.push_back (value);
    mOptions[CubeaddonOptions::TopImages].value().set (CompOption::TypeString, list);

    // bottom_images
    mOptions[CubeaddonOptions::BottomImages].setName ("bottom_images", CompOption::TypeList);
    list.clear ();
    value.set(CompString ("compizcap.png"));
    list.push_back (value);
    mOptions[CubeaddonOptions::BottomImages].value().set (CompOption::TypeString, list);

}

CubeaddonOptions::~CubeaddonOptions ()
{
}


CompOption::Vector &
CubeaddonOptions::getOptions ()
{
    return mOptions;
}

bool
CubeaddonOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case CubeaddonOptions::TopNextKey:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::TopNextKey].empty ())
                    mNotify[CubeaddonOptions::TopNextKey] (o, CubeaddonOptions::TopNextKey);
                return true;
            }
            break;
        case CubeaddonOptions::TopNextButton:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::TopNextButton].empty ())
                    mNotify[CubeaddonOptions::TopNextButton] (o, CubeaddonOptions::TopNextButton);
                return true;
            }
            break;
        case CubeaddonOptions::TopPrevKey:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::TopPrevKey].empty ())
                    mNotify[CubeaddonOptions::TopPrevKey] (o, CubeaddonOptions::TopPrevKey);
                return true;
            }
            break;
        case CubeaddonOptions::TopPrevButton:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::TopPrevButton].empty ())
                    mNotify[CubeaddonOptions::TopPrevButton] (o, CubeaddonOptions::TopPrevButton);
                return true;
            }
            break;
        case CubeaddonOptions::BottomNextKey:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::BottomNextKey].empty ())
                    mNotify[CubeaddonOptions::BottomNextKey] (o, CubeaddonOptions::BottomNextKey);
                return true;
            }
            break;
        case CubeaddonOptions::BottomNextButton:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::BottomNextButton].empty ())
                    mNotify[CubeaddonOptions::BottomNextButton] (o, CubeaddonOptions::BottomNextButton);
                return true;
            }
            break;
        case CubeaddonOptions::BottomPrevKey:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::BottomPrevKey].empty ())
                    mNotify[CubeaddonOptions::BottomPrevKey] (o, CubeaddonOptions::BottomPrevKey);
                return true;
            }
            break;
        case CubeaddonOptions::BottomPrevButton:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::BottomPrevButton].empty ())
                    mNotify[CubeaddonOptions::BottomPrevButton] (o, CubeaddonOptions::BottomPrevButton);
                return true;
            }
            break;
        case CubeaddonOptions::Reflection:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::Reflection].empty ())
                    mNotify[CubeaddonOptions::Reflection] (o, CubeaddonOptions::Reflection);
                return true;
            }
            break;
        case CubeaddonOptions::GroundColor1:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::GroundColor1].empty ())
                    mNotify[CubeaddonOptions::GroundColor1] (o, CubeaddonOptions::GroundColor1);
                return true;
            }
            break;
        case CubeaddonOptions::GroundColor2:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::GroundColor2].empty ())
                    mNotify[CubeaddonOptions::GroundColor2] (o, CubeaddonOptions::GroundColor2);
                return true;
            }
            break;
        case CubeaddonOptions::GroundSize:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::GroundSize].empty ())
                    mNotify[CubeaddonOptions::GroundSize] (o, CubeaddonOptions::GroundSize);
                return true;
            }
            break;
        case CubeaddonOptions::Intensity:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::Intensity].empty ())
                    mNotify[CubeaddonOptions::Intensity] (o, CubeaddonOptions::Intensity);
                return true;
            }
            break;
        case CubeaddonOptions::AutoZoom:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::AutoZoom].empty ())
                    mNotify[CubeaddonOptions::AutoZoom] (o, CubeaddonOptions::AutoZoom);
                return true;
            }
            break;
        case CubeaddonOptions::ZoomManualOnly:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::ZoomManualOnly].empty ())
                    mNotify[CubeaddonOptions::ZoomManualOnly] (o, CubeaddonOptions::ZoomManualOnly);
                return true;
            }
            break;
        case CubeaddonOptions::Mode:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::Mode].empty ())
                    mNotify[CubeaddonOptions::Mode] (o, CubeaddonOptions::Mode);
                return true;
            }
            break;
        case CubeaddonOptions::Deformation:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::Deformation].empty ())
                    mNotify[CubeaddonOptions::Deformation] (o, CubeaddonOptions::Deformation);
                return true;
            }
            break;
        case CubeaddonOptions::UnfoldDeformation:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::UnfoldDeformation].empty ())
                    mNotify[CubeaddonOptions::UnfoldDeformation] (o, CubeaddonOptions::UnfoldDeformation);
                return true;
            }
            break;
        case CubeaddonOptions::CylinderManualOnly:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::CylinderManualOnly].empty ())
                    mNotify[CubeaddonOptions::CylinderManualOnly] (o, CubeaddonOptions::CylinderManualOnly);
                return true;
            }
            break;
        case CubeaddonOptions::DeformCaps:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::DeformCaps].empty ())
                    mNotify[CubeaddonOptions::DeformCaps] (o, CubeaddonOptions::DeformCaps);
                return true;
            }
            break;
        case CubeaddonOptions::SphereAspect:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::SphereAspect].empty ())
                    mNotify[CubeaddonOptions::SphereAspect] (o, CubeaddonOptions::SphereAspect);
                return true;
            }
            break;
        case CubeaddonOptions::DrawTop:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::DrawTop].empty ())
                    mNotify[CubeaddonOptions::DrawTop] (o, CubeaddonOptions::DrawTop);
                return true;
            }
            break;
        case CubeaddonOptions::DrawBottom:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::DrawBottom].empty ())
                    mNotify[CubeaddonOptions::DrawBottom] (o, CubeaddonOptions::DrawBottom);
                return true;
            }
            break;
        case CubeaddonOptions::AdjustTop:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::AdjustTop].empty ())
                    mNotify[CubeaddonOptions::AdjustTop] (o, CubeaddonOptions::AdjustTop);
                return true;
            }
            break;
        case CubeaddonOptions::AdjustBottom:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::AdjustBottom].empty ())
                    mNotify[CubeaddonOptions::AdjustBottom] (o, CubeaddonOptions::AdjustBottom);
                return true;
            }
            break;
        case CubeaddonOptions::TopScale:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::TopScale].empty ())
                    mNotify[CubeaddonOptions::TopScale] (o, CubeaddonOptions::TopScale);
                return true;
            }
            break;
        case CubeaddonOptions::BottomScale:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::BottomScale].empty ())
                    mNotify[CubeaddonOptions::BottomScale] (o, CubeaddonOptions::BottomScale);
                return true;
            }
            break;
        case CubeaddonOptions::TopAspect:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::TopAspect].empty ())
                    mNotify[CubeaddonOptions::TopAspect] (o, CubeaddonOptions::TopAspect);
                return true;
            }
            break;
        case CubeaddonOptions::BottomAspect:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::BottomAspect].empty ())
                    mNotify[CubeaddonOptions::BottomAspect] (o, CubeaddonOptions::BottomAspect);
                return true;
            }
            break;
        case CubeaddonOptions::TopClamp:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::TopClamp].empty ())
                    mNotify[CubeaddonOptions::TopClamp] (o, CubeaddonOptions::TopClamp);
                return true;
            }
            break;
        case CubeaddonOptions::BottomClamp:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::BottomClamp].empty ())
                    mNotify[CubeaddonOptions::BottomClamp] (o, CubeaddonOptions::BottomClamp);
                return true;
            }
            break;
        case CubeaddonOptions::TopImages:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::TopImages].empty ())
                    mNotify[CubeaddonOptions::TopImages] (o, CubeaddonOptions::TopImages);
                return true;
            }
            break;
        case CubeaddonOptions::BottomImages:
            if (o->set (value))
            {
                if (!mNotify[CubeaddonOptions::BottomImages].empty ())
                    mNotify[CubeaddonOptions::BottomImages] (o, CubeaddonOptions::BottomImages);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

