/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "animationplus_options.h"

AnimationplusOptions::AnimationplusOptions (bool init /* = true */) :
    mOptions (AnimationplusOptions::OptionNum),
    mNotify (AnimationplusOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
AnimationplusOptions::initOptions ()
{
    unsigned short color[4];

    // helix_num_twists
    mOptions[AnimationplusOptions::HelixNumTwists].setName ("helix_num_twists", CompOption::TypeInt);
    mOptions[AnimationplusOptions::HelixNumTwists].rest ().set (1, 10);
    mOptions[AnimationplusOptions::HelixNumTwists].value().set((int) 2);

    // helix_gridy
    mOptions[AnimationplusOptions::HelixGridy].setName ("helix_gridy", CompOption::TypeInt);
    mOptions[AnimationplusOptions::HelixGridy].rest ().set (5, 300);
    mOptions[AnimationplusOptions::HelixGridy].value().set((int) 90);

    // helix_thickness
    mOptions[AnimationplusOptions::HelixThickness].setName ("helix_thickness", CompOption::TypeFloat);
    mOptions[AnimationplusOptions::HelixThickness].rest ().set (0, 50, 0.1f);
    mOptions[AnimationplusOptions::HelixThickness].value().set((float) 0);

    // helix_spin_direction
    mOptions[AnimationplusOptions::HelixSpinDirection].setName ("helix_spin_direction", CompOption::TypeInt);
    mOptions[AnimationplusOptions::HelixSpinDirection].rest ().set (0, 1);
    mOptions[AnimationplusOptions::HelixSpinDirection].value().set((int) 1);

    // helix_direction
    mOptions[AnimationplusOptions::HelixDirection].setName ("helix_direction", CompOption::TypeBool);
    mOptions[AnimationplusOptions::HelixDirection].value().set(false);

    // blinds_num_halftwists
    mOptions[AnimationplusOptions::BlindsNumHalftwists].setName ("blinds_num_halftwists", CompOption::TypeInt);
    mOptions[AnimationplusOptions::BlindsNumHalftwists].rest ().set (1, 10);
    mOptions[AnimationplusOptions::BlindsNumHalftwists].value().set((int) 2);

    // blinds_gridx
    mOptions[AnimationplusOptions::BlindsGridx].setName ("blinds_gridx", CompOption::TypeInt);
    mOptions[AnimationplusOptions::BlindsGridx].rest ().set (1, 100);
    mOptions[AnimationplusOptions::BlindsGridx].value().set((int) 20);

    // blinds_thickness
    mOptions[AnimationplusOptions::BlindsThickness].setName ("blinds_thickness", CompOption::TypeFloat);
    mOptions[AnimationplusOptions::BlindsThickness].rest ().set (0, 50, 0.1f);
    mOptions[AnimationplusOptions::BlindsThickness].value().set((float) 0);

    // shatter_num_spokes
    mOptions[AnimationplusOptions::ShatterNumSpokes].setName ("shatter_num_spokes", CompOption::TypeInt);
    mOptions[AnimationplusOptions::ShatterNumSpokes].rest ().set (1, 100);
    mOptions[AnimationplusOptions::ShatterNumSpokes].value().set((int) 2);

    // shatter_num_tiers
    mOptions[AnimationplusOptions::ShatterNumTiers].setName ("shatter_num_tiers", CompOption::TypeInt);
    mOptions[AnimationplusOptions::ShatterNumTiers].rest ().set (1, 100);
    mOptions[AnimationplusOptions::ShatterNumTiers].value().set((int) 2);

    // bonanza_particles
    mOptions[AnimationplusOptions::BonanzaParticles].setName ("bonanza_particles", CompOption::TypeInt);
    mOptions[AnimationplusOptions::BonanzaParticles].rest ().set (100, 10000);
    mOptions[AnimationplusOptions::BonanzaParticles].value().set((int) 1000);

    // bonanza_size
    mOptions[AnimationplusOptions::BonanzaSize].setName ("bonanza_size", CompOption::TypeFloat);
    mOptions[AnimationplusOptions::BonanzaSize].rest ().set (0.1, 20, 0.1);
    mOptions[AnimationplusOptions::BonanzaSize].value().set((float) 5);

    // bonanza_life
    mOptions[AnimationplusOptions::BonanzaLife].setName ("bonanza_life", CompOption::TypeFloat);
    mOptions[AnimationplusOptions::BonanzaLife].rest ().set (0.1, 1, 0.1);
    mOptions[AnimationplusOptions::BonanzaLife].value().set((float) 0.7);

    // bonanza_color
    mOptions[AnimationplusOptions::BonanzaColor].setName ("bonanza_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0x3333));
    color[2] = MAX (0, MIN (0xffff, 0x0555));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[AnimationplusOptions::BonanzaColor].value().set(color);

    // bonanza_mystical
    mOptions[AnimationplusOptions::BonanzaMystical].setName ("bonanza_mystical", CompOption::TypeBool);
    mOptions[AnimationplusOptions::BonanzaMystical].value().set(false);

}

AnimationplusOptions::~AnimationplusOptions ()
{
}


CompOption::Vector &
AnimationplusOptions::getOptions ()
{
    return mOptions;
}

bool
AnimationplusOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case AnimationplusOptions::HelixNumTwists:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::HelixNumTwists].empty ())
                    mNotify[AnimationplusOptions::HelixNumTwists] (o, AnimationplusOptions::HelixNumTwists);
                return true;
            }
            break;
        case AnimationplusOptions::HelixGridy:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::HelixGridy].empty ())
                    mNotify[AnimationplusOptions::HelixGridy] (o, AnimationplusOptions::HelixGridy);
                return true;
            }
            break;
        case AnimationplusOptions::HelixThickness:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::HelixThickness].empty ())
                    mNotify[AnimationplusOptions::HelixThickness] (o, AnimationplusOptions::HelixThickness);
                return true;
            }
            break;
        case AnimationplusOptions::HelixSpinDirection:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::HelixSpinDirection].empty ())
                    mNotify[AnimationplusOptions::HelixSpinDirection] (o, AnimationplusOptions::HelixSpinDirection);
                return true;
            }
            break;
        case AnimationplusOptions::HelixDirection:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::HelixDirection].empty ())
                    mNotify[AnimationplusOptions::HelixDirection] (o, AnimationplusOptions::HelixDirection);
                return true;
            }
            break;
        case AnimationplusOptions::BlindsNumHalftwists:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::BlindsNumHalftwists].empty ())
                    mNotify[AnimationplusOptions::BlindsNumHalftwists] (o, AnimationplusOptions::BlindsNumHalftwists);
                return true;
            }
            break;
        case AnimationplusOptions::BlindsGridx:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::BlindsGridx].empty ())
                    mNotify[AnimationplusOptions::BlindsGridx] (o, AnimationplusOptions::BlindsGridx);
                return true;
            }
            break;
        case AnimationplusOptions::BlindsThickness:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::BlindsThickness].empty ())
                    mNotify[AnimationplusOptions::BlindsThickness] (o, AnimationplusOptions::BlindsThickness);
                return true;
            }
            break;
        case AnimationplusOptions::ShatterNumSpokes:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::ShatterNumSpokes].empty ())
                    mNotify[AnimationplusOptions::ShatterNumSpokes] (o, AnimationplusOptions::ShatterNumSpokes);
                return true;
            }
            break;
        case AnimationplusOptions::ShatterNumTiers:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::ShatterNumTiers].empty ())
                    mNotify[AnimationplusOptions::ShatterNumTiers] (o, AnimationplusOptions::ShatterNumTiers);
                return true;
            }
            break;
        case AnimationplusOptions::BonanzaParticles:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::BonanzaParticles].empty ())
                    mNotify[AnimationplusOptions::BonanzaParticles] (o, AnimationplusOptions::BonanzaParticles);
                return true;
            }
            break;
        case AnimationplusOptions::BonanzaSize:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::BonanzaSize].empty ())
                    mNotify[AnimationplusOptions::BonanzaSize] (o, AnimationplusOptions::BonanzaSize);
                return true;
            }
            break;
        case AnimationplusOptions::BonanzaLife:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::BonanzaLife].empty ())
                    mNotify[AnimationplusOptions::BonanzaLife] (o, AnimationplusOptions::BonanzaLife);
                return true;
            }
            break;
        case AnimationplusOptions::BonanzaColor:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::BonanzaColor].empty ())
                    mNotify[AnimationplusOptions::BonanzaColor] (o, AnimationplusOptions::BonanzaColor);
                return true;
            }
            break;
        case AnimationplusOptions::BonanzaMystical:
            if (o->set (value))
            {
                if (!mNotify[AnimationplusOptions::BonanzaMystical].empty ())
                    mNotify[AnimationplusOptions::BonanzaMystical] (o, AnimationplusOptions::BonanzaMystical);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

