#include <stdlib.h>
#include <string.h>
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define YYLEX yylex()
#define YYEMPTY -1
#define yyclearin (yychar=(YYEMPTY))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING() (yyerrflag!=0)
#define YYPREFIX "yy"
#line 2 "parse.y"

/*
 * Copyright (c) 2021-2024 Omar Polo <op@omarpolo.com>
 * Copyright (c) 2018 Florian Obser <florian@openbsd.org>
 * Copyright (c) 2004, 2005 Esben Norby <norby@openbsd.org>
 * Copyright (c) 2004 Ryan McBride <mcbride@openbsd.org>
 * Copyright (c) 2002, 2003, 2004 Henning Brauer <henning@openbsd.org>
 * Copyright (c) 2001 Markus Friedl.  All rights reserved.
 * Copyright (c) 2001 Daniel Hartmeier.  All rights reserved.
 * Copyright (c) 2001 Theo de Raadt.  All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#include "gmid.h"

#include <ctype.h>
#include <errno.h>
#include <netdb.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>

#include "log.h"

struct conf *conf;

static const char	*default_host = NULL;
static uint16_t		 default_port = 1965;

TAILQ_HEAD(files, file)		 files = TAILQ_HEAD_INITIALIZER(files);
static struct file {
	TAILQ_ENTRY(file)	 entry;
	FILE			*stream;
	char			*name;
	size_t			 ungetpos;
	size_t			 ungetsize;
	u_char			*ungetbuf;
	int			 eof_reached;
	int			 lineno;
	int			 errors;
} *file, *topfile;

struct file	*pushfile(const char *, int);
int		 popfile(void);
int		 yyparse(void);
int		 yylex(void);
void		 yyerror(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
void		 yywarn(const char *, ...)
    __attribute__((__format__ (printf, 1, 2)))
    __attribute__((__nonnull__ (1)));
int		 kw_cmp(const void *, const void *);
int		 lookup(char *);
int		 igetc(void);
int		 lgetc(int);
void		 lungetc(int);
int		 findeol(void);

/*
 * #define YYDEBUG 1
 * int yydebug = 1;
 */

TAILQ_HEAD(symhead, sym) symhead = TAILQ_HEAD_INITIALIZER(symhead);
struct sym {
	TAILQ_ENTRY(sym)	 entry;
	int			 used;
	int			 persist;
	char			*name;
	char			*val;
};

int	 symset(const char *, const char *, int);
char	*symget(const char *);

char		*ensure_absolute_path(char*);
int		 check_block_code(int);
char		*check_block_fmt(char*);
int		 check_strip_no(int);
int		 check_prefork_num(int);
void		 advance_loc(void);
void		 advance_proxy(void);
int		 fastcgi_conf(const char *, const char *);
void		 add_param(char *, char *);
int		 getservice(const char *);
void		 listen_on(const char *, const char *);

static struct vhost		*host;
static struct location		*loc;
static struct proxy		*proxy;
static char			*current_media;
static int			 errors;

typedef struct {
	union {
		char	*string;
		int	 number;
	} v;
	int lineno;
} YYSTYPE;

#define YYSTYPE YYSTYPE

#line 131 "y.tab.c"
#define ACCESS 257
#define ALIAS 258
#define AUTO 259
#define BLOCK 260
#define CA 261
#define CERT 262
#define CGI 263
#define CHROOT 264
#define CLIENT 265
#define DEFAULT 266
#define FACILITY 267
#define FASTCGI 268
#define FOR_HOST 269
#define INCLUDE 270
#define INDEX 271
#define IPV6 272
#define KEY 273
#define LANG 274
#define LISTEN 275
#define LOCATION 276
#define LOG 277
#define OCSP 278
#define OFF 279
#define ON 280
#define PARAM 281
#define PORT 282
#define PREFORK 283
#define PROTO 284
#define PROTOCOLS 285
#define PROXY 286
#define RELAY_TO 287
#define REQUIRE 288
#define RETURN 289
#define ROOT 290
#define SERVER 291
#define SNI 292
#define SOCKET 293
#define STRIP 294
#define STYLE 295
#define SYSLOG 296
#define TCP 297
#define TOEXT 298
#define TYPE 299
#define TYPES 300
#define USE_TLS 301
#define USER 302
#define VERIFYNAME 303
#define ERROR 304
#define STRING 305
#define NUM 306
#define YYERRCODE 256
const short yylhs[] =
	{                                        -1,
    0,    0,    7,    7,    7,    7,    7,    7,    7,    8,
    1,    1,    3,    3,    4,    4,    9,   10,   10,   10,
   10,   10,   10,   10,   13,   13,   15,   15,   16,   16,
   16,   16,   16,   17,   11,   11,   18,   18,   18,   18,
    5,    5,   19,   19,   19,   19,   19,   19,   19,   19,
   19,   19,   24,   21,   23,   23,    2,    2,    2,   26,
   26,   25,   25,   27,   27,   27,   27,   27,   27,   27,
   27,   28,   20,   20,   29,   29,   22,   22,   22,   22,
   22,   22,   22,   22,   22,   22,   22,   22,   30,   30,
   30,   30,   31,   31,   32,   32,   32,   32,   32,   32,
   12,   33,   33,   36,   34,   34,   35,   35,   37,    6,
    6,   14,   14,
};
const short yylen[] =
	{                                         2,
    2,    1,    0,    3,    3,    3,    3,    3,    3,    2,
    1,    1,    2,    1,    1,    1,    3,    2,    2,    1,
    2,    2,    2,    2,    5,    2,    0,    3,    2,    2,
    3,    2,    1,    0,    7,    2,    0,    3,    3,    3,
    1,    1,    2,    2,    2,    2,    2,    4,    3,    5,
    5,    1,    0,    7,    0,    2,    0,    2,    2,    2,
    3,    0,    3,    2,    2,    2,    3,    4,    2,    2,
    2,    0,    7,    2,    0,    3,    3,    4,    3,    1,
    3,    1,    2,    2,    2,    4,    2,    2,    5,    2,
    2,    2,    0,    3,    4,    2,    5,    3,    5,    2,
    5,    3,    2,    0,    3,    1,    2,    1,    1,    2,
    2,    1,    0,
};
const short yydefred[] =
	{                                      0,
    0,    0,    0,    3,    0,  112,  110,  111,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   20,   36,    9,   14,
    0,   10,   12,   11,   19,    0,    0,    0,    0,   26,
   21,   22,    0,    0,    0,    0,    0,    4,    5,    6,
    7,    8,   13,    0,    0,    0,   32,   27,    0,    0,
    0,    0,    0,    0,  104,  106,    0,    0,   25,    0,
   37,    0,  101,    0,  103,   28,    0,   16,   15,  109,
    0,  108,  102,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,   72,    0,    0,    0,   53,
    0,    0,    0,   35,    0,    0,    0,   52,   82,  107,
   74,    0,    0,    0,    0,    0,    0,   91,    0,    0,
    0,    0,    0,   90,    0,    0,    0,    0,    0,   85,
    0,    0,   55,    0,    0,   88,   38,   39,   40,   77,
    0,    0,    0,    0,    0,  100,   93,   42,   41,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,   56,    0,    0,    0,   89,    0,
   50,   51,   75,    0,    0,   62,   97,    0,   94,    0,
    0,   61,    0,   73,    0,   58,   59,    0,    0,    0,
    0,    0,    0,    0,    0,   54,    0,   76,    0,    0,
    0,    0,    0,    0,   70,   71,   63,   67,    0,    0,
};
const short yydgoto[] =
	{                                       3,
   35,  182,   31,   80,  150,    6,    5,   22,   23,   24,
   25,   26,   27,    7,   63,   40,   59,   77,  105,  106,
  107,  108,  153,  133,  183,  165,  197,  129,  180,  109,
  158,  124,   67,   68,   81,   72,   82,
};
const short yysindex[] =
	{                                     -3,
   -3,   -3,    0,    0, 1164,    0,    0,    0, 1164,    6,
 -275, -269, -238,  -99, -267, -262, -275, -275,  -75, -275,
   -9,   -3,   -3,   -3,   -3,   -3,    0,    0,    0,    0,
 -236,    0,    0,    0,    0, -275, -275, -242,   -3,    0,
    0,    0, -236, -236,   -3, -236, -275,    0,    0,    0,
    0,    0,    0, -236, -236, -275,    0,    0,  -60, -260,
 -236, -236, -114,   -3,    0,    0, -116,   -3,    0,   -3,
    0, -259,    0,   -3,    0,    0, 1074,    0,    0,    0,
 -259,    0,    0,  -52, -275, -190, -206, -275, -275, -215,
 -118, -275, -275, -275, -195,    0, -238, -275, -275,    0,
 -179, -275, -213,    0,   -3,   -3,   -3,    0,    0,    0,
    0, -236, -238, -212, -236, -236, -275,    0, -275, -271,
 -210,   -3, -236,    0, -236, -236, -236,  -39, -275,    0,
 -236,  -61,    0, -164, -236,    0,    0,    0,    0,    0,
 -275, -236,  -59, -275, -236,    0,    0,    0,    0, -184,
 -119, -275, -117, -275, -236, -275, -274,  -90, -246,   -3,
 -236, -275, -275,   -3,    0, -236, -236, -244,    0,   -3,
    0,    0,    0, -265, -236,    0,    0, -236,    0,  879,
 -227,    0,  -74,    0,   -3,    0,    0, -275, -275, -275,
 -275, -166, -275, -238, -238,    0,   -3,    0, -236, -236,
 -236, -265, -161, -236,    0,    0,    0,    0, -275, -236,};
const short yyrindex[] =
	{                                     43,
    1,    1,    0,    0,  102,    0,    0,    0,  103,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    8,    0,    0,    0,    0,    0,    0,   13, -111,    0,
    0,    0,    9,  -19, -255,   11,    0,    0,    0,    0,
    0,    0,    0,   23,   28,    0,    0,    0,    0,    0,
   12,   65,    0, 1228,    0,    0,    0,    0,    0, -111,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
   18,    0,    0,    0,    0,    0,  371,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0, 1228, 1228, 1228,    0,    0,    0,
    0,  410,    0,    0,  452,  503,    0,    0,    0,    0,
    0,  -72,  564,    0,  597,  643,  680,    0,    0,    0,
  724,    0,    0,    0,  757,    0,    0,    0,    0,    0,
  802,  854,    0,    0,  173,    0,    0,    0,    0,  912,
    0,    0,    0,    0,  949,    0,  231,    0,    0, 1125,
  993,    0,    0,  -68,    0, 1026,  271,    0,    0,  -72,
    0,    0,    0,  -91,  -69,    0,    0,  328,    0,    0,
    0,    0,    0,    0, 1125,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  -68,    0,   48,   54,
   85,   91,    0,  112,    0,    0,    0,    0,    0,  118,};
const short yygindex[] =
	{                                      0,
  -84,  -97, 1288,    0,    0,   66,  104,  -40,    0,    0,
    0,    0,    0,   10,    0,   46,    0,    0,    0,    0,
    0,  -66,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -46,    0,   39,    0,    0,   37,
};
#define YYTABLESIZE 1522
const short yytable[] =
	{                                     152,
  113,  156,  149,  160,  122,  164,    1,  168,   73,   12,
   69,    8,  130,  113,  113,    1,  181,   18,   23,   66,
   24,   17,   33,   39,   56,  144,   66,  105,  140,   30,
   53,   57,   29,   30,  169,   32,   57,   30,   41,   53,
   33,   34,    3,   42,   65,   78,   79,   45,   58,  113,
  196,   47,  113,   60,   60,    2,  113,   64,  171,  172,
   30,  177,   64,   65,    2,    4,   18,   23,   53,   24,
   17,   33,  111,   71,   31,   29,  105,  186,  187,   76,
  113,   29,  114,  117,  128,  134,   30,   48,   49,   50,
   51,   52,  136,  141,   66,  146,  154,  159,  203,  209,
   57,    2,    1,   34,  208,   74,   64,    9,   70,  205,
  206,  170,   65,  185,  137,  138,  139,  110,    0,    0,
    0,   69,    0,   31,    0,  113,    0,   68,    0,    0,
   28,  147,    0,   75,    0,    0,    0,   33,    0,   83,
    0,    0,   36,   66,    0,  113,    0,   29,    0,   57,
    0,  162,   30,   12,    0,    0,    0,   36,    0,    0,
  118,    0,  119,    0,    0,    0,  163,    0,    0,  173,
   69,    0,   64,  176,  120,  121,   68,   57,   65,  179,
   37,   38,   96,  113,  113,   53,   30,  188,   65,   31,
  119,    0,   57,  113,  198,   37,   38,    0,  189,   60,
    0,    0,  120,  121,  113,    0,  207,    0,  113,   66,
  190,    0,  191,  192,   60,   57,  113,  193,  113,  113,
  113,  113,    0,  113,    0,    0,  194,    0,  195,    0,
    0,   96,  113,    0,  113,    0,   69,    0,    0,    0,
   98,    0,   68,   53,    0,   53,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  113,  113,  113,  113,
  113,    0,  113,  113,  113,  148,  113,    0,  113,   33,
  113,  113,  113,  113,  113,  113,  113,  113,  113,   29,
   95,  113,  113,  113,   30,  113,  113,  113,  113,   98,
  113,  113,  113,  113,  113,  113,  113,   96,    3,    0,
  113,  113,  113,  113,    0,  113,    3,   33,   33,   64,
    0,    0,    3,    0,    3,   65,    0,   29,   29,    3,
   64,   31,   30,   30,    3,    3,   65,    3,    0,   95,
    0,    0,   64,    3,   64,   64,    0,   99,   65,   64,
   65,   65,    3,    0,    3,   65,   66,    3,   64,    0,
   64,    0,   57,    0,   65,   98,   65,   66,    0,   31,
   31,    0,    0,   57,    0,    0,    0,    0,    0,   66,
    0,   66,   66,   69,    0,   57,   66,   57,   57,   68,
   80,    0,   57,    0,   69,   66,   99,   66,    0,    0,
   68,   57,    0,   57,    0,   95,   69,    0,   69,   69,
    0,    0,   68,   69,   68,   68,    0,    0,    0,   68,
    0,    0,   69,    0,   69,    0,    0,    0,   68,   43,
   68,    0,    0,    0,    0,    0,    0,    0,   96,   80,
   96,   96,   96,    0,   96,   96,    0,    0,   96,    0,
   96,    0,    0,   96,    0,   96,   96,   96,   96,   96,
   96,    0,   99,   96,    0,    0,    0,    0,   96,    0,
   96,   44,   96,    0,    0,   96,   96,    0,   43,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   98,    0,   98,   98,
   98,    0,   98,   98,    0,   80,   98,    0,   98,    0,
    0,   98,    0,   98,   98,   98,   98,   98,   98,    0,
   44,   98,   45,    0,    0,    0,   98,    0,   98,    0,
   98,    0,    0,   98,   98,    0,   95,    0,   95,   95,
   95,    0,   95,   95,   43,    0,   95,    0,   95,    0,
    0,   95,    0,   95,   95,   95,   95,   95,   95,    0,
    0,   95,    0,    0,    0,    0,   95,    0,   95,    0,
   95,   45,    0,   95,   95,    0,    0,    0,    0,    0,
    0,    0,    0,   92,    0,    0,   44,    0,    0,    0,
    0,    0,    0,   99,    0,   99,   99,   99,    0,   99,
   99,    0,    0,   99,    0,   99,    0,    0,   99,    0,
   99,   99,   99,   99,   99,   99,   83,    0,   99,    0,
    0,    0,    0,   99,    0,   99,    0,   99,    0,    0,
   99,   99,   92,    0,    0,    0,   80,   45,   80,   80,
   80,    0,   80,   80,    0,    0,   80,    0,   80,    0,
    0,   80,    0,   80,   80,   80,   80,   80,   80,    0,
    0,   80,   46,    0,    0,   83,   80,    0,   80,    0,
   80,    0,    0,    0,   80,   43,    0,   43,   43,   43,
    0,   43,   43,    0,    0,   43,    0,   43,    0,    0,
   43,    0,   43,   43,   43,   43,   43,   43,   92,   84,
   43,    0,    0,    0,    0,   43,    0,   43,    0,   43,
    0,   46,    0,   43,    0,    0,    0,   44,    0,   44,
   44,   44,    0,   44,   44,    0,    0,   44,    0,   44,
    0,   83,   44,    0,   44,   44,   44,   44,   44,   44,
    0,    0,   44,   47,    0,    0,    0,   44,   84,   44,
    0,   44,    0,    0,    0,   44,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,   45,    0,
   45,   45,   45,    0,   45,   45,   87,   46,   45,    0,
   45,    0,    0,   45,    0,   45,   45,   45,   45,   45,
   45,    0,   47,   45,    0,    0,    0,    0,   45,    0,
   45,    0,   45,    0,    0,    0,   45,    0,    0,    0,
    0,    0,    0,    0,   84,    0,    0,    0,    0,    0,
    0,   79,    0,    0,    0,   87,    0,    0,    0,   92,
    0,   92,   92,   92,    0,   92,   92,    0,    0,   92,
    0,   92,    0,    0,   92,    0,   92,   92,   92,   92,
   92,   92,    0,    0,   92,    0,    0,    0,   47,   92,
    0,   92,   83,   92,   83,   83,   83,   92,   83,   83,
   79,    0,   83,   81,   83,    0,    0,   83,    0,   83,
   83,   83,   83,   83,   83,    0,    0,   83,    0,    0,
    0,   87,   83,    0,   83,    0,   83,    0,    0,    0,
   83,    0,    0,    0,    0,    0,    0,    0,   46,    0,
   46,   46,   46,    0,   46,   46,    0,    0,   46,    0,
   46,    0,   81,   46,    0,   46,   46,   46,   46,   46,
   46,   49,    0,   46,    0,    0,   79,    0,   46,    0,
   46,    0,   46,    0,    0,   84,   46,   84,   84,   84,
    0,   84,   84,    0,    0,   84,    0,   84,    0,    0,
   84,    0,   84,   84,   84,   84,   84,   84,   78,    0,
   84,    0,    0,    0,    0,   84,    0,   84,    0,   84,
   49,    0,    0,   84,    0,    0,    0,    0,   81,   47,
    0,   47,   47,   47,    0,   47,   47,    0,    0,   47,
    0,   47,    0,    0,   47,    0,   47,   47,   47,   47,
   47,   47,   48,  184,   47,    0,    0,   78,    0,   47,
    0,   47,   87,   47,   87,   87,   87,   47,   87,   87,
    0,    0,   87,    0,   87,    0,    0,   87,    0,   87,
   87,   87,   87,   87,   87,   86,   49,   87,    0,    0,
    0,    0,   87,    0,   87,    0,   87,    0,    0,    0,
   87,   48,    0,    0,    0,    0,    0,   79,    0,   79,
   79,   79,    0,   79,   79,    0,    0,   79,    0,   79,
    0,    0,   79,   78,   79,   79,   79,   79,   79,   79,
    0,    0,   79,    0,   86,    0,    0,   79,    0,   79,
    0,   79,    0,    0,    0,   79,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,   81,
    0,   81,   81,   81,    0,   81,   81,   48,    0,   81,
    0,   81,    0,    0,   81,    0,   81,   81,   81,   81,
   81,   81,    0,    0,   81,    0,    0,   86,   87,   81,
    0,   81,    0,   81,   90,    0,   91,   81,    0,   92,
   86,    0,   94,    0,    0,   97,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  101,   49,  102,   49,
   49,   49,  103,   49,   49,    0,    0,   49,    0,   49,
    0,    0,   49,    0,   49,   49,   49,   49,   49,   49,
    0,    0,   49,    0,    0,    0,    0,   49,  104,   49,
    0,   49,    0,    0,   78,   49,   78,   78,   78,    0,
   78,   78,    0,    0,   78,    0,   78,    0,    0,   78,
    0,   78,   78,   78,   78,   78,   78,    0,    0,   78,
    0,    0,    0,    0,   78,    0,   78,    0,   78,    0,
    0,    0,   78,    0,    0,    0,    0,    0,   48,  113,
   48,   48,   48,    0,   48,   48,    0,    0,   48,    0,
   48,    0,    0,   48,    0,   48,   48,   48,   48,   48,
   48,    0,    0,   48,    0,    0,    0,    0,   48,    0,
   48,   86,   48,   86,   86,   86,   48,   86,   86,    0,
    0,   86,    0,   86,    0,    0,   86,    0,   86,   86,
   86,   86,   86,   86,   43,   44,   86,   46,    0,    0,
    0,   86,    0,   86,    0,   86,    0,    0,    0,   86,
    0,    0,    0,   54,   55,    0,    0,    0,    0,   84,
    0,   85,   86,   87,   61,   88,   89,    0,    0,   90,
    0,   91,    0,   62,   92,    0,   93,   94,   95,   96,
   97,   98,  113,    0,   99,    0,    0,    0,    0,  100,
    0,  101,    0,  102,    0,    0,    0,  103,    0,    0,
    0,    0,  112,    0,    0,  115,  116,    0,  123,  125,
  126,  127,    0,  113,  113,  131,  132,    0,    0,  135,
  113,    0,  113,    0,    0,  113,    0,    0,  113,    0,
    0,  113,    0,    0,  142,    0,  143,  145,    0,    0,
    0,    0,  113,    0,  113,    0,  151,    0,  113,   10,
    0,    0,    0,    0,    0,    0,    0,   11,  155,    0,
    0,  157,    0,   12,    0,   13,    0,    0,    0,  161,
   14,  166,    0,  167,    0,   15,   16,    0,   17,  174,
  175,    0,    0,    0,   18,  178,    0,    0,    0,    0,
    0,    0,    0,   19,    0,   20,    0,    0,   21,    0,
    0,    0,    0,    0,    0,  199,  200,  201,  202,    0,
  204,    0,    0,  113,    0,  113,  113,  113,    0,  113,
  113,    0,    0,  113,    0,  113,  210,    0,  113,    0,
  113,  113,  113,  113,  113,  113,    0,    0,  113,    0,
    0,    0,    0,  113,    0,  113,    0,  113,    0,    0,
    0,  113,
};
const short yycheck[] =
	{                                      61,
    0,   61,   42,  123,  123,  123,   10,  282,  125,  270,
  125,    2,   97,  125,  270,   10,  282,   10,   10,   60,
   10,   10,   10,  123,  267,  297,   67,   10,  113,  305,
  305,  123,   10,  305,  125,  305,  279,   10,  306,  305,
  279,  280,    0,  306,  305,  305,  306,  123,   39,  305,
  125,   61,  125,  123,   45,   59,  125,   10,  305,  306,
  305,  306,  123,   10,   59,    0,   59,   59,  305,   59,
   59,   59,  125,   64,   10,   10,   59,  305,  306,   70,
  271,   59,  289,  299,  280,  265,   59,   22,   23,   24,
   25,   26,  306,  306,   10,  306,  261,  282,  265,  261,
   10,    0,    0,  123,  202,   67,   59,    4,   63,  194,
  195,  158,   59,  180,  105,  106,  107,   81,   -1,   -1,
   -1,   10,   -1,   59,   -1,  125,   -1,   10,   -1,   -1,
  125,  122,   -1,   68,   -1,   -1,   -1,  125,   -1,   74,
   -1,   -1,  257,   59,   -1,  257,   -1,  125,   -1,   59,
   -1,  269,  125,  270,   -1,   -1,   -1,  257,   -1,   -1,
  279,   -1,  281,   -1,   -1,   -1,  284,   -1,   -1,  160,
   59,   -1,  125,  164,  293,  294,   59,  269,  125,  170,
  295,  296,   10,  295,  296,  305,  305,  262,  305,  125,
  281,   -1,  284,  262,  185,  295,  296,   -1,  273,  269,
   -1,   -1,  293,  294,  273,   -1,  197,   -1,  281,  125,
  285,   -1,  287,  288,  284,  125,  285,  292,  287,  288,
  293,  294,   -1,  292,   -1,   -1,  301,   -1,  303,   -1,
   -1,   59,  301,   -1,  303,   -1,  125,   -1,   -1,   -1,
   10,   -1,  125,  305,   -1,  305,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,  257,  258,  259,
  260,   -1,  262,  263,  264,  305,  266,   -1,  268,  257,
  270,  271,  272,  273,  274,  275,  276,  277,  278,  257,
   10,  281,  282,  283,  257,  285,  286,  287,  288,   59,
  290,  291,  292,  293,  294,  295,  296,  125,  256,   -1,
  300,  301,  302,  303,   -1,  305,  264,  295,  296,  262,
   -1,   -1,  270,   -1,  272,  262,   -1,  295,  296,  277,
  273,  257,  295,  296,  282,  283,  273,  285,   -1,   59,
   -1,   -1,  285,  291,  287,  288,   -1,   10,  285,  292,
  287,  288,  300,   -1,  302,  292,  262,  305,  301,   -1,
  303,   -1,  262,   -1,  301,  125,  303,  273,   -1,  295,
  296,   -1,   -1,  273,   -1,   -1,   -1,   -1,   -1,  285,
   -1,  287,  288,  262,   -1,  285,  292,  287,  288,  262,
   10,   -1,  292,   -1,  273,  301,   59,  303,   -1,   -1,
  273,  301,   -1,  303,   -1,  125,  285,   -1,  287,  288,
   -1,   -1,  285,  292,  287,  288,   -1,   -1,   -1,  292,
   -1,   -1,  301,   -1,  303,   -1,   -1,   -1,  301,   10,
  303,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   59,
  258,  259,  260,   -1,  262,  263,   -1,   -1,  266,   -1,
  268,   -1,   -1,  271,   -1,  273,  274,  275,  276,  277,
  278,   -1,  125,  281,   -1,   -1,   -1,   -1,  286,   -1,
  288,   10,  290,   -1,   -1,  293,  294,   -1,   59,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,  258,  259,
  260,   -1,  262,  263,   -1,  125,  266,   -1,  268,   -1,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,   -1,
   59,  281,   10,   -1,   -1,   -1,  286,   -1,  288,   -1,
  290,   -1,   -1,  293,  294,   -1,  256,   -1,  258,  259,
  260,   -1,  262,  263,  125,   -1,  266,   -1,  268,   -1,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,   -1,
   -1,  281,   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,
  290,   59,   -1,  293,  294,   -1,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   10,   -1,   -1,  125,   -1,   -1,   -1,
   -1,   -1,   -1,  256,   -1,  258,  259,  260,   -1,  262,
  263,   -1,   -1,  266,   -1,  268,   -1,   -1,  271,   -1,
  273,  274,  275,  276,  277,  278,   10,   -1,  281,   -1,
   -1,   -1,   -1,  286,   -1,  288,   -1,  290,   -1,   -1,
  293,  294,   59,   -1,   -1,   -1,  256,  125,  258,  259,
  260,   -1,  262,  263,   -1,   -1,  266,   -1,  268,   -1,
   -1,  271,   -1,  273,  274,  275,  276,  277,  278,   -1,
   -1,  281,   10,   -1,   -1,   59,  286,   -1,  288,   -1,
  290,   -1,   -1,   -1,  294,  256,   -1,  258,  259,  260,
   -1,  262,  263,   -1,   -1,  266,   -1,  268,   -1,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,  125,   10,
  281,   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,  290,
   -1,   59,   -1,  294,   -1,   -1,   -1,  256,   -1,  258,
  259,  260,   -1,  262,  263,   -1,   -1,  266,   -1,  268,
   -1,  125,  271,   -1,  273,  274,  275,  276,  277,  278,
   -1,   -1,  281,   10,   -1,   -1,   -1,  286,   59,  288,
   -1,  290,   -1,   -1,   -1,  294,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  258,  259,  260,   -1,  262,  263,   10,  125,  266,   -1,
  268,   -1,   -1,  271,   -1,  273,  274,  275,  276,  277,
  278,   -1,   59,  281,   -1,   -1,   -1,   -1,  286,   -1,
  288,   -1,  290,   -1,   -1,   -1,  294,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,  125,   -1,   -1,   -1,   -1,   -1,
   -1,   10,   -1,   -1,   -1,   59,   -1,   -1,   -1,  256,
   -1,  258,  259,  260,   -1,  262,  263,   -1,   -1,  266,
   -1,  268,   -1,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,   -1,   -1,  281,   -1,   -1,   -1,  125,  286,
   -1,  288,  256,  290,  258,  259,  260,  294,  262,  263,
   59,   -1,  266,   10,  268,   -1,   -1,  271,   -1,  273,
  274,  275,  276,  277,  278,   -1,   -1,  281,   -1,   -1,
   -1,  125,  286,   -1,  288,   -1,  290,   -1,   -1,   -1,
  294,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,   -1,
  258,  259,  260,   -1,  262,  263,   -1,   -1,  266,   -1,
  268,   -1,   59,  271,   -1,  273,  274,  275,  276,  277,
  278,   10,   -1,  281,   -1,   -1,  125,   -1,  286,   -1,
  288,   -1,  290,   -1,   -1,  256,  294,  258,  259,  260,
   -1,  262,  263,   -1,   -1,  266,   -1,  268,   -1,   -1,
  271,   -1,  273,  274,  275,  276,  277,  278,   10,   -1,
  281,   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,  290,
   59,   -1,   -1,  294,   -1,   -1,   -1,   -1,  125,  256,
   -1,  258,  259,  260,   -1,  262,  263,   -1,   -1,  266,
   -1,  268,   -1,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,   10,  125,  281,   -1,   -1,   59,   -1,  286,
   -1,  288,  256,  290,  258,  259,  260,  294,  262,  263,
   -1,   -1,  266,   -1,  268,   -1,   -1,  271,   -1,  273,
  274,  275,  276,  277,  278,   10,  125,  281,   -1,   -1,
   -1,   -1,  286,   -1,  288,   -1,  290,   -1,   -1,   -1,
  294,   59,   -1,   -1,   -1,   -1,   -1,  256,   -1,  258,
  259,  260,   -1,  262,  263,   -1,   -1,  266,   -1,  268,
   -1,   -1,  271,  125,  273,  274,  275,  276,  277,  278,
   -1,   -1,  281,   -1,   59,   -1,   -1,  286,   -1,  288,
   -1,  290,   -1,   -1,   -1,  294,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,   -1,  256,
   -1,  258,  259,  260,   -1,  262,  263,  125,   -1,  266,
   -1,  268,   -1,   -1,  271,   -1,  273,  274,  275,  276,
  277,  278,   -1,   -1,  281,   -1,   -1,  259,  260,  286,
   -1,  288,   -1,  290,  266,   -1,  268,  294,   -1,  271,
  125,   -1,  274,   -1,   -1,  277,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,   -1,   -1,   -1,  288,  256,  290,  258,
  259,  260,  294,  262,  263,   -1,   -1,  266,   -1,  268,
   -1,   -1,  271,   -1,  273,  274,  275,  276,  277,  278,
   -1,   -1,  281,   -1,   -1,   -1,   -1,  286,  125,  288,
   -1,  290,   -1,   -1,  256,  294,  258,  259,  260,   -1,
  262,  263,   -1,   -1,  266,   -1,  268,   -1,   -1,  271,
   -1,  273,  274,  275,  276,  277,  278,   -1,   -1,  281,
   -1,   -1,   -1,   -1,  286,   -1,  288,   -1,  290,   -1,
   -1,   -1,  294,   -1,   -1,   -1,   -1,   -1,  256,  125,
  258,  259,  260,   -1,  262,  263,   -1,   -1,  266,   -1,
  268,   -1,   -1,  271,   -1,  273,  274,  275,  276,  277,
  278,   -1,   -1,  281,   -1,   -1,   -1,   -1,  286,   -1,
  288,  256,  290,  258,  259,  260,  294,  262,  263,   -1,
   -1,  266,   -1,  268,   -1,   -1,  271,   -1,  273,  274,
  275,  276,  277,  278,   17,   18,  281,   20,   -1,   -1,
   -1,  286,   -1,  288,   -1,  290,   -1,   -1,   -1,  294,
   -1,   -1,   -1,   36,   37,   -1,   -1,   -1,   -1,  256,
   -1,  258,  259,  260,   47,  262,  263,   -1,   -1,  266,
   -1,  268,   -1,   56,  271,   -1,  273,  274,  275,  276,
  277,  278,  125,   -1,  281,   -1,   -1,   -1,   -1,  286,
   -1,  288,   -1,  290,   -1,   -1,   -1,  294,   -1,   -1,
   -1,   -1,   85,   -1,   -1,   88,   89,   -1,   91,   92,
   93,   94,   -1,  259,  260,   98,   99,   -1,   -1,  102,
  266,   -1,  268,   -1,   -1,  271,   -1,   -1,  274,   -1,
   -1,  277,   -1,   -1,  117,   -1,  119,  120,   -1,   -1,
   -1,   -1,  288,   -1,  290,   -1,  129,   -1,  294,  256,
   -1,   -1,   -1,   -1,   -1,   -1,   -1,  264,  141,   -1,
   -1,  144,   -1,  270,   -1,  272,   -1,   -1,   -1,  152,
  277,  154,   -1,  156,   -1,  282,  283,   -1,  285,  162,
  163,   -1,   -1,   -1,  291,  168,   -1,   -1,   -1,   -1,
   -1,   -1,   -1,  300,   -1,  302,   -1,   -1,  305,   -1,
   -1,   -1,   -1,   -1,   -1,  188,  189,  190,  191,   -1,
  193,   -1,   -1,  256,   -1,  258,  259,  260,   -1,  262,
  263,   -1,   -1,  266,   -1,  268,  209,   -1,  271,   -1,
  273,  274,  275,  276,  277,  278,   -1,   -1,  281,   -1,
   -1,   -1,   -1,  286,   -1,  288,   -1,  290,   -1,   -1,
   -1,  294,
};
#define YYFINAL 3
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 306
#if YYDEBUG
const char * const yyname[] =
	{
"end-of-file",0,0,0,0,0,0,0,0,0,"'\\n'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,"'*'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"';'",0,"'='",0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"'{'",0,"'}'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"ACCESS","ALIAS","AUTO","BLOCK","CA","CERT","CGI","CHROOT","CLIENT","DEFAULT",
"FACILITY","FASTCGI","FOR_HOST","INCLUDE","INDEX","IPV6","KEY","LANG","LISTEN",
"LOCATION","LOG","OCSP","OFF","ON","PARAM","PORT","PREFORK","PROTO","PROTOCOLS",
"PROXY","RELAY_TO","REQUIRE","RETURN","ROOT","SERVER","SNI","SOCKET","STRIP",
"STYLE","SYSLOG","TCP","TOEXT","TYPE","TYPES","USE_TLS","USER","VERIFYNAME",
"ERROR","STRING","NUM",
};
const char * const yyrule[] =
	{"$accept : grammar",
"grammar : nl conf",
"grammar : conf",
"conf :",
"conf : conf include nl",
"conf : conf varset nl",
"conf : conf option nl",
"conf : conf vhost nl",
"conf : conf types nl",
"conf : conf error nl",
"include : INCLUDE STRING",
"bool : ON",
"bool : OFF",
"string : string STRING",
"string : STRING",
"numberstring : NUM",
"numberstring : STRING",
"varset : STRING '=' string",
"option : CHROOT string",
"option : IPV6 bool",
"option : log",
"option : PORT NUM",
"option : PREFORK NUM",
"option : PROTOCOLS string",
"option : USER string",
"log : LOG '{' optnl logopts '}'",
"log : LOG logopt",
"logopts :",
"logopts : logopts logopt optnl",
"logopt : ACCESS string",
"logopt : STYLE string",
"logopt : SYSLOG FACILITY string",
"logopt : SYSLOG OFF",
"logopt : SYSLOG",
"$$1 :",
"vhost : SERVER string $$1 '{' optnl servbody '}'",
"vhost : error '}'",
"servbody :",
"servbody : servbody servopt optnl",
"servbody : servbody location optnl",
"servbody : servbody proxy optnl",
"listen_addr : '*'",
"listen_addr : STRING",
"servopt : ALIAS string",
"servopt : CERT string",
"servopt : CGI string",
"servopt : KEY string",
"servopt : OCSP string",
"servopt : PARAM string '=' string",
"servopt : LISTEN ON listen_addr",
"servopt : LISTEN ON listen_addr PORT STRING",
"servopt : LISTEN ON listen_addr PORT NUM",
"servopt : locopt",
"$$2 :",
"proxy : PROXY $$2 proxy_matches '{' optnl proxy_opts '}'",
"proxy_matches :",
"proxy_matches : proxy_matches proxy_match",
"proxy_port :",
"proxy_port : PORT STRING",
"proxy_port : PORT NUM",
"proxy_match : PROTO string",
"proxy_match : FOR_HOST string proxy_port",
"proxy_opts :",
"proxy_opts : proxy_opts proxy_opt optnl",
"proxy_opt : CERT string",
"proxy_opt : KEY string",
"proxy_opt : PROTOCOLS string",
"proxy_opt : RELAY_TO string proxy_port",
"proxy_opt : REQUIRE CLIENT CA string",
"proxy_opt : SNI string",
"proxy_opt : USE_TLS bool",
"proxy_opt : VERIFYNAME bool",
"$$3 :",
"location : LOCATION $$3 string '{' optnl locopts '}'",
"location : error '}'",
"locopts :",
"locopts : locopts locopt optnl",
"locopt : AUTO INDEX bool",
"locopt : BLOCK RETURN NUM string",
"locopt : BLOCK RETURN NUM",
"locopt : BLOCK",
"locopt : DEFAULT TYPE string",
"locopt : fastcgi",
"locopt : INDEX string",
"locopt : LANG string",
"locopt : LOG bool",
"locopt : REQUIRE CLIENT CA string",
"locopt : ROOT string",
"locopt : STRIP NUM",
"fastcgi : FASTCGI '{' optnl fastcgiopts '}'",
"fastcgi : FASTCGI fastcgiopt",
"fastcgi : FASTCGI OFF",
"fastcgi : FASTCGI string",
"fastcgiopts :",
"fastcgiopts : fastcgiopts fastcgiopt optnl",
"fastcgiopt : PARAM string '=' string",
"fastcgiopt : SOCKET string",
"fastcgiopt : SOCKET TCP string PORT NUM",
"fastcgiopt : SOCKET TCP string",
"fastcgiopt : SOCKET TCP string PORT string",
"fastcgiopt : STRIP NUM",
"types : TYPES '{' optnl mediaopts_l '}'",
"mediaopts_l : mediaopts_l mediaoptsl nl",
"mediaopts_l : mediaoptsl nl",
"$$4 :",
"mediaoptsl : STRING $$4 medianames_l",
"mediaoptsl : include",
"medianames_l : medianames_l medianamesl",
"medianames_l : medianamesl",
"medianamesl : numberstring",
"nl : '\\n' optnl",
"nl : ';' optnl",
"optnl : nl",
"optnl :",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 10000
#define YYMAXDEPTH 10000
#endif
#endif
#define YYINITSTACKSIZE 200
/* LINTUSED */
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short *yyss;
short *yysslim;
YYSTYPE *yyvs;
unsigned int yystacksize;
int yyparse(void);
#line 679 "parse.y"

static const struct keyword {
	const char *word;
	int token;
} keywords[] = {
	/* these MUST be sorted */
	{"access", ACCESS},
	{"alias", ALIAS},
	{"auto", AUTO},
	{"block", BLOCK},
	{"ca", CA},
	{"cert", CERT},
	{"cgi", CGI},
	{"chroot", CHROOT},
	{"client", CLIENT},
	{"default", DEFAULT},
	{"facility", FACILITY},
	{"fastcgi", FASTCGI},
	{"for-host", FOR_HOST},
	{"include", INCLUDE},
	{"index", INDEX},
	{"ipv6", IPV6},
	{"key", KEY},
	{"lang", LANG},
	{"listen", LISTEN},
	{"location", LOCATION},
	{"log", LOG},
	{"ocsp", OCSP},
	{"off", OFF},
	{"on", ON},
	{"param", PARAM},
	{"port", PORT},
	{"prefork", PREFORK},
	{"proto", PROTO},
	{"protocols", PROTOCOLS},
	{"proxy", PROXY},
	{"relay-to", RELAY_TO},
	{"require", REQUIRE},
	{"return", RETURN},
	{"root", ROOT},
	{"server", SERVER},
	{"sni", SNI},
	{"socket", SOCKET},
	{"strip", STRIP},
	{"style", STYLE},
	{"syslog", SYSLOG},
	{"tcp", TCP},
	{"to-ext", TOEXT},
	{"type", TYPE},
	{"types", TYPES},
	{"use-tls", USE_TLS},
	{"user", USER},
	{"verifyname", VERIFYNAME},
};

void
yyerror(const char *msg, ...)
{
	va_list ap;

	file->errors++;

	va_start(ap, msg);
	fprintf(stderr, "%s:%d error: ", config_path, yylval.lineno);
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
	va_end(ap);
}

void
yywarn(const char *msg, ...)
{
	va_list ap;

	va_start(ap, msg);
	fprintf(stderr, "%s:%d warning: ", config_path, yylval.lineno);
	vfprintf(stderr, msg, ap);
	fprintf(stderr, "\n");
	va_end(ap);
}

int
kw_cmp(const void *k, const void *e)
{
	return strcmp(k, ((struct keyword *)e)->word);
}

int
lookup(char *s)
{
	const struct keyword	*p;

	p = bsearch(s, keywords, sizeof(keywords)/sizeof(keywords[0]),
	    sizeof(keywords[0]), kw_cmp);

	if (p)
		return p->token;
	else
		return STRING;
}

#define START_EXPAND	1
#define DONE_EXPAND	2

static int	expanding;

int
igetc(void)
{
	int	c;

	while (1) {
		if (file->ungetpos > 0)
			c = file->ungetbuf[--file->ungetpos];
		else
			c = getc(file->stream);

		if (c == START_EXPAND)
			expanding = 1;
		else if (c == DONE_EXPAND)
			expanding = 0;
		else
			break;
	}
	return c;
}

int
lgetc(int quotec)
{
	int		c, next;

	if (quotec) {
		if ((c = igetc()) == EOF) {
			yyerror("reached end of file while parsing "
			    "quoted string");
			if (file == topfile || popfile() == EOF)
				return EOF;
			return quotec;
		}
		return c;
	}

	while ((c = igetc()) == '\\') {
		next = igetc();
		if (next != '\n') {
			c = next;
			break;
		}
		yylval.lineno = file->lineno;
		file->lineno++;
	}

	if (c == EOF) {
		/*
		 * Fake EOL when hit EOF for the first time. This gets line
		 * count right if last line in included file is syntactically
		 * invalid and has no newline.
		 */
		if (file->eof_reached == 0) {
			file->eof_reached = 1;
			return '\n';
		}
		while (c == EOF) {
			if (file == topfile || popfile() == EOF)
				return EOF;
			c = igetc();
		}
	}
	return c;
}

void
lungetc(int c)
{
	if (c == EOF)
		return;

	if (file->ungetpos >= file->ungetsize) {
		void *p = reallocarray(file->ungetbuf, file->ungetsize, 2);
		if (p == NULL)
			fatal("lungetc");
		file->ungetbuf = p;
		file->ungetsize *= 2;
	}
	file->ungetbuf[file->ungetpos++] = c;
}

int
findeol(void)
{
	int	c;

	/* Skip to either EOF or the first real EOL. */
	while (1) {
		c = lgetc(0);
		if (c == '\n') {
			file->lineno++;
			break;
		}
		if (c == EOF)
			break;
	}
	return ERROR;
}

int
yylex(void)
{
	char	 buf[8096];
	char	*p, *val;
	int	 quotec, next, c;
	int	 token;

top:
	p = buf;
	while ((c = lgetc(0)) == ' ' || c == '\t')
		; /* nothing */

	yylval.lineno = file->lineno;
	if (c == '#')
		while ((c = lgetc(0)) != '\n' && c != EOF)
			; /* nothing */
	if (c == '$' && !expanding) {
		while (1) {
			if ((c = lgetc(0)) == EOF)
				return 0;
			if (p + 1 >= buf + sizeof(buf) -1) {
				yyerror("string too long");
				return findeol();
			}
			if (isalnum(c) || c == '_') {
				*p++ = c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro `%s' not defined", buf);
			return findeol();
		}
		yylval.v.string = xstrdup(val);
		return STRING;
	}
	if (c == '@' && !expanding) {
		while (1) {
			if ((c = lgetc(0)) == EOF)
				return 0;

			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return findeol();
			}
			if (isalnum(c) || c == '_') {
				*p++ = c;
				continue;
			}
			*p = '\0';
			lungetc(c);
			break;
		}
		val = symget(buf);
		if (val == NULL) {
			yyerror("macro '%s' not defined", buf);
			return findeol();
		}
		p = val + strlen(val) - 1;
		lungetc(DONE_EXPAND);
		while (p >= val) {
			lungetc(*p);
			p--;
		}
		lungetc(START_EXPAND);
		goto top;
	}

	switch (c) {
	case '\'':
	case '"':
		quotec = c;
		while (1) {
			if ((c = lgetc(quotec)) == EOF)
				return 0;
			if (c == '\n') {
				file->lineno++;
				continue;
			} else if (c == '\\') {
				if ((next = lgetc(quotec)) == EOF)
					return (0);
				if (next == quotec || next == ' ' ||
				    next == '\t')
					c = next;
				else if (next == '\n') {
					file->lineno++;
					continue;
				} else
					lungetc(next);
			} else if (c == quotec) {
				*p = '\0';
				break;
			} else if (c == '\0') {
				yyerror("invalid syntax");
				return findeol();
			}
			if (p + 1 >= buf + sizeof(buf) - 1) {
				yyerror("string too long");
				return findeol();
			}
			*p++ = c;
		}
		yylval.v.string = strdup(buf);
		if (yylval.v.string == NULL)
			fatal("yylex: strdup");
		return STRING;
	}

#define allowed_to_end_number(x) \
	(isspace(x) || x == ')' || x ==',' || x == '/' || x == '}' || x == '=')

	if (c == '-' || isdigit(c)) {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return findeol();
			}
		} while ((c = lgetc(0)) != EOF && isdigit(c));
		lungetc(c);
		if (p == buf + 1 && buf[0] == '-')
			goto nodigits;
		if (c == EOF || allowed_to_end_number(c)) {
			const char *errstr = NULL;

			*p = '\0';
			yylval.v.number = strtonum(buf, LLONG_MIN,
			    LLONG_MAX, &errstr);
			if (errstr) {
				yyerror("\"%s\" invalid number: %s",
				    buf, errstr);
				return findeol();
			}
			return NUM;
		} else {
nodigits:
			while (p > buf + 1)
				lungetc(*--p);
			c = *--p;
			if (c == '-')
				return c;
		}
	}

#define allowed_in_string(x) \
	(isalnum(x) || (ispunct(x) && x != '(' && x != ')' && \
	x != '{' && x != '}' && \
	x != '!' && x != '=' && x != '#' && \
	x != ',' && x != ';'))

	if (isalnum(c) || c == ':' || c == '_') {
		do {
			*p++ = c;
			if ((size_t)(p-buf) >= sizeof(buf)) {
				yyerror("string too long");
				return findeol();
			}
		} while ((c = lgetc(0)) != EOF && (allowed_in_string(c)));
		lungetc(c);
		*p = '\0';
		if ((token = lookup(buf)) == STRING)
			yylval.v.string = xstrdup(buf);
		return token;
	}
	if (c == '\n') {
		yylval.lineno = file->lineno;
		file->lineno++;
	}
	if (c == EOF)
		return 0;
	return c;
}

struct file *
pushfile(const char *name, int secret)
{
	struct file	*nfile;

	nfile = xcalloc(1, sizeof(*nfile));
	nfile->name = xstrdup(name);
	if ((nfile->stream = fopen(nfile->name, "r")) == NULL) {
		log_warn("can't open %s", nfile->name);
		free(nfile->name);
		free(nfile);
		return NULL;
	}
	nfile->lineno = TAILQ_EMPTY(&files) ? 1 : 0;
	nfile->ungetsize = 16;
	nfile->ungetbuf = xcalloc(1, nfile->ungetsize);
	TAILQ_INSERT_TAIL(&files, nfile, entry);
	return nfile;
}

int
popfile(void)
{
	struct file	*prev;

	if ((prev = TAILQ_PREV(file, files, entry)) != NULL)
		prev->errors += file->errors;

	TAILQ_REMOVE(&files, file, entry);
	fclose(file->stream);
	free(file->name);
	free(file->ungetbuf);
	free(file);
	file = prev;
	return file ? 0 : EOF;
}

int
parse_conf(struct conf *c, const char *filename)
{
	struct sym		*sym, *next;

	default_host = NULL;
	default_port = 1965;

	conf = c;

	file = pushfile(filename, 0);
	if (file == NULL)
		return -1;
	topfile = file;

	yyparse();
	errors = file->errors;
	popfile();

	/* Free macros and check which have not been used. */
	TAILQ_FOREACH_SAFE(sym, &symhead, entry, next) {
		/* TODO: warn if !sym->used */
		if (!sym->persist) {
			free(sym->name);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	if (errors)
		return -1;
	return 0;
}

int
symset(const char *name, const char *val, int persist)
{
	struct sym *sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (!strcmp(name, sym->name))
			break;
	}

	if (sym != NULL) {
		if (sym->persist)
			return 0;
		else {
			free(sym->name);
			free(sym->val);
			TAILQ_REMOVE(&symhead, sym, entry);
			free(sym);
		}
	}

	sym = xcalloc(1, sizeof(*sym));
	sym->name = xstrdup(name);
	sym->val = xstrdup(val);
	sym->used = 0;
	sym->persist = persist;

	TAILQ_INSERT_TAIL(&symhead, sym, entry);
	return 0;
}

int
cmdline_symset(char *s)
{
	char	*sym, *val;
	int	 ret;

	if ((val = strrchr(s, '=')) == NULL)
		return -1;
	sym = xcalloc(1, val - s + 1);
	memcpy(sym, s, val - s);
	ret = symset(sym, val + 1, 1);
	free(sym);
	return ret;
}

char *
symget(const char *nam)
{
	struct sym	*sym;

	TAILQ_FOREACH(sym, &symhead, entry) {
		if (strcmp(nam, sym->name) == 0) {
			sym->used = 1;
			return sym->val;
		}
	}
	return NULL;
}

char *
ensure_absolute_path(char *path)
{
	if (path == NULL || *path != '/')
		yyerror("not an absolute path: %s", path);
	return path;
}

int
check_block_code(int n)
{
	if (n < 10 || n >= 70 || (n >= 20 && n <= 29))
		yyerror("invalid block code %d", n);
	return n;
}

char *
check_block_fmt(char *fmt)
{
	char *s;

	for (s = fmt; *s; ++s) {
		if (*s != '%')
			continue;
		switch (*++s) {
		case '%':
		case 'p':
		case 'q':
		case 'P':
		case 'N':
			break;
		default:
			yyerror("invalid format specifier %%%c", *s);
		}
	}

	return fmt;
}

int
check_strip_no(int n)
{
	if (n <= 0)
		yyerror("invalid strip number %d", n);
	return n;
}

int
check_prefork_num(int n)
{
	if (n <= 0 || n >= PROC_MAX_INSTANCES)
		yyerror("invalid prefork number %d", n);
	return n;
}

void
advance_loc(void)
{
	loc = new_location();
	TAILQ_INSERT_TAIL(&host->locations, loc, locations);
}

void
advance_proxy(void)
{
	proxy = new_proxy();
	TAILQ_INSERT_TAIL(&host->proxies, proxy, proxies);
}

int
fastcgi_conf(const char *path, const char *port)
{
	struct fcgi	*f;
	int		i = 0;

	TAILQ_FOREACH(f, &conf->fcgi, fcgi) {
		if (!strcmp(f->path, path) &&
		    ((port == NULL && *f->port == '\0') ||
		     !strcmp(f->port, port)))
			return i;
		++i;
	}

	f = xcalloc(1, sizeof(*f));
	f->id = i;
	if (strlcpy(f->path, path, sizeof(f->path)) >= sizeof(f->path))
		yyerror("fastcgi path is too long: %s", path);
	if (port != NULL &&
	    strlcpy(f->port, port, sizeof(f->port)) >= sizeof(f->port))
		yyerror("port too long: %s", port);
	TAILQ_INSERT_TAIL(&conf->fcgi, f, fcgi);

	return f->id;
}

void
add_param(char *name, char *val)
{
	struct envlist *e;
	struct envhead *h = &loc->params;

	e = xcalloc(1, sizeof(*e));
	if (strlcpy(e->name, name, sizeof(e->name)) >= sizeof(e->name))
		yyerror("parameter name too long: %s", name);
	if (strlcpy(e->value, val, sizeof(e->value)) >= sizeof(e->value))
		yyerror("param value too long: %s", val);
	TAILQ_INSERT_TAIL(h, e, envs);
}

int
getservice(const char *n)
{
	struct servent	*s;
	const char	*errstr;
	long long	 llval;

	llval = strtonum(n, 0, UINT16_MAX, &errstr);
	if (errstr) {
		s = getservbyname(n, "tcp");
		if (s == NULL)
			s = getservbyname(n, "udp");
		if (s == NULL)
			return (-1);
		return (ntohs(s->s_port));
	}

	return ((unsigned short)llval);
}

static void
add_to_addr_queue(struct addrhead *a, struct addrinfo *ai, const char *pp)
{
	struct address		*addr;
	struct sockaddr_in	*sin;
	struct sockaddr_in6	*sin6;

	if (ai->ai_addrlen > sizeof(addr->ss))
		fatalx("ai_addrlen larger than a sockaddr_storage");

	TAILQ_FOREACH(addr, a, addrs) {
		if (addr->ai_flags == ai->ai_flags &&
		    addr->ai_family == ai->ai_family &&
		    addr->ai_socktype == ai->ai_socktype &&
		    addr->ai_protocol == ai->ai_protocol &&
		    addr->slen == ai->ai_addrlen &&
		    !memcmp(&addr->ss, ai->ai_addr, addr->slen))
			return;
	}

	addr = xcalloc(1, sizeof(*addr));
	addr->ai_flags = ai->ai_flags;
	addr->ai_family = ai->ai_family;
	addr->ai_socktype = ai->ai_socktype;
	addr->ai_protocol = ai->ai_protocol;
	addr->slen = ai->ai_addrlen;
	memcpy(&addr->ss, ai->ai_addr, ai->ai_addrlen);
	strlcpy(addr->pp, pp, sizeof(addr->pp));

	/* for commodity */
	switch (addr->ai_family) {
	case AF_INET:
		sin = (struct sockaddr_in *)&addr->ss;
		addr->port = ntohs(sin->sin_port);
		break;
	case AF_INET6:
		sin6 = (struct sockaddr_in6 *)&addr->ss;
		addr->port = ntohs(sin6->sin6_port);
		break;
	default:
		fatalx("unknown socket family %d", addr->ai_family);
	}

	addr->sock = -1;

	TAILQ_INSERT_HEAD(a, addr, addrs);
}

void
listen_on(const char *hostname, const char *servname)
{
	struct addrinfo hints, *res, *res0;
	char pp[NI_MAXHOST];
	int error;

	memset(&hints, 0, sizeof(hints));
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_flags = AI_PASSIVE;
	error = getaddrinfo(hostname, servname, &hints, &res0);
	if (error) {
		yyerror("listen on \"%s\" port %s: %s", hostname, servname,
		    gai_strerror(errno));
		return;
	}

	for (res = res0; res; res = res->ai_next) {
		if (getnameinfo(res->ai_addr, res->ai_addrlen, pp, sizeof(pp),
		    NULL, 0, NI_NUMERICHOST) == -1) {
			yyerror("getnameinfo failed: %s", strerror(errno));
			break;
		}

		add_to_addr_queue(&host->addrs, res, pp);
		add_to_addr_queue(&conf->addrs, res, pp);
	}

	freeaddrinfo(res0);
}
#line 1492 "y.tab.c"
/* allocate initial stack or double stack size, up to YYMAXDEPTH */
static int yygrowstack(void)
{
    unsigned int newsize;
    long sslen;
    short *newss;
    YYSTYPE *newvs;

    if ((newsize = yystacksize) == 0)
        newsize = YYINITSTACKSIZE;
    else if (newsize >= YYMAXDEPTH)
        return -1;
    else if ((newsize *= 2) > YYMAXDEPTH)
        newsize = YYMAXDEPTH;
    sslen = yyssp - yyss;
#ifdef SIZE_MAX
#define YY_SIZE_MAX SIZE_MAX
#else
#define YY_SIZE_MAX 0xffffffffU
#endif
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newss)
        goto bail;
    newss = (short *)realloc(yyss, newsize * sizeof *newss);
    if (newss == NULL)
        goto bail;
    yyss = newss;
    yyssp = newss + sslen;
    if (newsize && YY_SIZE_MAX / newsize < sizeof *newvs)
        goto bail;
    newvs = (YYSTYPE *)realloc(yyvs, newsize * sizeof *newvs);
    if (newvs == NULL)
        goto bail;
    yyvs = newvs;
    yyvsp = newvs + sslen;
    yystacksize = newsize;
    yysslim = yyss + newsize - 1;
    return 0;
bail:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return -1;
}

#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse(void)
{
    int yym, yyn, yystate;
#if YYDEBUG
    const char *yys;

    if ((yys = getenv("YYDEBUG")))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif /* YYDEBUG */

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    if (yyss == NULL && yygrowstack()) goto yyoverflow;
    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if ((yyn = yydefred[yystate]) != 0) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yysslim && yygrowstack())
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#if defined(__GNUC__)
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#if defined(__GNUC__)
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yysslim && yygrowstack())
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    if (yym)
        yyval = yyvsp[1-yym];
    else
        memset(&yyval, 0, sizeof yyval);
    switch (yyn)
    {
case 9:
#line 162 "parse.y"
{ file->errors++; }
break;
case 10:
#line 165 "parse.y"
{
			struct file	*nfile;

			if ((nfile = pushfile(yyvsp[0].v.string, 0)) == NULL) {
				yyerror("failed to include file %s", yyvsp[0].v.string);
				free(yyvsp[0].v.string);
				YYERROR;
			}
			free(yyvsp[0].v.string);

			file = nfile;
			lungetc('\n');
		}
break;
case 11:
#line 180 "parse.y"
{ yyval.v.number = 1; }
break;
case 12:
#line 181 "parse.y"
{ yyval.v.number = 0; }
break;
case 13:
#line 184 "parse.y"
{
			if (asprintf(&yyval.v.string, "%s%s", yyvsp[-1].v.string, yyvsp[0].v.string) == -1) {
				free(yyvsp[-1].v.string);
				free(yyvsp[0].v.string);
				yyerror("string: asprintf: %s", strerror(errno));
				YYERROR;
			}
			free(yyvsp[-1].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 15:
#line 197 "parse.y"
{
			char *s;
			if (asprintf(&s, "%d", yyvsp[0].v.number) == -1) {
				yyerror("asprintf: number");
				YYERROR;
			}
			yyval.v.string = s;
		}
break;
case 17:
#line 208 "parse.y"
{
			char *s = yyvsp[-2].v.string;
			while (*s++) {
				if (isspace((unsigned char)*s)) {
					yyerror("macro name cannot contain "
					    "whitespaces");
					free(yyvsp[-2].v.string);
					free(yyvsp[0].v.string);
					YYERROR;
				}
			}
			symset(yyvsp[-2].v.string, yyvsp[0].v.string, 0);
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 18:
#line 225 "parse.y"
{
			if (strlcpy(conf->chroot, yyvsp[0].v.string, sizeof(conf->chroot)) >=
			    sizeof(conf->chroot))
				yyerror("chroot path too long");
			free(yyvsp[0].v.string);
		}
break;
case 19:
#line 231 "parse.y"
{
			yywarn("option `ipv6' is deprecated,"
			    " please use `listen on'");
			if (yyvsp[0].v.number)
				default_host = NULL;
			else
				default_host = "0.0.0.0";
		}
break;
case 21:
#line 240 "parse.y"
{
			yywarn("option `port' is deprecated,"
			    " please use `listen on'");
			default_port = yyvsp[0].v.number;
		}
break;
case 22:
#line 245 "parse.y"
{ conf->prefork = check_prefork_num(yyvsp[0].v.number); }
break;
case 23:
#line 246 "parse.y"
{
			if (tls_config_parse_protocols(&conf->protos, yyvsp[0].v.string) == -1)
				yyerror("invalid protocols string \"%s\"", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 24:
#line 251 "parse.y"
{
			if (strlcpy(conf->user, yyvsp[0].v.string, sizeof(conf->user)) >=
			    sizeof(conf->user))
				yyerror("user name too long");
			free(yyvsp[0].v.string);
		}
break;
case 29:
#line 267 "parse.y"
{
			free(conf->log_access);
			conf->log_access = yyvsp[0].v.string;
		}
break;
case 30:
#line 271 "parse.y"
{
			if (!strcmp("combined", yyvsp[0].v.string))
				conf->log_format = LOG_FORMAT_COMBINED;
			else if (!strcmp("common", yyvsp[0].v.string))
				conf->log_format = LOG_FORMAT_COMMON;
			else if (!strcmp("condensed", yyvsp[0].v.string))
				conf->log_format = LOG_FORMAT_CONDENSED;
			else if (!strcmp("legacy", yyvsp[0].v.string))
				conf->log_format = LOG_FORMAT_LEGACY;
			else
				yyerror("unknown log style: %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 31:
#line 284 "parse.y"
{
			const char *str = yyvsp[0].v.string;

			conf->log_syslog = 1;

			if (!strncasecmp(str, "LOG_", 4))
				str += 4;

			if (!strcasecmp(str, "daemon"))
				conf->log_facility = LOG_DAEMON;
#ifdef LOG_FTP
			else if (!strcasecmp(str, "ftp"))
				conf->log_facility = LOG_FTP;
#endif
			else if (!strcasecmp(str, "local1"))
				conf->log_facility = LOG_LOCAL1;
			else if (!strcasecmp(str, "local2"))
				conf->log_facility = LOG_LOCAL2;
			else if (!strcasecmp(str, "local3"))
				conf->log_facility = LOG_LOCAL3;
			else if (!strcasecmp(str, "local4"))
				conf->log_facility = LOG_LOCAL4;
			else if (!strcasecmp(str, "local5"))
				conf->log_facility = LOG_LOCAL5;
			else if (!strcasecmp(str, "local6"))
				conf->log_facility = LOG_LOCAL6;
			else if (!strcasecmp(str, "local7"))
				conf->log_facility = LOG_LOCAL7;
			else if (!strcasecmp(str, "user"))
				conf->log_facility = LOG_USER;
			else
				yywarn("unknown syslog facility `%s'",
				    yyvsp[0].v.string);

			free(yyvsp[0].v.string);
		}
break;
case 32:
#line 320 "parse.y"
{
			conf->log_syslog = 0;
		}
break;
case 33:
#line 323 "parse.y"
{
			conf->log_syslog = 1;
		}
break;
case 34:
#line 328 "parse.y"
{
			host = new_vhost();
			TAILQ_INSERT_HEAD(&conf->hosts, host, vhosts);

			loc = new_location();
			TAILQ_INSERT_HEAD(&host->locations, loc, locations);

			TAILQ_INIT(&host->proxies);

			(void) strlcpy(loc->match, "*", sizeof(loc->match));

			if (strlcpy(host->domain, yyvsp[0].v.string, sizeof(host->domain))
			    >= sizeof(host->domain))
				yyerror("server name too long: %s", yyvsp[0].v.string);

			if (strstr(yyvsp[0].v.string, "xn--") != NULL) {
				yywarn("\"%s\" looks like punycode: you "
				    "should use the decoded hostname", yyvsp[0].v.string);
			}

			free(yyvsp[0].v.string);
		}
break;
case 35:
#line 349 "parse.y"
{
			if (host->cert_path == NULL ||
			    host->key_path == NULL)
				yyerror("invalid vhost definition: %s",
				    host->domain);
			if (TAILQ_EMPTY(&host->addrs)) {
				char portno[32];
				int r;

				r = snprintf(portno, sizeof(portno), "%d",
				    default_port);
				if (r < 0 || (size_t)r >= sizeof(portno))
					fatal("snprintf");

				yywarn("missing `listen on' in server %s,"
				    " assuming %s port %d", host->domain,
				    default_host ? default_host : "*",
				    default_port);
				listen_on(default_host, portno);
			}
		}
break;
case 36:
#line 370 "parse.y"
{ yyerror("bad server directive"); }
break;
case 41:
#line 379 "parse.y"
{ yyval.v.string = NULL; }
break;
case 43:
#line 383 "parse.y"
{
			struct alist *a;

			a = xcalloc(1, sizeof(*a));
			if (strlcpy(a->alias, yyvsp[0].v.string, sizeof(a->alias))
			    >= sizeof(a->alias))
				yyerror("alias too long: %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
			TAILQ_INSERT_TAIL(&host->aliases, a, aliases);
		}
break;
case 44:
#line 393 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			free(host->cert_path);
			host->cert_path = yyvsp[0].v.string;
		}
break;
case 45:
#line 398 "parse.y"
{
			free(yyvsp[0].v.string);
			yyerror("`cgi' was removed in gmid 2.0."
			    "  Please use fastcgi or proxy instead.");
		}
break;
case 46:
#line 403 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			free(host->key_path);
			host->key_path = yyvsp[0].v.string;
		}
break;
case 47:
#line 408 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			free(host->ocsp_path);
			host->ocsp_path = yyvsp[0].v.string;
		}
break;
case 48:
#line 413 "parse.y"
{
			yywarn("the top-level `param' directive is deprecated."
			    "  Please use `fastcgi { param ... }`");
			add_param(yyvsp[-2].v.string, yyvsp[0].v.string);
		}
break;
case 49:
#line 418 "parse.y"
{
			listen_on(yyvsp[0].v.string, "1965");
			free(yyvsp[0].v.string);
		}
break;
case 50:
#line 422 "parse.y"
{
			listen_on(yyvsp[-2].v.string, yyvsp[0].v.string);
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 51:
#line 427 "parse.y"
{
			char portno[32];
			int r;

			r = snprintf(portno, sizeof(portno), "%d", yyvsp[0].v.number);
			if (r < 0 || (size_t)r >= sizeof(portno))
				fatal("snprintf");

			listen_on(yyvsp[-2].v.string, portno);
			free(yyvsp[-2].v.string);
		}
break;
case 53:
#line 441 "parse.y"
{ advance_proxy(); }
break;
case 54:
#line 442 "parse.y"
{
			if (*proxy->host == '\0')
				yyerror("invalid proxy block: missing `relay-to' option");

			if ((proxy->cert_path == NULL && proxy->key_path != NULL) ||
			    (proxy->cert_path != NULL && proxy->key_path == NULL))
				yyerror("invalid proxy block: missing cert or key");
		}
break;
case 57:
#line 456 "parse.y"
{ yyval.v.number = 1965; }
break;
case 58:
#line 457 "parse.y"
{
			if ((yyval.v.number = getservice(yyvsp[0].v.string)) == -1)
				yyerror("invalid port number %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 59:
#line 462 "parse.y"
{ yyval.v.number = yyvsp[0].v.number; }
break;
case 60:
#line 465 "parse.y"
{
			if (strlcpy(proxy->match_proto, yyvsp[0].v.string,
			    sizeof(proxy->match_proto))
			    >= sizeof(proxy->match_proto))
				yyerror("proto too long: %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 61:
#line 472 "parse.y"
{
			if (strlcpy(proxy->match_host, yyvsp[-1].v.string,
			    sizeof(proxy->match_host))
			    >= sizeof(proxy->match_host))
				yyerror("for-host too long: %s", yyvsp[-1].v.string);
			(void) snprintf(proxy->match_port, sizeof(proxy->match_port),
			    "%d", yyvsp[0].v.number);
			free(yyvsp[-1].v.string);
		}
break;
case 64:
#line 487 "parse.y"
{
			free(proxy->cert);
			ensure_absolute_path(yyvsp[0].v.string);
			proxy->cert_path = yyvsp[0].v.string;
		}
break;
case 65:
#line 492 "parse.y"
{
			free(proxy->key);
			ensure_absolute_path(yyvsp[0].v.string);
			proxy->key_path = yyvsp[0].v.string;
		}
break;
case 66:
#line 497 "parse.y"
{
			if (tls_config_parse_protocols(&proxy->protocols, yyvsp[0].v.string) == -1)
				yyerror("invalid protocols string \"%s\"", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 67:
#line 502 "parse.y"
{
			if (strlcpy(proxy->host, yyvsp[-1].v.string, sizeof(proxy->host))
			    >= sizeof(proxy->host))
				yyerror("relay-to host too long: %s", yyvsp[-1].v.string);
			(void) snprintf(proxy->port, sizeof(proxy->port),
			    "%d", yyvsp[0].v.number);
			free(yyvsp[-1].v.string);
		}
break;
case 68:
#line 510 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			proxy->reqca_path = yyvsp[0].v.string;
		}
break;
case 69:
#line 514 "parse.y"
{
			if (strlcpy(proxy->sni, yyvsp[0].v.string, sizeof(proxy->sni))
			    >= sizeof(proxy->sni))
				yyerror("sni hostname too long: %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 70:
#line 520 "parse.y"
{
			proxy->notls = !yyvsp[0].v.number;
		}
break;
case 71:
#line 523 "parse.y"
{
			proxy->noverifyname = !yyvsp[0].v.number;
		}
break;
case 72:
#line 528 "parse.y"
{ advance_loc(); }
break;
case 73:
#line 528 "parse.y"
{
			/* drop the starting '/' if any */
			if (*yyvsp[-4].v.string == '/')
				memmove(yyvsp[-4].v.string, yyvsp[-4].v.string+1, strlen(yyvsp[-4].v.string));
			if (strlcpy(loc->match, yyvsp[-4].v.string, sizeof(loc->match))
			    >= sizeof(loc->match))
				yyerror("location path too long: %s", yyvsp[-4].v.string);
			free(yyvsp[-4].v.string);
		}
break;
case 77:
#line 544 "parse.y"
{ loc->auto_index = yyvsp[0].v.number ? 1 : -1; }
break;
case 78:
#line 545 "parse.y"
{
			check_block_fmt(yyvsp[0].v.string);
			if (strlcpy(loc->block_fmt, yyvsp[0].v.string, sizeof(loc->block_fmt))
			    >= sizeof(loc->block_fmt))
				yyerror("block return meta too long: %s", yyvsp[0].v.string);
			loc->block_code = check_block_code(yyvsp[-1].v.number);
			free(yyvsp[0].v.string);
		}
break;
case 79:
#line 553 "parse.y"
{
			(void) strlcpy(loc->block_fmt, "temporary failure",
			    sizeof(loc->block_fmt));
			loc->block_code = check_block_code(yyvsp[0].v.number);
			if (yyvsp[0].v.number >= 30 && yyvsp[0].v.number < 40)
				yyerror("missing `meta' for block return %d", yyvsp[0].v.number);
		}
break;
case 80:
#line 560 "parse.y"
{
			(void) strlcpy(loc->block_fmt, "temporary failure",
			    sizeof(loc->block_fmt));
			loc->block_code = 40;
		}
break;
case 81:
#line 565 "parse.y"
{
			if (strlcpy(loc->default_mime, yyvsp[0].v.string,
			    sizeof(loc->default_mime))
			    >= sizeof(loc->default_mime))
				yyerror("default type too long: %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 83:
#line 573 "parse.y"
{
			if (strlcpy(loc->index, yyvsp[0].v.string, sizeof(loc->index))
			    >= sizeof(loc->index))
				yyerror("index string too long: %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 84:
#line 579 "parse.y"
{
			if (strlcpy(loc->lang, yyvsp[0].v.string, sizeof(loc->lang))
			    >= sizeof(loc->lang))
				yyerror("lang too long: %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 85:
#line 585 "parse.y"
{ loc->disable_log = !yyvsp[0].v.number; }
break;
case 86:
#line 586 "parse.y"
{
			ensure_absolute_path(yyvsp[0].v.string);
			loc->reqca_path = yyvsp[0].v.string;
		}
break;
case 87:
#line 590 "parse.y"
{
			if (strlcpy(loc->dir, yyvsp[0].v.string, sizeof(loc->dir))
			    >= sizeof(loc->dir))
				yyerror("root path too long: %s", yyvsp[0].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 88:
#line 596 "parse.y"
{ loc->strip = check_strip_no(yyvsp[0].v.number); }
break;
case 91:
#line 601 "parse.y"
{
			loc->fcgi = -1;
			loc->nofcgi = 1;
		}
break;
case 92:
#line 605 "parse.y"
{
			yywarn("`fastcgi path' is deprecated.  "
			    "Please use `fastcgi socket path' instead.");
			loc->fcgi = fastcgi_conf(yyvsp[0].v.string, NULL);
			free(yyvsp[0].v.string);
		}
break;
case 95:
#line 617 "parse.y"
{
			add_param(yyvsp[-2].v.string, yyvsp[0].v.string);
		}
break;
case 96:
#line 620 "parse.y"
{
			loc->fcgi = fastcgi_conf(yyvsp[0].v.string, NULL);
			free(yyvsp[0].v.string);
		}
break;
case 97:
#line 624 "parse.y"
{
			char *c;

			if (asprintf(&c, "%d", yyvsp[0].v.number) == -1)
				fatal("asprintf");
			loc->fcgi = fastcgi_conf(yyvsp[-2].v.string, c);
			free(yyvsp[-2].v.string);
			free(c);
		}
break;
case 98:
#line 633 "parse.y"
{
			loc->fcgi = fastcgi_conf(yyvsp[0].v.string, "9000");
		}
break;
case 99:
#line 636 "parse.y"
{
			loc->fcgi = fastcgi_conf(yyvsp[-2].v.string, yyvsp[0].v.string);
			free(yyvsp[-2].v.string);
			free(yyvsp[0].v.string);
		}
break;
case 100:
#line 641 "parse.y"
{
			loc->fcgi_strip = yyvsp[0].v.number;
		}
break;
case 104:
#line 652 "parse.y"
{
			free(current_media);
			current_media = yyvsp[0].v.string;
		}
break;
case 109:
#line 663 "parse.y"
{
			if (add_mime(&conf->mime, current_media, yyvsp[0].v.string) == -1)
				fatal("add_mime");
			free(yyvsp[0].v.string);
		}
break;
#line 2309 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yysslim && yygrowstack())
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (1);
yyaccept:
    if (yyss)
            free(yyss);
    if (yyvs)
            free(yyvs);
    yyss = yyssp = NULL;
    yyvs = yyvsp = NULL;
    yystacksize = 0;
    return (0);
}
