/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebTransportErrorOptions.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSWebTransportErrorSource.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<WebTransportErrorOptions>> convertDictionary<WebTransportErrorOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    WebTransportErrorOptions result;
    JSValue sourceValue;
    if (isNullOrUndefined)
        sourceValue = jsUndefined();
    else {
        sourceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "source"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto sourceConversionResult = convertOptionalWithDefault<IDLEnumeration<WebTransportErrorSource>>(lexicalGlobalObject, sourceValue, [&]() -> ConversionResult<IDLEnumeration<WebTransportErrorSource>> { return Converter<IDLEnumeration<WebTransportErrorSource>>::ReturnType { WebTransportErrorSource::Stream }; });
    if (UNLIKELY(sourceConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.source = sourceConversionResult.releaseReturnValue();
    JSValue streamErrorCodeValue;
    if (isNullOrUndefined)
        streamErrorCodeValue = jsUndefined();
    else {
        streamErrorCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "streamErrorCode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto streamErrorCodeConversionResult = convertOptionalWithDefault<IDLNullable<IDLClampAdaptor<IDLUnsignedLong>>>(lexicalGlobalObject, streamErrorCodeValue, [&]() -> ConversionResult<IDLNullable<IDLClampAdaptor<IDLUnsignedLong>>> { return typename Converter<IDLNullable<IDLClampAdaptor<IDLUnsignedLong>>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(streamErrorCodeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.streamErrorCode = streamErrorCodeConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
