/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoTransferCharacteristics.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(VideoTransferCharacteristics enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("bt709"),
        MAKE_STATIC_STRING_IMPL("smpte170m"),
        MAKE_STATIC_STRING_IMPL("iec61966-2-1"),
        MAKE_STATIC_STRING_IMPL("gamma22curve"),
        MAKE_STATIC_STRING_IMPL("gamma28curve"),
        MAKE_STATIC_STRING_IMPL("smpte240m"),
        MAKE_STATIC_STRING_IMPL("linear"),
        MAKE_STATIC_STRING_IMPL("log"),
        MAKE_STATIC_STRING_IMPL("logSqrt"),
        MAKE_STATIC_STRING_IMPL("iec6196624"),
        MAKE_STATIC_STRING_IMPL("bt1361ExtendedColourGamut"),
        MAKE_STATIC_STRING_IMPL("bt2020_10bit"),
        MAKE_STATIC_STRING_IMPL("bt2020_12bit"),
        MAKE_STATIC_STRING_IMPL("pq"),
        MAKE_STATIC_STRING_IMPL("smpteSt4281"),
        MAKE_STATIC_STRING_IMPL("hlg"),
        MAKE_STATIC_STRING_IMPL("unspecified"),
    };
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Bt709) == 0, "VideoTransferCharacteristics::Bt709 is not 0 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Smpte170m) == 1, "VideoTransferCharacteristics::Smpte170m is not 1 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Iec6196621) == 2, "VideoTransferCharacteristics::Iec6196621 is not 2 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Gamma22curve) == 3, "VideoTransferCharacteristics::Gamma22curve is not 3 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Gamma28curve) == 4, "VideoTransferCharacteristics::Gamma28curve is not 4 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Smpte240m) == 5, "VideoTransferCharacteristics::Smpte240m is not 5 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Linear) == 6, "VideoTransferCharacteristics::Linear is not 6 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Log) == 7, "VideoTransferCharacteristics::Log is not 7 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::LogSqrt) == 8, "VideoTransferCharacteristics::LogSqrt is not 8 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Iec6196624) == 9, "VideoTransferCharacteristics::Iec6196624 is not 9 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Bt1361ExtendedColourGamut) == 10, "VideoTransferCharacteristics::Bt1361ExtendedColourGamut is not 10 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Bt2020_10bit) == 11, "VideoTransferCharacteristics::Bt2020_10bit is not 11 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Bt2020_12bit) == 12, "VideoTransferCharacteristics::Bt2020_12bit is not 12 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::PQ) == 13, "VideoTransferCharacteristics::PQ is not 13 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::SmpteSt4281) == 14, "VideoTransferCharacteristics::SmpteSt4281 is not 14 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::HLG) == 15, "VideoTransferCharacteristics::HLG is not 15 as expected");
    static_assert(static_cast<size_t>(VideoTransferCharacteristics::Unspecified) == 16, "VideoTransferCharacteristics::Unspecified is not 16 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, VideoTransferCharacteristics enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<VideoTransferCharacteristics> parseEnumerationFromString<VideoTransferCharacteristics>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, VideoTransferCharacteristics> mappings[] = {
        { "bt1361ExtendedColourGamut", VideoTransferCharacteristics::Bt1361ExtendedColourGamut },
        { "bt2020_10bit", VideoTransferCharacteristics::Bt2020_10bit },
        { "bt2020_12bit", VideoTransferCharacteristics::Bt2020_12bit },
        { "bt709", VideoTransferCharacteristics::Bt709 },
        { "gamma22curve", VideoTransferCharacteristics::Gamma22curve },
        { "gamma28curve", VideoTransferCharacteristics::Gamma28curve },
        { "hlg", VideoTransferCharacteristics::HLG },
        { "iec61966-2-1", VideoTransferCharacteristics::Iec6196621 },
        { "iec6196624", VideoTransferCharacteristics::Iec6196624 },
        { "linear", VideoTransferCharacteristics::Linear },
        { "log", VideoTransferCharacteristics::Log },
        { "logSqrt", VideoTransferCharacteristics::LogSqrt },
        { "pq", VideoTransferCharacteristics::PQ },
        { "smpte170m", VideoTransferCharacteristics::Smpte170m },
        { "smpte240m", VideoTransferCharacteristics::Smpte240m },
        { "smpteSt4281", VideoTransferCharacteristics::SmpteSt4281 },
        { "unspecified", VideoTransferCharacteristics::Unspecified },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<VideoTransferCharacteristics> parseEnumeration<VideoTransferCharacteristics>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<VideoTransferCharacteristics>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<VideoTransferCharacteristics>()
{
    return "\"bt709\", \"smpte170m\", \"iec61966-2-1\", \"gamma22curve\", \"gamma28curve\", \"smpte240m\", \"linear\", \"log\", \"logSqrt\", \"iec6196624\", \"bt1361ExtendedColourGamut\", \"bt2020_10bit\", \"bt2020_12bit\", \"pq\", \"smpteSt4281\", \"hlg\", \"unspecified\""_s;
}

} // namespace WebCore

#endif // ENABLE(VIDEO)
