/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoColorSpace.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSVideoColorPrimaries.h"
#include "JSVideoColorSpaceInit.h"
#include "JSVideoMatrixCoefficients.h"
#include "JSVideoTransferCharacteristics.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsVideoColorSpacePrototypeFunction_toJSON);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsVideoColorSpaceConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoColorSpace_primaries);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoColorSpace_transfer);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoColorSpace_matrix);
static JSC_DECLARE_CUSTOM_GETTER(jsVideoColorSpace_fullRange);

class JSVideoColorSpacePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSVideoColorSpacePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSVideoColorSpacePrototype* ptr = new (NotNull, JSC::allocateCell<JSVideoColorSpacePrototype>(vm)) JSVideoColorSpacePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoColorSpacePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSVideoColorSpacePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSVideoColorSpacePrototype, JSVideoColorSpacePrototype::Base);

using JSVideoColorSpaceDOMConstructor = JSDOMConstructor<JSVideoColorSpace>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSVideoColorSpaceDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSVideoColorSpaceDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto initConversionResult = convert<IDLDictionary<VideoColorSpaceInit>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(initConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = VideoColorSpace::create(initConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<VideoColorSpace>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<VideoColorSpace>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSVideoColorSpaceDOMConstructorConstruct, JSVideoColorSpaceDOMConstructor::construct);

template<> const ClassInfo JSVideoColorSpaceDOMConstructor::s_info = { "VideoColorSpace"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoColorSpaceDOMConstructor) };

template<> JSValue JSVideoColorSpaceDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSVideoColorSpaceDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "VideoColorSpace"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSVideoColorSpace::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSVideoColorSpacePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoColorSpaceConstructor, 0 } },
    { "primaries"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoColorSpace_primaries, 0 } },
    { "transfer"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoColorSpace_transfer, 0 } },
    { "matrix"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoColorSpace_matrix, 0 } },
    { "fullRange"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsVideoColorSpace_fullRange, 0 } },
    { "toJSON"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsVideoColorSpacePrototypeFunction_toJSON, 0 } },
};

const ClassInfo JSVideoColorSpacePrototype::s_info = { "VideoColorSpace"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoColorSpacePrototype) };

void JSVideoColorSpacePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSVideoColorSpace::info(), JSVideoColorSpacePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSVideoColorSpace::s_info = { "VideoColorSpace"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSVideoColorSpace) };

JSVideoColorSpace::JSVideoColorSpace(Structure* structure, JSDOMGlobalObject& globalObject, Ref<VideoColorSpace>&& impl)
    : JSDOMWrapper<VideoColorSpace>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, VideoColorSpace>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSVideoColorSpace::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSVideoColorSpacePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSVideoColorSpacePrototype::create(vm, &globalObject, structure);
}

JSObject* JSVideoColorSpace::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSVideoColorSpace>(vm, globalObject);
}

JSValue JSVideoColorSpace::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSVideoColorSpaceDOMConstructor, DOMConstructorID::VideoColorSpace>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSVideoColorSpace::destroy(JSC::JSCell* cell)
{
    JSVideoColorSpace* thisObject = static_cast<JSVideoColorSpace*>(cell);
    thisObject->JSVideoColorSpace::~JSVideoColorSpace();
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoColorSpaceConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSVideoColorSpacePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSVideoColorSpace::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsVideoColorSpace_primariesGetter(JSGlobalObject& lexicalGlobalObject, JSVideoColorSpace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLEnumeration<VideoColorPrimaries>>>(lexicalGlobalObject, throwScope, impl.primaries())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoColorSpace_primaries, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoColorSpace>::get<jsVideoColorSpace_primariesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoColorSpace_transferGetter(JSGlobalObject& lexicalGlobalObject, JSVideoColorSpace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLEnumeration<VideoTransferCharacteristics>>>(lexicalGlobalObject, throwScope, impl.transfer())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoColorSpace_transfer, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoColorSpace>::get<jsVideoColorSpace_transferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoColorSpace_matrixGetter(JSGlobalObject& lexicalGlobalObject, JSVideoColorSpace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLEnumeration<VideoMatrixCoefficients>>>(lexicalGlobalObject, throwScope, impl.matrix())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoColorSpace_matrix, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoColorSpace>::get<jsVideoColorSpace_matrixGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsVideoColorSpace_fullRangeGetter(JSGlobalObject& lexicalGlobalObject, JSVideoColorSpace& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, impl.fullRange())));
}

JSC_DEFINE_CUSTOM_GETTER(jsVideoColorSpace_fullRange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSVideoColorSpace>::get<jsVideoColorSpace_fullRangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline EncodedJSValue jsVideoColorSpacePrototypeFunction_toJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSVideoColorSpace* castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* result = constructEmptyObject(lexicalGlobalObject);
    auto primariesValue = toJS<IDLNullable<IDLEnumeration<VideoColorPrimaries>>>(*lexicalGlobalObject, throwScope, impl.primaries());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "primaries"_s), primariesValue);
    auto transferValue = toJS<IDLNullable<IDLEnumeration<VideoTransferCharacteristics>>>(*lexicalGlobalObject, throwScope, impl.transfer());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "transfer"_s), transferValue);
    auto matrixValue = toJS<IDLNullable<IDLEnumeration<VideoMatrixCoefficients>>>(*lexicalGlobalObject, throwScope, impl.matrix());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "matrix"_s), matrixValue);
    auto fullRangeValue = toJS<IDLNullable<IDLBoolean>>(*lexicalGlobalObject, throwScope, impl.fullRange());
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, Identifier::fromString(vm, "fullRange"_s), fullRangeValue);
    return JSValue::encode(result);
}

JSC_DEFINE_HOST_FUNCTION(jsVideoColorSpacePrototypeFunction_toJSON, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSVideoColorSpace>::call<jsVideoColorSpacePrototypeFunction_toJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

JSC::GCClient::IsoSubspace* JSVideoColorSpace::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSVideoColorSpace, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForVideoColorSpace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForVideoColorSpace = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForVideoColorSpace.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForVideoColorSpace = std::forward<decltype(space)>(space); }
    );
}

void JSVideoColorSpace::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSVideoColorSpace*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSVideoColorSpaceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSVideoColorSpaceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsVideoColorSpace = static_cast<JSVideoColorSpace*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsVideoColorSpace->protectedWrapped().ptr(), jsVideoColorSpace);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7VideoColorSpace@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore15VideoColorSpaceE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, VideoColorSpace>, void>> static inline void verifyVTable(VideoColorSpace* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7VideoColorSpace@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore15VideoColorSpaceE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // VideoColorSpace has subclasses. If VideoColorSpace has subclasses that get passed
        // to toJS() we currently require VideoColorSpace you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<VideoColorSpace>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<VideoColorSpace>(impl.ptr());
#endif
    return createWrapper<VideoColorSpace>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, VideoColorSpace& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

VideoColorSpace* JSVideoColorSpace::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSVideoColorSpace*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
