/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSRsaPssParams.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CryptoAlgorithmRsaPssParams>> convertDictionary<CryptoAlgorithmRsaPssParams>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CryptoAlgorithmRsaPssParams result;
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (nameValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "name"_s, "RsaPssParams"_s, "DOMString"_s);
        return ConversionResultException { };
    }
    auto nameConversionResult = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
    if (UNLIKELY(nameConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.name = nameConversionResult.releaseReturnValue();
    JSValue saltLengthValue;
    if (isNullOrUndefined)
        saltLengthValue = jsUndefined();
    else {
        saltLengthValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "saltLength"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (saltLengthValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "saltLength"_s, "RsaPssParams"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto saltLengthConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, saltLengthValue);
    if (UNLIKELY(saltLengthConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.saltLength = saltLengthConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
