/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMouseEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventTarget.h"
#include "JSMouseEventInit.h"
#include "JSNode.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsMouseEventPrototypeFunction_getModifierState);
static JSC_DECLARE_HOST_FUNCTION(jsMouseEventPrototypeFunction_initMouseEvent);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMouseEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_screenX);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_screenY);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_clientX);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_clientY);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_ctrlKey);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_shiftKey);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_altKey);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_metaKey);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_button);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_buttons);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_relatedTarget);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_movementX);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_movementY);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_webkitForce);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_offsetX);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_offsetY);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_x);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_y);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_fromElement);
static JSC_DECLARE_CUSTOM_GETTER(jsMouseEvent_toElement);

class JSMouseEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMouseEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMouseEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSMouseEventPrototype>(vm)) JSMouseEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMouseEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMouseEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMouseEventPrototype, JSMouseEventPrototype::Base);

using JSMouseEventDOMConstructor = JSDOMConstructor<JSMouseEvent>;

/* Hash table for constructor */

static const HashTableValue JSMouseEventConstructorTableValues[] =
{
    { "WEBKIT_FORCE_AT_MOUSE_DOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "WEBKIT_FORCE_AT_FORCE_MOUSE_DOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSMouseEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSMouseEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto eventInitDictConversionResult = convert<IDLDictionary<MouseEventInit>>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(eventInitDictConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = MouseEvent::create(typeConversionResult.releaseReturnValue(), eventInitDictConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<MouseEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<MouseEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSMouseEventDOMConstructorConstruct, JSMouseEventDOMConstructor::construct);

template<> const ClassInfo JSMouseEventDOMConstructor::s_info = { "MouseEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMouseEventDOMConstructor) };

template<> JSValue JSMouseEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSMouseEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MouseEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMouseEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSMouseEvent::info(), JSMouseEventConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSMouseEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEventConstructor, 0 } },
    { "screenX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_screenX, 0 } },
    { "screenY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_screenY, 0 } },
    { "clientX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_clientX, 0 } },
    { "clientY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_clientY, 0 } },
    { "ctrlKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_ctrlKey, 0 } },
    { "shiftKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_shiftKey, 0 } },
    { "altKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_altKey, 0 } },
    { "metaKey"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_metaKey, 0 } },
    { "button"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_button, 0 } },
    { "buttons"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_buttons, 0 } },
    { "relatedTarget"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_relatedTarget, 0 } },
    { "movementX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_movementX, 0 } },
    { "movementY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_movementY, 0 } },
    { "webkitForce"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_webkitForce, 0 } },
    { "offsetX"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_offsetX, 0 } },
    { "offsetY"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_offsetY, 0 } },
    { "x"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_x, 0 } },
    { "y"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_y, 0 } },
    { "fromElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_fromElement, 0 } },
    { "toElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsMouseEvent_toElement, 0 } },
    { "getModifierState"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMouseEventPrototypeFunction_getModifierState, 1 } },
    { "initMouseEvent"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsMouseEventPrototypeFunction_initMouseEvent, 1 } },
    { "WEBKIT_FORCE_AT_MOUSE_DOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "WEBKIT_FORCE_AT_FORCE_MOUSE_DOWN"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
};

const ClassInfo JSMouseEventPrototype::s_info = { "MouseEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMouseEventPrototype) };

void JSMouseEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMouseEvent::info(), JSMouseEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMouseEvent::s_info = { "MouseEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMouseEvent) };

JSMouseEvent::JSMouseEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MouseEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

Ref<MouseEvent> JSMouseEvent::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, MouseEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSMouseEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMouseEventPrototype::createStructure(vm, &globalObject, JSUIEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMouseEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMouseEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMouseEvent>(vm, globalObject);
}

JSValue JSMouseEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMouseEventDOMConstructor, DOMConstructorID::MouseEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMouseEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMouseEvent::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsMouseEvent_screenXGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.screenX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_screenX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_screenXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_screenYGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.screenY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_screenY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_screenYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_clientXGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.clientX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_clientX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_clientXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_clientYGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.clientY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_clientY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_clientYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_ctrlKeyGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ctrlKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_ctrlKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_ctrlKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_shiftKeyGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.shiftKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_shiftKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_shiftKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_altKeyGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.altKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_altKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_altKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_metaKeyGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.metaKey())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_metaKey, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_metaKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_buttonGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLShort>(lexicalGlobalObject, throwScope, impl.buttonAsShort())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_button, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_buttonGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_buttonsGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.buttons())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_buttons, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_buttonsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_relatedTargetGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<EventTarget>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.relatedTarget())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_relatedTarget, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_relatedTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_movementXGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.movementX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_movementX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_movementXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_movementYGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.movementY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_movementY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_movementYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_webkitForceGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.force())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_webkitForce, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_webkitForceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_offsetXGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.offsetX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_offsetX, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_offsetXGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_offsetYGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.offsetY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_offsetY, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_offsetYGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_xGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.clientX())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_yGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.clientY())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_fromElementGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.fromElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_fromElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_fromElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsMouseEvent_toElementGetter(JSGlobalObject& lexicalGlobalObject, JSMouseEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.toElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsMouseEvent_toElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSMouseEvent>::get<jsMouseEvent_toElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsMouseEventPrototypeFunction_getModifierStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMouseEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto keyArgConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(keyArgConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.getModifierState(keyArgConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsMouseEventPrototypeFunction_getModifierState, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMouseEvent>::call<jsMouseEventPrototypeFunction_getModifierStateBody>(*lexicalGlobalObject, *callFrame, "getModifierState");
}

static inline JSC::EncodedJSValue jsMouseEventPrototypeFunction_initMouseEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMouseEvent>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto typeConversionResult = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(typeConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto canBubbleConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(canBubbleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto cancelableConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(cancelableConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument3 = callFrame->argument(3);
    auto viewConversionResult = convert<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, argument3.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 3, "view"_s, "MouseEvent"_s, "initMouseEvent"_s, "WindowProxy"_s); });
    if (UNLIKELY(viewConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument4 = callFrame->argument(4);
    auto detailConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument4.value());
    if (UNLIKELY(detailConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument5 = callFrame->argument(5);
    auto screenXConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument5.value());
    if (UNLIKELY(screenXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument6 = callFrame->argument(6);
    auto screenYConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument6.value());
    if (UNLIKELY(screenYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument7 = callFrame->argument(7);
    auto clientXConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument7.value());
    if (UNLIKELY(clientXConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument8 = callFrame->argument(8);
    auto clientYConversionResult = convert<IDLLong>(*lexicalGlobalObject, argument8.value());
    if (UNLIKELY(clientYConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument9 = callFrame->argument(9);
    auto ctrlKeyConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument9.value());
    if (UNLIKELY(ctrlKeyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument10 = callFrame->argument(10);
    auto altKeyConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument10.value());
    if (UNLIKELY(altKeyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument11 = callFrame->argument(11);
    auto shiftKeyConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument11.value());
    if (UNLIKELY(shiftKeyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument12 = callFrame->argument(12);
    auto metaKeyConversionResult = convert<IDLBoolean>(*lexicalGlobalObject, argument12.value());
    if (UNLIKELY(metaKeyConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument13 = callFrame->argument(13);
    auto buttonConversionResult = convert<IDLShort>(*lexicalGlobalObject, argument13.value());
    if (UNLIKELY(buttonConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument14 = callFrame->argument(14);
    auto relatedTargetConversionResult = convert<IDLNullable<IDLInterface<EventTarget>>>(*lexicalGlobalObject, argument14.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 14, "relatedTarget"_s, "MouseEvent"_s, "initMouseEvent"_s, "EventTarget"_s); });
    if (UNLIKELY(relatedTargetConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.initMouseEvent(typeConversionResult.releaseReturnValue(), canBubbleConversionResult.releaseReturnValue(), cancelableConversionResult.releaseReturnValue(), viewConversionResult.releaseReturnValue(), detailConversionResult.releaseReturnValue(), screenXConversionResult.releaseReturnValue(), screenYConversionResult.releaseReturnValue(), clientXConversionResult.releaseReturnValue(), clientYConversionResult.releaseReturnValue(), ctrlKeyConversionResult.releaseReturnValue(), altKeyConversionResult.releaseReturnValue(), shiftKeyConversionResult.releaseReturnValue(), metaKeyConversionResult.releaseReturnValue(), buttonConversionResult.releaseReturnValue(), relatedTargetConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsMouseEventPrototypeFunction_initMouseEvent, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSMouseEvent>::call<jsMouseEventPrototypeFunction_initMouseEventBody>(*lexicalGlobalObject, *callFrame, "initMouseEvent");
}

JSC::GCClient::IsoSubspace* JSMouseEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMouseEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMouseEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMouseEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMouseEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMouseEvent = std::forward<decltype(space)>(space); }
    );
}

void JSMouseEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMouseEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MouseEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10MouseEventE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, MouseEvent>, void>> static inline void verifyVTable(MouseEvent* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7MouseEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10MouseEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // MouseEvent has subclasses. If MouseEvent has subclasses that get passed
        // to toJS() we currently require MouseEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MouseEvent>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<MouseEvent>(impl.ptr());
#endif
    return createWrapper<MouseEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MouseEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
