/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MATHML)

#include "JSMathMLMathElement.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsMathMLMathElementConstructor);

class JSMathMLMathElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMathMLMathElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMathMLMathElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSMathMLMathElementPrototype>(vm)) JSMathMLMathElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMathMLMathElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMathMLMathElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMathMLMathElementPrototype, JSMathMLMathElementPrototype::Base);

using JSMathMLMathElementDOMConstructor = JSDOMConstructorNotConstructable<JSMathMLMathElement>;

template<> const ClassInfo JSMathMLMathElementDOMConstructor::s_info = { "MathMLMathElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMathMLMathElementDOMConstructor) };

template<> JSValue JSMathMLMathElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSMathMLElement::getConstructor(vm, &globalObject);
}

template<> void JSMathMLMathElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "MathMLMathElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSMathMLMathElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSMathMLMathElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsMathMLMathElementConstructor, 0 } },
};

const ClassInfo JSMathMLMathElementPrototype::s_info = { "MathMLMathElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMathMLMathElementPrototype) };

void JSMathMLMathElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMathMLMathElement::info(), JSMathMLMathElementPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSMathMLMathElement::s_info = { "MathMLMathElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMathMLMathElement) };

JSMathMLMathElement::JSMathMLMathElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MathMLMathElement>&& impl)
    : JSMathMLElement(structure, globalObject, WTFMove(impl))
{
}

Ref<MathMLMathElement> JSMathMLMathElement::protectedWrapped() const
{
    return wrapped();
}

JSObject* JSMathMLMathElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSMathMLMathElementPrototype::createStructure(vm, &globalObject, JSMathMLElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSMathMLMathElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSMathMLMathElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMathMLMathElement>(vm, globalObject);
}

JSValue JSMathMLMathElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMathMLMathElementDOMConstructor, DOMConstructorID::MathMLMathElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsMathMLMathElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMathMLMathElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMathMLMathElement::getConstructor(vm, prototype->globalObject()));
}

JSC::GCClient::IsoSubspace* JSMathMLMathElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSMathMLMathElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForMathMLMathElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForMathMLMathElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForMathMLMathElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForMathMLMathElement = std::forward<decltype(space)>(space); }
    );
}

void JSMathMLMathElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMathMLMathElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}


}

#endif // ENABLE(MATHML)
