/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUVertexAttribute.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSGPUVertexFormat.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUVertexAttribute>> convertDictionary<GPUVertexAttribute>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUVertexAttribute result;
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (formatValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format"_s, "GPUVertexAttribute"_s, "GPUVertexFormat"_s);
        return ConversionResultException { };
    }
    auto formatConversionResult = convert<IDLEnumeration<GPUVertexFormat>>(lexicalGlobalObject, formatValue);
    if (UNLIKELY(formatConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.format = formatConversionResult.releaseReturnValue();
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (offsetValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "offset"_s, "GPUVertexAttribute"_s, "unsigned long long"_s);
        return ConversionResultException { };
    }
    auto offsetConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLongLong>>(lexicalGlobalObject, offsetValue);
    if (UNLIKELY(offsetConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.offset = offsetConversionResult.releaseReturnValue();
    JSValue shaderLocationValue;
    if (isNullOrUndefined)
        shaderLocationValue = jsUndefined();
    else {
        shaderLocationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shaderLocation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (shaderLocationValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "shaderLocation"_s, "GPUVertexAttribute"_s, "unsigned long"_s);
        return ConversionResultException { };
    }
    auto shaderLocationConversionResult = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, shaderLocationValue);
    if (UNLIKELY(shaderLocationConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.shaderLocation = shaderLocationConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
