/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUCompilationInfo.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUCompilationMessage.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUCompilationInfoConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUCompilationInfo_messages);

class JSGPUCompilationInfoPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUCompilationInfoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUCompilationInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUCompilationInfoPrototype>(vm)) JSGPUCompilationInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUCompilationInfoPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUCompilationInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUCompilationInfoPrototype, JSGPUCompilationInfoPrototype::Base);

using JSGPUCompilationInfoDOMConstructor = JSDOMConstructorNotConstructable<JSGPUCompilationInfo>;

template<> const ClassInfo JSGPUCompilationInfoDOMConstructor::s_info = { "GPUCompilationInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCompilationInfoDOMConstructor) };

template<> JSValue JSGPUCompilationInfoDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUCompilationInfoDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUCompilationInfo"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUCompilationInfo::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUCompilationInfoPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCompilationInfoConstructor, 0 } },
    { "messages"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUCompilationInfo_messages, 0 } },
};

const ClassInfo JSGPUCompilationInfoPrototype::s_info = { "GPUCompilationInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCompilationInfoPrototype) };

void JSGPUCompilationInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUCompilationInfo::info(), JSGPUCompilationInfoPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUCompilationInfo::s_info = { "GPUCompilationInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCompilationInfo) };

JSGPUCompilationInfo::JSGPUCompilationInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUCompilationInfo>&& impl)
    : JSDOMWrapper<GPUCompilationInfo>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUCompilationInfo>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUCompilationInfo::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUCompilationInfoPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUCompilationInfoPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUCompilationInfo::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUCompilationInfo>(vm, globalObject);
}

JSValue JSGPUCompilationInfo::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUCompilationInfoDOMConstructor, DOMConstructorID::GPUCompilationInfo>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUCompilationInfo::destroy(JSC::JSCell* cell)
{
    JSGPUCompilationInfo* thisObject = static_cast<JSGPUCompilationInfo*>(cell);
    thisObject->JSGPUCompilationInfo::~JSGPUCompilationInfo();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCompilationInfoConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUCompilationInfoPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUCompilationInfo::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsGPUCompilationInfo_messagesGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCompilationInfo& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFrozenArray<IDLInterface<GPUCompilationMessage>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.messages())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUCompilationInfo_messages, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUCompilationInfo>::get<jsGPUCompilationInfo_messagesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSGPUCompilationInfo::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUCompilationInfo, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUCompilationInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUCompilationInfo = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUCompilationInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUCompilationInfo = std::forward<decltype(space)>(space); }
    );
}

void JSGPUCompilationInfo::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUCompilationInfo*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUCompilationInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUCompilationInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUCompilationInfo = static_cast<JSGPUCompilationInfo*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsGPUCompilationInfo->protectedWrapped().ptr(), jsGPUCompilationInfo);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUCompilationInfo@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18GPUCompilationInfoE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, GPUCompilationInfo>, void>> static inline void verifyVTable(GPUCompilationInfo* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUCompilationInfo@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18GPUCompilationInfoE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUCompilationInfo has subclasses. If GPUCompilationInfo has subclasses that get passed
        // to toJS() we currently require GPUCompilationInfo you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUCompilationInfo>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<GPUCompilationInfo>(impl.ptr());
#endif
    return createWrapper<GPUCompilationInfo>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUCompilationInfo& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUCompilationInfo* JSGPUCompilationInfo::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUCompilationInfo*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
