/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBlendComponent.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertOptional.h"
#include "JSGPUBlendFactor.h"
#include "JSGPUBlendOperation.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUBlendComponent>> convertDictionary<GPUBlendComponent>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUBlendComponent result;
    JSValue dstFactorValue;
    if (isNullOrUndefined)
        dstFactorValue = jsUndefined();
    else {
        dstFactorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dstFactor"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto dstFactorConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUBlendFactor>>(lexicalGlobalObject, dstFactorValue, [&]() -> ConversionResult<IDLEnumeration<GPUBlendFactor>> { return Converter<IDLEnumeration<GPUBlendFactor>>::ReturnType { GPUBlendFactor::Zero }; });
    if (UNLIKELY(dstFactorConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.dstFactor = dstFactorConversionResult.releaseReturnValue();
    JSValue operationValue;
    if (isNullOrUndefined)
        operationValue = jsUndefined();
    else {
        operationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "operation"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto operationConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUBlendOperation>>(lexicalGlobalObject, operationValue, [&]() -> ConversionResult<IDLEnumeration<GPUBlendOperation>> { return Converter<IDLEnumeration<GPUBlendOperation>>::ReturnType { GPUBlendOperation::Add }; });
    if (UNLIKELY(operationConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.operation = operationConversionResult.releaseReturnValue();
    JSValue srcFactorValue;
    if (isNullOrUndefined)
        srcFactorValue = jsUndefined();
    else {
        srcFactorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "srcFactor"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto srcFactorConversionResult = convertOptionalWithDefault<IDLEnumeration<GPUBlendFactor>>(lexicalGlobalObject, srcFactorValue, [&]() -> ConversionResult<IDLEnumeration<GPUBlendFactor>> { return Converter<IDLEnumeration<GPUBlendFactor>>::ReturnType { GPUBlendFactor::One }; });
    if (UNLIKELY(srcFactorConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.srcFactor = srcFactorConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore
