/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSEXTTextureCompressionRGTC.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

class JSEXTTextureCompressionRGTCPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSEXTTextureCompressionRGTCPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSEXTTextureCompressionRGTCPrototype* ptr = new (NotNull, JSC::allocateCell<JSEXTTextureCompressionRGTCPrototype>(vm)) JSEXTTextureCompressionRGTCPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureCompressionRGTCPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSEXTTextureCompressionRGTCPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSEXTTextureCompressionRGTCPrototype, JSEXTTextureCompressionRGTCPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSEXTTextureCompressionRGTCPrototypeTableValues[] =
{
    { "COMPRESSED_RED_RGTC1_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DBB } },
    { "COMPRESSED_SIGNED_RED_RGTC1_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DBC } },
    { "COMPRESSED_RED_GREEN_RGTC2_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DBD } },
    { "COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x8DBE } },
};

const ClassInfo JSEXTTextureCompressionRGTCPrototype::s_info = { "EXTTextureCompressionRGTC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureCompressionRGTCPrototype) };

void JSEXTTextureCompressionRGTCPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSEXTTextureCompressionRGTC::info(), JSEXTTextureCompressionRGTCPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSEXTTextureCompressionRGTC::s_info = { "EXTTextureCompressionRGTC"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSEXTTextureCompressionRGTC) };

JSEXTTextureCompressionRGTC::JSEXTTextureCompressionRGTC(Structure* structure, JSDOMGlobalObject& globalObject, Ref<EXTTextureCompressionRGTC>&& impl)
    : JSDOMWrapper<EXTTextureCompressionRGTC>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, EXTTextureCompressionRGTC>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSEXTTextureCompressionRGTC::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSEXTTextureCompressionRGTCPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSEXTTextureCompressionRGTCPrototype::create(vm, &globalObject, structure);
}

JSObject* JSEXTTextureCompressionRGTC::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSEXTTextureCompressionRGTC>(vm, globalObject);
}

void JSEXTTextureCompressionRGTC::destroy(JSC::JSCell* cell)
{
    JSEXTTextureCompressionRGTC* thisObject = static_cast<JSEXTTextureCompressionRGTC*>(cell);
    thisObject->JSEXTTextureCompressionRGTC::~JSEXTTextureCompressionRGTC();
}

JSC::GCClient::IsoSubspace* JSEXTTextureCompressionRGTC::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSEXTTextureCompressionRGTC, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForEXTTextureCompressionRGTC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForEXTTextureCompressionRGTC = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForEXTTextureCompressionRGTC.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForEXTTextureCompressionRGTC = std::forward<decltype(space)>(space); }
    );
}

void JSEXTTextureCompressionRGTC::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSEXTTextureCompressionRGTC*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSEXTTextureCompressionRGTCOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsEXTTextureCompressionRGTC = jsCast<JSEXTTextureCompressionRGTC*>(handle.slot()->asCell());
    auto& owner = jsEXTTextureCompressionRGTC->wrapped();
    if (UNLIKELY(reason))
        *reason = "Reachable from jsEXTTextureCompressionRGTC"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSEXTTextureCompressionRGTCOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsEXTTextureCompressionRGTC = static_cast<JSEXTTextureCompressionRGTC*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsEXTTextureCompressionRGTC->protectedWrapped().ptr(), jsEXTTextureCompressionRGTC);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7EXTTextureCompressionRGTC@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore25EXTTextureCompressionRGTCE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, EXTTextureCompressionRGTC>, void>> static inline void verifyVTable(EXTTextureCompressionRGTC* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7EXTTextureCompressionRGTC@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore25EXTTextureCompressionRGTCE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // EXTTextureCompressionRGTC has subclasses. If EXTTextureCompressionRGTC has subclasses that get passed
        // to toJS() we currently require EXTTextureCompressionRGTC you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<EXTTextureCompressionRGTC>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<EXTTextureCompressionRGTC>(impl.ptr());
#endif
    return createWrapper<EXTTextureCompressionRGTC>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, EXTTextureCompressionRGTC& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

EXTTextureCompressionRGTC* JSEXTTextureCompressionRGTC::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSEXTTextureCompressionRGTC*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
