/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleSheet.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSCSSRule.h"
#include "JSCSSRuleList.h"
#include "JSCSSStyleSheet.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <variant>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<CSSStyleSheet::Init>> convertDictionary<CSSStyleSheet::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    CSSStyleSheet::Init result;
    JSValue baseURLValue;
    if (isNullOrUndefined)
        baseURLValue = jsUndefined();
    else {
        baseURLValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "baseURL"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto baseURLConversionResult = convertOptionalWithDefault<IDLDOMString>(lexicalGlobalObject, baseURLValue, [&]() -> ConversionResult<IDLDOMString> { return typename Converter<IDLDOMString>::ReturnType { String() }; });
    if (UNLIKELY(baseURLConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.baseURL = baseURLConversionResult.releaseReturnValue();
    JSValue disabledValue;
    if (isNullOrUndefined)
        disabledValue = jsUndefined();
    else {
        disabledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "disabled"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto disabledConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, disabledValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (UNLIKELY(disabledConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.disabled = disabledConversionResult.releaseReturnValue();
    JSValue mediaValue;
    if (isNullOrUndefined)
        mediaValue = jsUndefined();
    else {
        mediaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "media"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto mediaConversionResult = convertOptionalWithDefault<IDLUnion<IDLInterface<MediaList>, IDLDOMString>>(lexicalGlobalObject, mediaValue, [&]() -> ConversionResult<IDLUnion<IDLInterface<MediaList>, IDLDOMString>> { return Converter<IDLUnion<IDLInterface<MediaList>, IDLDOMString>>::ReturnType { emptyString() }; });
    if (UNLIKELY(mediaConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.media = mediaConversionResult.releaseReturnValue();
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_insertRule);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_deleteRule);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_addRule);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_removeRule);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_replace);
static JSC_DECLARE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_replaceSync);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleSheetConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleSheet_ownerRule);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleSheet_cssRules);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleSheet_rules);

class JSCSSStyleSheetPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSStyleSheetPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSStyleSheetPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSStyleSheetPrototype>(vm)) JSCSSStyleSheetPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleSheetPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSStyleSheetPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStyleSheetPrototype, JSCSSStyleSheetPrototype::Base);

using JSCSSStyleSheetDOMConstructor = JSDOMConstructor<JSCSSStyleSheet>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSStyleSheetDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    auto& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSStyleSheetDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "CSSStyleSheet"_s);
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<CSSStyleSheet::Init>>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(optionsConversionResult.hasException(throwScope)))
       return encodedJSValue();
    auto object = CSSStyleSheet::create(document, optionsConversionResult.releaseReturnValue());
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSStyleSheet>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSStyleSheet>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSStyleSheetDOMConstructorConstruct, JSCSSStyleSheetDOMConstructor::construct);

template<> const ClassInfo JSCSSStyleSheetDOMConstructor::s_info = { "CSSStyleSheet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleSheetDOMConstructor) };

template<> JSValue JSCSSStyleSheetDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSStyleSheet::getConstructor(vm, &globalObject);
}

template<> void JSCSSStyleSheetDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSStyleSheet"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSStyleSheet::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSStyleSheetPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleSheetConstructor, 0 } },
    { "ownerRule"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleSheet_ownerRule, 0 } },
    { "cssRules"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleSheet_cssRules, 0 } },
    { "rules"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleSheet_rules, 0 } },
    { "insertRule"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleSheetPrototypeFunction_insertRule, 1 } },
    { "deleteRule"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleSheetPrototypeFunction_deleteRule, 1 } },
    { "addRule"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleSheetPrototypeFunction_addRule, 0 } },
    { "removeRule"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleSheetPrototypeFunction_removeRule, 0 } },
    { "replace"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleSheetPrototypeFunction_replace, 1 } },
    { "replaceSync"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsCSSStyleSheetPrototypeFunction_replaceSync, 1 } },
};

const ClassInfo JSCSSStyleSheetPrototype::s_info = { "CSSStyleSheet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleSheetPrototype) };

void JSCSSStyleSheetPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSStyleSheet::info(), JSCSSStyleSheetPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSStyleSheet::s_info = { "CSSStyleSheet"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleSheet) };

JSCSSStyleSheet::JSCSSStyleSheet(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSStyleSheet>&& impl)
    : JSStyleSheet(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSStyleSheet> JSCSSStyleSheet::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSStyleSheet>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSStyleSheet::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSStyleSheetPrototype::createStructure(vm, &globalObject, JSStyleSheet::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSStyleSheetPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSStyleSheet::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSStyleSheet>(vm, globalObject);
}

JSValue JSCSSStyleSheet::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStyleSheetDOMConstructor, DOMConstructorID::CSSStyleSheet>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleSheetConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSStyleSheetPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSStyleSheet::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSStyleSheet_ownerRuleGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSRule>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ownerRule())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleSheet_ownerRule, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleSheet>::get<jsCSSStyleSheet_ownerRuleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSStyleSheet_cssRulesGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSRuleList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.cssRulesForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleSheet_cssRules, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleSheet>::get<jsCSSStyleSheet_cssRulesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSStyleSheet_rulesGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleSheet& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<CSSRuleList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rules())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleSheet_rules, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleSheet>::get<jsCSSStyleSheet_rulesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunction_insertRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleSheet>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto ruleConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(ruleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.insertRule(ruleConversionResult.releaseReturnValue(), indexConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_insertRule, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunction_insertRuleBody>(*lexicalGlobalObject, *callFrame, "insertRule");
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunction_deleteRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleSheet>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.deleteRule(indexConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_deleteRule, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunction_deleteRuleBody>(*lexicalGlobalObject, *callFrame, "deleteRule");
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunction_addRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleSheet>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto selectorConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(selectorConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto styleConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument1.value());
    if (UNLIKELY(styleConversionResult.hasException(throwScope)))
       return encodedJSValue();
    EnsureStillAliveScope argument2 = callFrame->argument(2);
    auto indexConversionResult = convert<IDLOptional<IDLUnsignedLong>>(*lexicalGlobalObject, argument2.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.addRule(selectorConversionResult.releaseReturnValue(), styleConversionResult.releaseReturnValue(), indexConversionResult.releaseReturnValue()))));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_addRule, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunction_addRuleBody>(*lexicalGlobalObject, *callFrame, "addRule");
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunction_removeRuleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleSheet>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto indexConversionResult = convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(indexConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.removeRule(indexConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_removeRule, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunction_removeRuleBody>(*lexicalGlobalObject, *callFrame, "removeRule");
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunction_replaceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSCSSStyleSheet>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto textConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(textConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<CSSStyleSheet>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.replace(textConversionResult.releaseReturnValue(), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_replace, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunction_replaceBody>(*lexicalGlobalObject, *callFrame, "replace");
}

static inline JSC::EncodedJSValue jsCSSStyleSheetPrototypeFunction_replaceSyncBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSCSSStyleSheet>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto textConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (UNLIKELY(textConversionResult.hasException(throwScope)))
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.replaceSync(textConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsCSSStyleSheetPrototypeFunction_replaceSync, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSCSSStyleSheet>::call<jsCSSStyleSheetPrototypeFunction_replaceSyncBody>(*lexicalGlobalObject, *callFrame, "replaceSync");
}

JSC::GCClient::IsoSubspace* JSCSSStyleSheet::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSStyleSheet, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSStyleSheet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSStyleSheet = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSStyleSheet.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSStyleSheet = std::forward<decltype(space)>(space); }
    );
}

void JSCSSStyleSheet::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSStyleSheet*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, thisObject->scriptExecutionContext()->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSStyleSheet@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13CSSStyleSheetE[]; }
#endif
template<typename T, typename = std::enable_if_t<std::is_same_v<T, CSSStyleSheet>, void>> static inline void verifyVTable(CSSStyleSheet* ptr) {
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSStyleSheet@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore13CSSStyleSheetE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSStyleSheet has subclasses. If CSSStyleSheet has subclasses that get passed
        // to toJS() we currently require CSSStyleSheet you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSStyleSheet>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<CSSStyleSheet>(impl.ptr());
#endif
    return createWrapper<CSSStyleSheet>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSStyleSheet& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSStyleSheet* JSCSSStyleSheet::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSStyleSheet*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
