/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBarcodeDetectorOptions.h"

#include "JSBarcodeFormat.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertSequences.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<BarcodeDetectorOptions>> convertDictionary<BarcodeDetectorOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    BarcodeDetectorOptions result;
    JSValue formatsValue;
    if (isNullOrUndefined)
        formatsValue = jsUndefined();
    else {
        formatsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "formats"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!formatsValue.isUndefined()) {
        auto formatsConversionResult = convert<IDLSequence<IDLEnumeration<BarcodeFormat>>>(lexicalGlobalObject, formatsValue);
        if (UNLIKELY(formatsConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.formats = formatsConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
