/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.netaddr;

import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Enumeration;
import net.java.sip.communicator.impl.netaddr.BsdLocalhostRetriever;
import net.java.sip.communicator.impl.netaddr.HardwareAddressRetriever;
import net.java.sip.communicator.impl.netaddr.Ice4jPacketLogger;
import net.java.sip.communicator.impl.netaddr.NetaddrActivator;
import net.java.sip.communicator.impl.netaddr.NetworkConfigurationWatcher;
import net.java.sip.communicator.impl.netaddr.Win32LocalhostRetriever;
import net.java.sip.communicator.service.dns.DnssecException;
import net.java.sip.communicator.service.netaddr.NetworkAddressManagerService;
import net.java.sip.communicator.service.netaddr.event.NetworkConfigurationChangeListener;
import net.java.sip.communicator.util.Logger;
import net.java.sip.communicator.util.NetworkUtils;
import net.java.sip.communicator.util.SRVRecord;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.Agent;
import org.ice4j.ice.IceMediaStream;
import org.ice4j.ice.harvest.StunCandidateHarvester;
import org.ice4j.ice.harvest.TurnCandidateHarvester;
import org.ice4j.security.LongTermCredential;
import org.ice4j.stack.PacketLogger;
import org.ice4j.stack.StunStack;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.util.OSUtils;

public class NetworkAddressManagerServiceImpl
implements NetworkAddressManagerService {
    private static Logger logger = Logger.getLogger(NetworkAddressManagerServiceImpl.class);
    DatagramSocket localHostFinderSocket = null;
    private static final int RANDOM_ADDR_DISC_PORT = 55721;
    public static final String BIND_RETRIES_PROPERTY_NAME = "net.java.sip.communicator.service.netaddr.BIND_RETRIES";
    public static final int DEFAULT_STUN_SERVER_PORT = 3478;
    private NetworkConfigurationWatcher networkConfigurationWatcher = null;
    public static final String TURN_SRV_NAME = "turn";
    public static final String STUN_SRV_NAME = "stun";

    public void start() {
        this.localHostFinderSocket = this.initRandomPortSocket();
        StunStack.setPacketLogger((PacketLogger)new Ice4jPacketLogger());
    }

    public void stop() {
        try {
            if (this.networkConfigurationWatcher != null) {
                this.networkConfigurationWatcher.stop();
            }
        }
        finally {
            logger.logExit();
        }
    }

    @Override
    public synchronized InetAddress getLocalHost(InetAddress intendedDestination) {
        String osVersion;
        InetAddress localHost = null;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Querying for a localhost address for intended destination '" + intendedDestination + "'"));
        }
        if (OSUtils.IS_WINDOWS && !(osVersion = System.getProperty("os.version")).startsWith("4") && !osVersion.startsWith("5.0")) {
            byte[] src = Win32LocalhostRetriever.getSourceForDestination(intendedDestination.getAddress());
            if (src == null) {
                logger.warn((Object)"Failed to get localhost ");
            } else {
                try {
                    localHost = InetAddress.getByAddress(src);
                }
                catch (UnknownHostException uhe) {
                    logger.warn((Object)"Failed to get localhost", (Throwable)uhe);
                }
            }
        } else if (OSUtils.IS_MAC) {
            try {
                localHost = BsdLocalhostRetriever.getLocalSocketAddress(new InetSocketAddress(intendedDestination, 55721));
            }
            catch (IOException e) {
                logger.warn((Object)"Failed to get localhost", (Throwable)e);
            }
        } else {
            this.localHostFinderSocket.connect(intendedDestination, 55721);
            localHost = this.localHostFinderSocket.getLocalAddress();
            this.localHostFinderSocket.disconnect();
        }
        if (localHost == null) {
            try {
                localHost = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                logger.warn((Object)"Failed to get localhost ", (Throwable)e);
            }
        }
        if (localHost.isAnyLocalAddress()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"Socket returned the ANY local address. Trying a workaround.");
            }
            try {
                if (intendedDestination instanceof Inet6Address) {
                    boolean done = false;
                    Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                    block8: while (!done && ifaces.hasMoreElements()) {
                        Enumeration<InetAddress> addresses = ifaces.nextElement().getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress address = addresses.nextElement();
                            if (!(address instanceof Inet6Address) || address.isAnyLocalAddress() || address.isLinkLocalAddress() || address.isLoopbackAddress() || address.isSiteLocalAddress()) continue;
                            localHost = address;
                            done = true;
                            continue block8;
                        }
                    }
                } else if (intendedDestination instanceof Inet4Address) {
                    boolean done = false;
                    Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                    block10: while (!done && ifaces.hasMoreElements()) {
                        Enumeration<InetAddress> addresses = ifaces.nextElement().getInetAddresses();
                        while (addresses.hasMoreElements()) {
                            InetAddress address = addresses.nextElement();
                            if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                            localHost = address;
                            done = true;
                            continue block10;
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)"Failed to get localhost", (Throwable)e);
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Returning the localhost address '" + localHost + "'"));
        }
        return localHost;
    }

    @Override
    public byte[] getHardwareAddress(NetworkInterface iface) {
        String ifName = null;
        byte[] hwAddress = null;
        try {
            Method method = iface.getClass().getMethod("getHardwareAddress", new Class[0]);
            if (method != null) {
                hwAddress = (byte[])method.invoke((Object)iface, new Object[0]);
                return hwAddress;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ifName = OSUtils.IS_WINDOWS ? iface.getDisplayName() : iface.getName();
        hwAddress = HardwareAddressRetriever.getHardwareAddress(ifName);
        return hwAddress;
    }

    @Override
    public InetSocketAddress getPublicAddressFor(InetAddress dst, int port) throws IOException, BindException {
        DatagramSocket bindTestSocket = new DatagramSocket(port);
        bindTestSocket.close();
        return new InetSocketAddress(this.getLocalHost(dst), port);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private DatagramSocket initRandomPortSocket() {
        DatagramSocket resultSocket = null;
        String bindRetriesStr = NetaddrActivator.getConfigurationService().getString(BIND_RETRIES_PROPERTY_NAME);
        int bindRetries = 5;
        if (bindRetriesStr != null) {
            try {
                bindRetries = Integer.parseInt(bindRetriesStr);
            }
            catch (NumberFormatException ex) {
                logger.error((Object)(bindRetriesStr + " does not appear to be an integer. Defaulting port bind retries to " + bindRetries), (Throwable)ex);
            }
        }
        int currentlyTriedPort = NetworkUtils.getRandomPortNumber();
        for (int i = 0; i < bindRetries; ++i) {
            try {
                resultSocket = new DatagramSocket(currentlyTriedPort);
                break;
            }
            catch (SocketException exc) {
                if (exc.getMessage().indexOf("Address already in use") == -1) {
                    logger.fatal((Object)"An exception occurred while trying to createa local host discovery socket.", (Throwable)exc);
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Port " + currentlyTriedPort + " seems in use."));
                }
                currentlyTriedPort = NetworkUtils.getRandomPortNumber();
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Retrying bind on port " + currentlyTriedPort));
                continue;
            }
        }
        return resultSocket;
    }

    @Override
    public DatagramSocket createDatagramSocket(InetAddress laddr, int preferredPort, int minPort, int maxPort) throws IllegalArgumentException, IOException, BindException {
        if (!NetworkUtils.isValidPortNumber((int)minPort) || !NetworkUtils.isValidPortNumber((int)maxPort)) {
            throw new IllegalArgumentException("minPort (" + minPort + ") and maxPort (" + maxPort + ") should be integers between 1024 and 65535.");
        }
        if (minPort > maxPort) {
            throw new IllegalArgumentException("minPort (" + minPort + ") should be less than or equal to maxPort (" + maxPort + ")");
        }
        if (minPort > preferredPort || preferredPort > maxPort) {
            throw new IllegalArgumentException("preferredPort (" + preferredPort + ") must be between minPort (" + minPort + ") and maxPort (" + maxPort + ")");
        }
        ConfigurationService config = NetaddrActivator.getConfigurationService();
        int bindRetries = config.getInt(BIND_RETRIES_PROPERTY_NAME, 50);
        int port = preferredPort;
        for (int i = 0; i < bindRetries; ++i) {
            try {
                return new DatagramSocket(port, laddr);
            }
            catch (SocketException se) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("Retrying a bind because of a failure to bind to address " + laddr + " and port " + port));
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Since you seem, here's a stack:", (Throwable)se);
                    }
                }
                if (++port <= maxPort) continue;
                port = minPort;
                continue;
            }
        }
        throw new BindException("Could not bind to any port between " + minPort + " and " + (port - 1));
    }

    @Override
    public synchronized void addNetworkConfigurationChangeListener(NetworkConfigurationChangeListener listener) {
        if (this.networkConfigurationWatcher == null) {
            this.networkConfigurationWatcher = new NetworkConfigurationWatcher();
        }
        this.networkConfigurationWatcher.addNetworkConfigurationChangeListener(listener);
    }

    @Override
    public synchronized void removeNetworkConfigurationChangeListener(NetworkConfigurationChangeListener listener) {
        if (this.networkConfigurationWatcher != null) {
            this.networkConfigurationWatcher.removeNetworkConfigurationChangeListener(listener);
        }
    }

    @Override
    public Agent createIceAgent() {
        return new Agent();
    }

    @Override
    public StunCandidateHarvester discoverStunServer(String domainName, byte[] userName, byte[] password) {
        String srvrAddress = null;
        int port = 0;
        try {
            SRVRecord srvRecord = NetworkUtils.getSRVRecord((String)TURN_SRV_NAME, (String)Transport.UDP.toString(), (String)domainName);
            if (srvRecord != null) {
                srvrAddress = srvRecord.getTarget();
            }
            if (srvrAddress != null) {
                return new TurnCandidateHarvester(new TransportAddress(srvrAddress, srvRecord.getPort(), Transport.UDP), new LongTermCredential(userName, password));
            }
            srvRecord = NetworkUtils.getSRVRecord((String)STUN_SRV_NAME, (String)Transport.UDP.toString(), (String)domainName);
            if (srvRecord != null) {
                srvrAddress = srvRecord.getTarget();
                port = srvRecord.getPort();
            }
        }
        catch (ParseException e) {
            logger.info((Object)(domainName + " seems to be causing parse problems"), (Throwable)e);
            srvrAddress = null;
        }
        catch (DnssecException e) {
            logger.warn((Object)("DNSSEC validation for " + domainName + " STUN/TURN failed."), (Throwable)e);
        }
        if (srvrAddress != null) {
            return new StunCandidateHarvester(new TransportAddress(srvrAddress, port, Transport.UDP));
        }
        return null;
    }

    @Override
    public IceMediaStream createIceStream(int rtpPort, String streamName, Agent agent) throws IllegalArgumentException, IOException, BindException {
        return this.createIceStream(2, rtpPort, streamName, agent);
    }

    @Override
    public IceMediaStream createIceStream(int numComponents, int portBase, String streamName, Agent agent) throws IllegalArgumentException, IOException, BindException {
        if (numComponents < 1 || numComponents > 2) {
            throw new IllegalArgumentException("Invalid numComponents value: " + numComponents);
        }
        IceMediaStream stream = agent.createMediaStream(streamName);
        agent.createComponent(stream, Transport.UDP, portBase, portBase, portBase + 100);
        if (numComponents > 1) {
            agent.createComponent(stream, Transport.UDP, portBase + 1, portBase + 1, portBase + 101);
        }
        return stream;
    }
}

